/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.jcr.query.qom.Constraint;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;

@Immutable
public final class IndexPlan
implements Comparable<IndexPlan> {
    private static final Map<String, Object> NO_PARAMETERS = Collections.emptyMap();
    private final String name;
    private final String workspaceName;
    private final String providerName;
    private final int costEstimate;
    private final long cardinalityEstimate;
    private final Float selectivityEstimate;
    private final Collection<Constraint> constraints;
    private final Map<String, Object> parameters;

    public IndexPlan(String name, String workspaceName, String providerName, Collection<Constraint> constraints, int costEstimate, long cardinalityEstimate, float selectivityEstimate, Map<String, Object> parameters) {
        CheckArg.isNotEmpty((String)name, (String)"name");
        CheckArg.isNonNegative((int)costEstimate, (String)"costEstimate");
        CheckArg.isNonNegative((long)cardinalityEstimate, (String)"cardinalityEstimate");
        this.name = name;
        this.workspaceName = workspaceName;
        this.providerName = providerName;
        this.constraints = constraints;
        this.costEstimate = costEstimate;
        this.cardinalityEstimate = cardinalityEstimate;
        this.selectivityEstimate = selectivityEstimate < 0.0f ? null : Float.valueOf(selectivityEstimate);
        this.parameters = parameters == null ? NO_PARAMETERS : parameters;
    }

    public long getCardinalityEstimate() {
        return this.cardinalityEstimate;
    }

    public int getCostEstimate() {
        return this.costEstimate;
    }

    public boolean hasSelectivityEstimate() {
        return this.selectivityEstimate != null;
    }

    public Float getSelectivityEstimate() {
        return this.selectivityEstimate;
    }

    public String getName() {
        return this.name;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public Collection<Constraint> getConstraints() {
        return this.constraints;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" cost=").append(this.getCostEstimate());
        sb.append(", cardinality=").append(this.getCardinalityEstimate());
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            sb.append(", ").append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.toString();
    }

    @Override
    public int compareTo(IndexPlan that) {
        if (that == this) {
            return 0;
        }
        if (that == null) {
            return 1;
        }
        return this.getCostEstimate() - that.costEstimate;
    }
}

