/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine.process;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.CachedNodeSupplier;
import org.modeshape.jcr.query.BufferManager;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.query.engine.process.AbstractNodeKeysSequence;
import org.modeshape.jcr.query.engine.process.BufferedRows;
import org.modeshape.jcr.query.model.TypeSystem;

public class IntersectSequence
extends AbstractNodeKeysSequence {
    public IntersectSequence(String workspaceName, NodeSequence leftSequence, NodeSequence rightSequence, TypeSystem types, BufferManager bufferMgr, CachedNodeSupplier nodeCache, boolean pack, boolean useHeap) {
        super(workspaceName, leftSequence, rightSequence, types, bufferMgr, nodeCache, pack, useHeap);
    }

    @Override
    protected NodeSequence.Batch batchWrapper(NodeSequence.Batch leftBatch) {
        return new IntersectBatch(leftBatch);
    }

    public String toString() {
        return "(intersect left=" + this.leftSequence + ", right=" + this.delegate + ", on " + this.extractor + " )";
    }

    protected class IntersectBatch
    implements NodeSequence.Batch {
        private final NodeSequence.Batch leftBatch;
        private Iterator<BufferedRows.BufferedRow> matchingRightRows;
        private BufferedRows.BufferedRow currentRight;

        protected IntersectBatch(NodeSequence.Batch leftBatch) {
            this.leftBatch = leftBatch;
        }

        @Override
        public int width() {
            return IntersectSequence.this.totalWidth;
        }

        @Override
        public String getWorkspaceName() {
            return IntersectSequence.this.workspaceName;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public long rowCount() {
            return -1L;
        }

        @Override
        public boolean hasNext() {
            if (this.matchingRightRows != null && this.matchingRightRows.hasNext()) {
                return true;
            }
            while (this.leftBatch.hasNext()) {
                this.leftBatch.nextRow();
                Object keyInLeftRow = IntersectSequence.this.keyInLeftRow(this.leftBatch);
                this.matchingRightRows = IntersectSequence.this.matchingRightRows(keyInLeftRow);
                if (this.matchingRightRows == null) continue;
                break;
            }
            return this.matchingRightRows != null && this.matchingRightRows.hasNext();
        }

        @Override
        public void nextRow() {
            this.currentRight = this.matchingRightRows.next();
        }

        @Override
        public CachedNode getNode() {
            if (this.currentRight == null) {
                throw new NoSuchElementException();
            }
            return this.currentRight.getNode();
        }

        @Override
        public CachedNode getNode(int index) {
            if (this.currentRight == null) {
                throw new NoSuchElementException();
            }
            return this.currentRight.getNode(index);
        }

        @Override
        public float getScore() {
            if (this.currentRight == null) {
                throw new NoSuchElementException();
            }
            return this.currentRight.getScore();
        }

        @Override
        public float getScore(int index) {
            if (this.currentRight == null) {
                throw new NoSuchElementException();
            }
            return this.currentRight.getScore(index);
        }
    }
}

