/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.spi.index.provider;

import javax.jcr.query.qom.And;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.FullTextSearch;
import javax.jcr.query.qom.Length;
import javax.jcr.query.qom.LowerCase;
import javax.jcr.query.qom.NodeLocalName;
import javax.jcr.query.qom.NodeName;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.Or;
import javax.jcr.query.qom.PropertyExistence;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.UpperCase;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.api.index.IndexColumnDefinition;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.api.query.qom.ArithmeticOperand;
import org.modeshape.jcr.api.query.qom.Between;
import org.modeshape.jcr.api.query.qom.NodeDepth;
import org.modeshape.jcr.api.query.qom.NodeId;
import org.modeshape.jcr.api.query.qom.NodePath;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.api.query.qom.ReferenceValue;
import org.modeshape.jcr.api.query.qom.Relike;
import org.modeshape.jcr.api.query.qom.SetCriteria;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.spi.index.IndexCostCalculator;
import org.modeshape.jcr.value.Name;

public class IndexUsage {
    private final IndexDefinition defn;
    private final QueryContext context;
    private final Name indexedNodeTypeName;

    public IndexUsage(QueryContext context, IndexCostCalculator calculator, IndexDefinition defn) {
        this.context = context;
        this.defn = defn;
        this.indexedNodeTypeName = this.name(defn.getNodeTypeName());
    }

    public boolean indexAppliesTo(Constraint constraint) {
        if (constraint instanceof Comparison) {
            return this.indexAppliesTo((Comparison)constraint);
        }
        if (constraint instanceof And) {
            return this.indexAppliesTo((And)constraint);
        }
        if (constraint instanceof Or) {
            Or or = (Or)constraint;
            return this.indexAppliesTo(or.getConstraint1()) || this.indexAppliesTo(or.getConstraint2());
        }
        if (constraint instanceof Not) {
            Not not = (Not)constraint;
            return this.indexAppliesTo(not.getConstraint());
        }
        if (constraint instanceof Between) {
            return this.indexAppliesTo((Between)constraint);
        }
        if (constraint instanceof SetCriteria) {
            return this.indexAppliesTo((SetCriteria)constraint);
        }
        if (constraint instanceof Relike) {
            return this.indexAppliesTo((Relike)constraint);
        }
        if (constraint instanceof PropertyExistence) {
            return this.indexAppliesTo((PropertyExistence)constraint);
        }
        return false;
    }

    protected boolean indexAppliesTo(Comparison constraint) {
        Operator operator = Operator.forSymbol((String)constraint.getOperator());
        return this.applies(operator) && this.applies(constraint.getOperand1());
    }

    protected boolean indexAppliesTo(And and) {
        return this.indexAppliesTo(and.getConstraint1()) || this.indexAppliesTo(and.getConstraint2());
    }

    protected boolean indexAppliesTo(Or or) {
        return this.indexAppliesTo(or.getConstraint1()) || this.indexAppliesTo(or.getConstraint2());
    }

    protected boolean indexAppliesTo(Not not) {
        return this.indexAppliesTo(not.getConstraint());
    }

    protected boolean indexAppliesTo(Between constraint) {
        return this.applies(constraint.getOperand());
    }

    protected boolean indexAppliesTo(SetCriteria constraint) {
        return this.applies(constraint.getOperand());
    }

    protected boolean indexAppliesTo(Relike constraint) {
        return this.applies(constraint.getOperand2());
    }

    protected boolean indexAppliesTo(PropertyExistence constraint) {
        return this.matchesSelectorName(constraint.getSelectorName()) && this.defn.appliesToProperty(constraint.getPropertyName());
    }

    protected boolean applies(Operator operator) {
        return true;
    }

    protected boolean applies(DynamicOperand operand) {
        if (operand instanceof PropertyValue) {
            return this.applies((PropertyValue)operand);
        }
        if (operand instanceof UpperCase) {
            return this.applies((UpperCase)operand);
        }
        if (operand instanceof LowerCase) {
            return this.applies((LowerCase)operand);
        }
        if (operand instanceof Length) {
            return this.applies((Length)operand);
        }
        if (operand instanceof ArithmeticOperand) {
            return this.applies((ArithmeticOperand)operand);
        }
        if (operand instanceof NodeName) {
            return this.applies((NodeName)operand);
        }
        if (operand instanceof NodeLocalName) {
            return this.applies((NodeLocalName)operand);
        }
        if (operand instanceof NodePath) {
            return this.applies((NodePath)operand);
        }
        if (operand instanceof NodeId) {
            return this.applies((NodeId)operand);
        }
        if (operand instanceof NodeDepth) {
            return this.applies((NodeDepth)operand);
        }
        if (operand instanceof ReferenceValue) {
            return this.applies((ReferenceValue)operand);
        }
        if (operand instanceof FullTextSearch) {
            return this.applies((FullTextSearch)operand);
        }
        return false;
    }

    protected boolean applies(PropertyValue operand) {
        return this.matchesSelectorName(operand.getSelectorName()) && this.defn.appliesToProperty(operand.getPropertyName());
    }

    protected boolean applies(UpperCase operand) {
        return this.applies(operand.getOperand());
    }

    protected boolean applies(LowerCase operand) {
        return this.applies(operand.getOperand());
    }

    protected boolean applies(Length operand) {
        return this.applies(operand.getPropertyValue());
    }

    protected boolean applies(ArithmeticOperand operand) {
        return this.applies(operand.getLeft()) && this.applies(operand.getRight());
    }

    protected boolean applies(NodeName operand) {
        return this.defn.appliesToProperty("jcr:name");
    }

    protected boolean applies(NodeLocalName operand) {
        return this.defn.appliesToProperty("mode:localName");
    }

    protected boolean applies(NodePath operand) {
        return this.defn.appliesToProperty("jcr:path");
    }

    protected boolean applies(NodeId operand) {
        return this.defn.appliesToProperty("jcr:id");
    }

    protected boolean applies(NodeDepth operand) {
        return this.defn.appliesToProperty("mode:depth");
    }

    protected boolean applies(ReferenceValue operand) {
        if (this.matchesSelectorName(operand.getSelectorName())) {
            String refPropName = operand.getPropertyName();
            if (refPropName != null) {
                return this.isReferenceIndex(refPropName);
            }
            return this.isReferenceIndex();
        }
        return false;
    }

    protected boolean applies(FullTextSearch operand) {
        return true;
    }

    protected final boolean matchesSelectorName(String selectorName) {
        Name selectedNodeTypeName = this.name(selectorName);
        return this.nodeTypes().isTypeOrSubtype(selectedNodeTypeName, this.indexedNodeTypeName);
    }

    protected final NodeTypes nodeTypes() {
        return this.context.getNodeTypes();
    }

    protected final Name name(String name) {
        return (Name)this.context.getExecutionContext().getValueFactories().getNameFactory().create(name);
    }

    protected final boolean isReferenceIndex(String refPropName) {
        assert (refPropName != null);
        if (this.defn.appliesToProperty(refPropName)) {
            Name columnName = this.name(refPropName);
            return this.nodeTypes().isReferenceProperty(this.indexedNodeTypeName, columnName);
        }
        return false;
    }

    protected final boolean isReferenceIndex() {
        for (IndexColumnDefinition columnDefn : this.defn) {
            Name columnName = this.name(columnDefn.getPropertyName());
            if (!this.nodeTypes().isReferenceProperty(this.indexedNodeTypeName, columnName)) continue;
            return true;
        }
        return false;
    }
}

