/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.io.File;
import java.nio.file.Paths;
import java.util.Collections;
import javax.jcr.RepositoryException;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.JoinCondition;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.modeshape.common.collection.Problems;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.api.index.IndexColumnDefinition;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.api.query.qom.Relike;
import org.modeshape.jcr.cache.change.ChangeSetAdapter;
import org.modeshape.jcr.index.local.ManagedLocalIndex;
import org.modeshape.jcr.index.local.ManagedLocalIndexBuilder;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.spi.index.IndexCostCalculator;
import org.modeshape.jcr.spi.index.IndexFeedback;
import org.modeshape.jcr.spi.index.provider.IndexProvider;
import org.modeshape.jcr.spi.index.provider.IndexUsage;
import org.modeshape.jcr.spi.index.provider.ManagedIndex;

public class LocalIndexProvider
extends IndexProvider {
    private static final Float MAX_SELECTIVITY = new Float(1.0f);
    private static final String DB_FILENAME = "local-indexes.db";
    private String directory;
    private String path;
    private String relativeTo;
    private DB db;

    public String getDirectory() {
        return this.directory;
    }

    @Override
    protected void doInitialize() throws RepositoryException {
        if (this.directory == null && this.relativeTo != null && this.path != null) {
            try {
                File rel = new File(this.relativeTo);
                File dir = Paths.get(rel.toURI()).resolve(this.path).toFile();
                this.directory = dir.getAbsolutePath();
            }
            catch (RuntimeException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        if (this.directory == null) {
            throw new RepositoryException(JcrI18n.localIndexProviderMustHaveDirectory.text(new Object[]{this.getRepositoryName()}));
        }
        this.logger().debug("Initializing the local index provider '{0}' in repository '{1}' at: {2}", new Object[]{this.getName(), this.getRepositoryName(), this.directory});
        File dir = new File(this.directory);
        if (!dir.exists()) {
            this.logger().debug("Attempting to create directory for local indexes in repository '{1}' at: {0}", new Object[]{dir.getAbsolutePath(), this.getRepositoryName()});
            if (dir.mkdirs()) {
                this.logger().debug("Created directory for local indexes in repository '{1}' at: {0}", new Object[]{dir.getAbsolutePath(), this.getRepositoryName()});
            } else {
                this.logger().debug("Unable to create directory for local indexes in repository '{1}' at: {0}", new Object[]{dir.getAbsolutePath(), this.getRepositoryName()});
            }
        }
        if (!dir.canRead()) {
            throw new RepositoryException(JcrI18n.localIndexProviderDirectoryMustBeReadable.text(new Object[]{dir, this.getRepositoryName()}));
        }
        if (!dir.canWrite()) {
            throw new RepositoryException(JcrI18n.localIndexProviderDirectoryMustBeWritable.text(new Object[]{dir, this.getRepositoryName()}));
        }
        File file = new File(dir, DB_FILENAME);
        if (this.logger().isDebugEnabled()) {
            String action = file.exists() ? "Opening" : "Creating";
            this.logger().debug("{0} the local index provider database for repository '{1}' at: {2}", new Object[]{action, this.getRepositoryName(), file.getAbsolutePath()});
        }
        this.db = DBMaker.newFileDB((File)file).make();
        this.logger().trace("Found the index files {0} in index database for repository '{1}' at: {2}", new Object[]{this.db.getCatalog(), this.getRepositoryName(), file.getAbsolutePath()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postShutdown() {
        this.logger().debug("Shutting down the local index provider '{0}' in repository '{1}'", new Object[]{this.getName(), this.getRepositoryName()});
        if (this.db != null) {
            try {
                this.db.commit();
                this.db.close();
            }
            finally {
                this.db = null;
            }
        }
    }

    @Override
    public void validateProposedIndex(ExecutionContext context, IndexDefinition defn, NodeTypes.Supplier nodeTypeSupplier, Problems problems) {
        ManagedLocalIndexBuilder.create(context, defn, nodeTypeSupplier, null).validate(problems);
    }

    @Override
    protected ManagedIndex createIndex(IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher, IndexFeedback feedback) {
        ManagedLocalIndexBuilder builder = ManagedLocalIndexBuilder.create(this.context(), defn, nodeTypesSupplier, matcher);
        this.logger().debug("Index provider '{0}' is creating index in workspace '{1}': {2}", new Object[]{this.getName(), workspaceName, defn});
        ManagedLocalIndex index = builder.build(workspaceName, this.db);
        feedback.scan(workspaceName);
        return index;
    }

    @Override
    protected ManagedIndex updateIndex(IndexDefinition oldDefn, IndexDefinition updatedDefn, ManagedIndex existingIndex, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher, IndexFeedback feedback) {
        if (!this.isChanged(oldDefn, updatedDefn)) {
            this.logger().debug("Index provider '{0}' is not updating index in workspace '{1}' because there were no changes: {2}", new Object[]{this.getName(), workspaceName, updatedDefn});
            return existingIndex;
        }
        existingIndex.shutdown(true);
        ManagedLocalIndexBuilder builder = ManagedLocalIndexBuilder.create(this.context(), updatedDefn, nodeTypesSupplier, matcher);
        this.logger().debug("Index provider '{0}' is updating index in workspace '{1}': {2}", new Object[]{this.getName(), workspaceName, updatedDefn});
        ManagedLocalIndex index = builder.build(workspaceName, this.db);
        feedback.scan(workspaceName);
        return index;
    }

    @Override
    protected void removeIndex(IndexDefinition oldDefn, ManagedIndex existingIndex, String workspaceName) {
        this.logger().debug("Index provider '{0}' is removing index in workspace '{1}': {2}", new Object[]{this.getName(), workspaceName, oldDefn});
        existingIndex.shutdown(true);
    }

    private boolean isChanged(IndexDefinition defn1, IndexDefinition defn2) {
        if (defn1.getKind() != defn2.getKind()) {
            return true;
        }
        if (defn1.size() != defn2.size()) {
            return true;
        }
        for (int i = 0; i != defn1.size(); ++i) {
            IndexColumnDefinition col2;
            IndexColumnDefinition col1 = defn1.getColumnDefinition(i);
            if (!this.isChanged(col1, col2 = defn2.getColumnDefinition(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isChanged(IndexColumnDefinition defn1, IndexColumnDefinition defn2) {
        if (defn1.getColumnType() != defn2.getColumnType()) {
            return true;
        }
        return !defn1.getPropertyName().equals(defn2.getPropertyName());
    }

    @Override
    protected void planUseOfIndex(QueryContext context, IndexCostCalculator calculator, String workspaceName, ManagedIndex index, final IndexDefinition defn) {
        ManagedLocalIndex localIndex = (ManagedLocalIndex)index;
        IndexUsage planner = new IndexUsage(context, calculator, defn){

            @Override
            protected boolean applies(FullTextSearch search) {
                return false;
            }

            @Override
            protected boolean indexAppliesTo(Relike constraint) {
                for (IndexColumnDefinition columnDefn : defn) {
                    if (columnDefn.getColumnType() == 1) continue;
                    return false;
                }
                return super.indexAppliesTo(constraint);
            }

            @Override
            protected boolean indexAppliesTo(Comparison constraint) {
                if ("jcr.operator.like".equals(constraint.getOperator())) {
                    return false;
                }
                return super.indexAppliesTo(constraint);
            }
        };
        for (Constraint constraint : calculator.andedConstraints()) {
            if (!planner.indexAppliesTo(constraint)) continue;
            this.logger().trace("Index '{0}' in '{1}' provider applies to query in workspace '{2}' with constraint: {3}", new Object[]{defn.getName(), this.getName(), workspaceName, constraint});
            long cardinality = localIndex.estimateCardinality(constraint, context.getVariables());
            long total = localIndex.estimateTotalCount();
            Float selectivity = null;
            if (total >= 0L) {
                double ratio = (double)cardinality / (double)total;
                selectivity = cardinality <= total ? new Float(ratio) : MAX_SELECTIVITY;
            }
            calculator.addIndex(defn.getName(), workspaceName, this.getName(), Collections.singleton(constraint), 100, cardinality, selectivity);
        }
        for (JoinCondition joinCondition : calculator.joinConditions()) {
            if (!planner.indexAppliesTo(joinCondition)) continue;
            this.logger().trace("Index '{0}' in '{1}' provider applies to query in workspace '{2}' with constraint: {3}", new Object[]{defn.getName(), this.getName(), workspaceName, joinCondition});
            long total = localIndex.estimateTotalCount();
            calculator.addIndex(defn.getName(), workspaceName, this.getName(), Collections.singleton(joinCondition), 100, total);
        }
    }
}

