/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache;

import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.value.Name;

public abstract class SiblingCounter {
    public abstract int countSiblingsNamed(Name var1);

    public static SiblingCounter noSiblings() {
        return SiblingCounter.constant(0);
    }

    public static SiblingCounter oneSibling() {
        return SiblingCounter.constant(1);
    }

    public static SiblingCounter constant(final int count) {
        assert (count > -1);
        return new SiblingCounter(){

            @Override
            public int countSiblingsNamed(Name childName) {
                return count;
            }
        };
    }

    public static SiblingCounter create(final ChildReferences childRefs) {
        assert (childRefs != null);
        return new SiblingCounter(){

            @Override
            public int countSiblingsNamed(Name childName) {
                return childRefs.getChildCount(childName);
            }
        };
    }

    public static SiblingCounter create(final CachedNode node, final NodeCache cache) {
        assert (node != null);
        assert (cache != null);
        return new SiblingCounter(){

            @Override
            public int countSiblingsNamed(Name childName) {
                return node.getChildReferences(cache).getChildCount(childName);
            }
        };
    }

    public static SiblingCounter alter(final SiblingCounter counter, final int delta) {
        assert (counter != null);
        return new SiblingCounter(){

            @Override
            public int countSiblingsNamed(Name childName) {
                int count = counter.countSiblingsNamed(childName) + delta;
                return count > 0 ? count : 0;
            }
        };
    }
}

