/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheTopology {
    private static Log log = LogFactory.getLog(CacheTopology.class);
    private static final boolean trace = log.isTraceEnabled();
    private final int topologyId;
    private final ConsistentHash currentCH;
    private final ConsistentHash pendingCH;

    public CacheTopology(int topologyId, ConsistentHash currentCH, ConsistentHash pendingCH) {
        if (pendingCH != null && !pendingCH.getMembers().containsAll(currentCH.getMembers())) {
            throw new IllegalArgumentException("A cache topology's pending consistent hash must contain all the current consistent hash's members");
        }
        this.topologyId = topologyId;
        this.currentCH = currentCH;
        this.pendingCH = pendingCH;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    public ConsistentHash getCurrentCH() {
        return this.currentCH;
    }

    public ConsistentHash getPendingCH() {
        return this.pendingCH;
    }

    public List<Address> getMembers() {
        if (this.pendingCH != null) {
            return this.pendingCH.getMembers();
        }
        if (this.currentCH != null) {
            return this.currentCH.getMembers();
        }
        return InfinispanCollections.emptyList();
    }

    public ConsistentHash getReadConsistentHash() {
        return this.currentCH;
    }

    public ConsistentHash getWriteConsistentHash() {
        if (this.pendingCH != null) {
            return this.pendingCH;
        }
        return this.currentCH;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheTopology that = (CacheTopology)o;
        if (this.topologyId != that.topologyId) {
            return false;
        }
        if (this.currentCH != null ? !this.currentCH.equals(that.currentCH) : that.currentCH != null) {
            return false;
        }
        return !(this.pendingCH != null ? !this.pendingCH.equals(that.pendingCH) : that.pendingCH != null);
    }

    public int hashCode() {
        int result = this.topologyId;
        result = 31 * result + (this.currentCH != null ? this.currentCH.hashCode() : 0);
        result = 31 * result + (this.pendingCH != null ? this.pendingCH.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CacheTopology{id=" + this.topologyId + ", currentCH=" + this.currentCH + ", pendingCH=" + this.pendingCH + '}';
    }

    public final void logRoutingTableInformation() {
        if (trace) {
            log.tracef("Current consistent hash's routing table: %s", this.currentCH.getRoutingTableAsString());
            if (this.pendingCH != null) {
                log.tracef("Pending consistent hash's routing table: %s", this.pendingCH.getRoutingTableAsString());
            }
        }
    }

    public static class Externalizer
    extends AbstractExternalizer<CacheTopology> {
        public void writeObject(ObjectOutput output, CacheTopology cacheTopology) throws IOException {
            output.writeInt(cacheTopology.topologyId);
            output.writeObject(cacheTopology.currentCH);
            output.writeObject(cacheTopology.pendingCH);
        }

        public CacheTopology readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            int topologyId = unmarshaller.readInt();
            ConsistentHash currentCH = (ConsistentHash)unmarshaller.readObject();
            ConsistentHash pendingCH = (ConsistentHash)unmarshaller.readObject();
            return new CacheTopology(topologyId, currentCH, pendingCH);
        }

        public Integer getId() {
            return 75;
        }

        public Set<Class<? extends CacheTopology>> getTypeClasses() {
            return Collections.singleton(CacheTopology.class);
        }
    }
}

