/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Collections;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.BinaryValueUnused;
import org.modeshape.jcr.cache.change.BinaryValueUsageChange;
import org.modeshape.jcr.cache.change.BinaryValueUsed;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.value.BinaryKey;

@ThreadSafe
public class BackupObserver
implements ChangeSetListener {
    private final Queue<NodeKey> changedNodes;
    private final Set<BinaryKey> usedBinaryKeys = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<BinaryKey> unusedBinaryKeys = Collections.newSetFromMap(new ConcurrentHashMap());

    protected BackupObserver(Queue<NodeKey> changedNodes) {
        this.changedNodes = changedNodes;
    }

    @Override
    public void notify(ChangeSet changeSet) {
        if (changeSet == null) {
            return;
        }
        this.changedNodes.addAll(changeSet.changedNodes());
        for (Change change : changeSet) {
            BinaryKey key;
            BinaryValueUsageChange unused;
            if (change instanceof BinaryValueUnused) {
                unused = (BinaryValueUnused)change;
                key = unused.getKey();
                if (this.usedBinaryKeys.contains(key)) {
                    this.usedBinaryKeys.remove(key);
                    break;
                }
                this.unusedBinaryKeys.add(key);
            }
            if (!(change instanceof BinaryValueUsed)) continue;
            unused = (BinaryValueUsed)change;
            key = unused.getKey();
            if (this.unusedBinaryKeys.contains(key)) {
                this.unusedBinaryKeys.remove(key);
                break;
            }
            this.usedBinaryKeys.add(key);
        }
    }

    public Iterable<BinaryKey> getUnusedBinaryKeys() {
        return this.unusedBinaryKeys;
    }

    public Iterable<BinaryKey> getUsedBinaryKeys() {
        return this.usedBinaryKeys;
    }
}

