/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.SecureHash;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.binary.AbstractBinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.FileLocks;
import org.modeshape.jcr.value.binary.InMemoryBinaryValue;
import org.modeshape.jcr.value.binary.NamedLocks;
import org.modeshape.jcr.value.binary.SharedLockingInputStream;
import org.modeshape.jcr.value.binary.StoredBinaryValue;

@ThreadSafe
public class FileSystemBinaryStore
extends AbstractBinaryStore {
    private static final String EXTRACTED_TEXT_SUFFIX = "-extracted-text";
    private static final String MIME_TYPE_SUFFIX = "-mime-type";
    private static final ConcurrentHashMap<String, FileSystemBinaryStore> INSTANCES = new ConcurrentHashMap();
    private static final String TEMP_FILE_PREFIX = "ms-fs-binstore";
    private static final String TEMP_FILE_SUFFIX = "hashing";
    protected static final String TRASH_DIRECTORY_NAME = "trash";
    private final File directory;
    private final File trash;
    private final NamedLocks locks = new NamedLocks();
    private volatile boolean initialized = false;

    public static FileSystemBinaryStore create(File directory) {
        FileSystemBinaryStore existing;
        String key = directory.getAbsolutePath();
        FileSystemBinaryStore store = INSTANCES.get(key);
        if (store == null && (existing = INSTANCES.putIfAbsent(key, store = new FileSystemBinaryStore(directory))) != null) {
            store = existing;
        }
        return store;
    }

    protected FileSystemBinaryStore(File directory) {
        this.directory = directory;
        this.trash = new File(this.directory, TRASH_DIRECTORY_NAME);
    }

    public File getDirectory() {
        return this.directory;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BinaryValue storeValue(InputStream stream, boolean markAsUnused) throws BinaryStoreException {
        BinaryValue binaryValue;
        File tmpFile = null;
        BinaryValue value = null;
        try {
            SecureHash.HashingInputStream hashingStream = SecureHash.createHashingStream((SecureHash.Algorithm)SecureHash.Algorithm.SHA_1, (InputStream)stream);
            tmpFile = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            IoUtil.write((InputStream)hashingStream, (OutputStream)new BufferedOutputStream(new FileOutputStream(tmpFile)), (int)65536);
            hashingStream.close();
            byte[] sha1 = hashingStream.getHash();
            BinaryKey key = new BinaryKey(sha1);
            long numberOfBytes = tmpFile.length();
            if (numberOfBytes < this.getMinimumBinarySizeInBytes()) {
                byte[] content = IoUtil.readBytes((File)tmpFile);
                tmpFile.delete();
                value = new InMemoryBinaryValue(this, key, content);
            } else {
                value = this.saveTempFileToStore(tmpFile, key, numberOfBytes);
                if (markAsUnused) {
                    this.markAsUnused(key);
                }
            }
            binaryValue = value;
            if (tmpFile == null) return binaryValue;
        }
        catch (IOException e) {
            try {
                throw new BinaryStoreException(e);
                catch (NoSuchAlgorithmException e2) {
                    throw new SystemFailureException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (tmpFile == null) throw throwable;
                try {
                    tmpFile.delete();
                    throw throwable;
                }
                catch (Throwable t) {
                    Logger.getLogger(this.getClass()).warn(t, (I18nResource)JcrI18n.unableToDeleteTemporaryFile, new Object[]{tmpFile.getAbsolutePath(), t.getMessage()});
                }
                throw throwable;
            }
        }
        try {
            tmpFile.delete();
            return binaryValue;
        }
        catch (Throwable t) {
            Logger.getLogger(this.getClass()).warn(t, (I18nResource)JcrI18n.unableToDeleteTemporaryFile, new Object[]{tmpFile.getAbsolutePath(), t.getMessage()});
        }
        return binaryValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryValue saveTempFileToStore(File tmpFile, BinaryKey key, long numberOfBytes) throws BinaryStoreException {
        File persistedFile = this.findFile(this.directory, key, true);
        Lock lock = this.locks.writeLock(key.toString());
        try {
            if (persistedFile.exists()) {
                this.removeTrashFile(key);
                StoredBinaryValue storedBinaryValue = new StoredBinaryValue(this, key, numberOfBytes);
                return storedBinaryValue;
            }
            this.moveFileExclusively(tmpFile, persistedFile, key);
        }
        finally {
            lock.unlock();
        }
        return new StoredBinaryValue(this, key, persistedFile.length());
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private File getTrashFile(BinaryKey key, boolean createIfAbsent) throws BinaryStoreException {
        File trashFile = this.findFile(this.trash, key, createIfAbsent);
        if (trashFile.exists() && trashFile.canRead()) {
            return trashFile;
        }
        if (!createIfAbsent) {
            return null;
        }
        File persistedFile = this.findFile(this.directory, key, false);
        if (!persistedFile.exists()) {
            return null;
        }
        Lock writeLock = this.locks.writeLock(key.toString());
        try {
            if (!trashFile.exists() || !trashFile.canRead()) {
                IoUtil.write((String)"", (OutputStream)new BufferedOutputStream(new FileOutputStream(trashFile)));
            }
            File file = trashFile;
            return file;
        }
        catch (IOException e) {
            throw new BinaryStoreException(e);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeTrashFile(BinaryKey key) throws BinaryStoreException {
        File trashFile = this.getTrashFile(key, false);
        if (trashFile == null) {
            return false;
        }
        Lock lock = this.locks.writeLock(key.toString());
        try {
            if (trashFile.exists()) {
                if (!trashFile.delete()) {
                    this.touch(trashFile);
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void moveFileExclusively(File original, File destination, BinaryKey key) throws BinaryStoreException {
        try {
            for (int i = 0; i != 5; ++i) {
                destination.getParentFile().mkdirs();
                if (destination.getParentFile().exists()) break;
                this.sleep(500L);
            }
            if (!destination.getParentFile().exists()) {
                String path = destination.getParentFile().getAbsolutePath();
                throw new BinaryStoreException(JcrI18n.unableToCreateDirectoryForBinaryStore.text(new Object[]{path, key}));
            }
            FileLocks.WrappedLock fileLock = FileLocks.get().writeLock(original);
            try {
                if (original.renameTo(destination)) {
                    return;
                }
            }
            finally {
                fileLock.unlock();
            }
            int bufferSize = AbstractBinaryStore.bestBufferSize(original.length());
            fileLock = FileLocks.get().writeLock(destination);
            try {
                FileChannel destinationChannel = fileLock.lockedFileChannel();
                OutputStream output = Channels.newOutputStream(destinationChannel);
                output = new BufferedOutputStream(output, bufferSize);
                RandomAccessFile originalRaf = new RandomAccessFile(original, "r");
                FileChannel originalChannel = originalRaf.getChannel();
                InputStream input = Channels.newInputStream(originalChannel);
                input = new BufferedInputStream(input, bufferSize);
                IoUtil.write((InputStream)input, (OutputStream)output, (int)bufferSize);
                originalRaf.close();
            }
            finally {
                try {
                    fileLock.unlock();
                }
                finally {
                    original.delete();
                }
            }
        }
        catch (IOException e) {
            throw new BinaryStoreException(e);
        }
    }

    protected final File findFile(File directory, BinaryKey key, boolean createParentDirsIfMissing) throws BinaryStoreException {
        if (!this.initialized) {
            this.initializeStorage(directory);
            this.initialized = true;
        }
        String sha1 = key.toString();
        File first = new File(directory, sha1.substring(0, 2));
        File second = new File(first, sha1.substring(2, 4));
        File third = new File(second, sha1.substring(4, 6));
        if (createParentDirsIfMissing) {
            third.mkdirs();
        }
        File file = new File(third, sha1);
        return file;
    }

    @Override
    public InputStream getInputStream(BinaryKey key) throws BinaryStoreException {
        File persistedFile = this.findFile(this.directory, key, false);
        if (!persistedFile.exists() || !persistedFile.canRead()) {
            throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{key, this.directory.getPath()}));
        }
        return new SharedLockingInputStream(key, persistedFile, this.locks);
    }

    protected void initializeStorage(File directory) throws BinaryStoreException {
    }

    @Override
    public void markAsUsed(Iterable<BinaryKey> keys) throws BinaryStoreException {
        if (keys == null) {
            return;
        }
        for (BinaryKey key : keys) {
            this.removeAllTrashFilesFor(key);
        }
    }

    public void upgradeTrashContentFormat() throws BinaryStoreException {
        this.moveTrashFilesToMainStorage(this.trash);
    }

    private void moveTrashFilesToMainStorage(File trash) throws BinaryStoreException {
        File[] files = trash.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.moveTrashFilesToMainStorage(file);
                continue;
            }
            if (!file.canRead() || !file.isFile() || file.length() <= 0L) continue;
            BinaryKey key = new BinaryKey(file.getName());
            File persistedFile = this.findFile(this.directory, key, true);
            this.moveFileExclusively(file, persistedFile, key);
            this.getTrashFile(key, true);
        }
    }

    protected boolean removeAllTrashFilesFor(BinaryKey key) throws BinaryStoreException {
        return this.removeTrashFile(key) | this.removeTrashFile(this.createKeyFromSourceWithSuffix(key, EXTRACTED_TEXT_SUFFIX)) | this.removeTrashFile(this.createKeyFromSourceWithSuffix(key, MIME_TYPE_SUFFIX));
    }

    @Override
    public void markAsUnused(Iterable<BinaryKey> keys) throws BinaryStoreException {
        if (keys == null) {
            return;
        }
        for (BinaryKey key : keys) {
            this.markAsUnused(key);
        }
    }

    protected void markAsUnused(BinaryKey key) throws BinaryStoreException {
        BinaryKey mimeTypeKey;
        File mimeTypeFile;
        File persistedFile = this.findFile(this.directory, key, false);
        if (!persistedFile.exists()) {
            return;
        }
        this.getTrashFile(key, true);
        BinaryKey textExtractionKey = this.createKeyFromSourceWithSuffix(key, EXTRACTED_TEXT_SUFFIX);
        File textFile = this.findFile(this.directory, textExtractionKey, false);
        if (textFile.exists()) {
            this.getTrashFile(textExtractionKey, true);
        }
        if ((mimeTypeFile = this.findFile(this.directory, mimeTypeKey = this.createKeyFromSourceWithSuffix(key, MIME_TYPE_SUFFIX), false)).exists()) {
            this.getTrashFile(mimeTypeKey, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void touch(File file) throws BinaryStoreException {
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            FileLocks.WrappedLock fileLock = FileLocks.get().writeLock(file);
            try {
                raf.setLength(raf.length());
            }
            finally {
                try {
                    raf.close();
                }
                finally {
                    fileLock.unlock();
                }
            }
        }
        catch (IOException e) {
            throw new BinaryStoreException(e);
        }
    }

    protected void pruneEmptyDirectories(File directory, File removeable) {
        assert (directory != null);
        assert (removeable != null);
        if (directory.equals(removeable)) {
            return;
        }
        assert (this.isAncestor(directory, removeable));
        while (!removeable.equals(directory)) {
            if (removeable.exists() && !removeable.delete()) {
                return;
            }
            removeable = removeable.getParentFile();
        }
    }

    private boolean isAncestor(File ancestor, File descendant) {
        for (File parent = descendant; parent != null; parent = parent.getParentFile()) {
            if (!parent.equals(ancestor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeValuesUnusedLongerThan(long minimumAge, TimeUnit unit) throws BinaryStoreException {
        long oldestTimestamp = System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(minimumAge, unit);
        try {
            this.removeFilesOlderThan(oldestTimestamp, this.trash);
        }
        catch (IOException e) {
            throw new BinaryStoreException(e);
        }
        catch (BinaryStoreException bse) {
            throw bse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFilesOlderThan(long oldestTimestamp, File parentDirectory) throws IOException, BinaryStoreException {
        if (parentDirectory == null || !parentDirectory.exists() || parentDirectory.isFile()) {
            return;
        }
        boolean pruneTrashRequired = false;
        File[] files = parentDirectory.listFiles();
        if (files == null) {
            return;
        }
        for (File fileOrDir : files) {
            File file;
            if (fileOrDir == null || !fileOrDir.exists()) continue;
            if (fileOrDir.isDirectory()) {
                this.removeFilesOlderThan(oldestTimestamp, fileOrDir);
                continue;
            }
            if (!fileOrDir.isFile() || (file = fileOrDir).lastModified() >= oldestTimestamp) continue;
            String sha1 = file.getName();
            BinaryKey key = new BinaryKey(sha1);
            File persistedFile = this.findFile(this.directory, key, false);
            if (persistedFile.exists() && persistedFile.canRead()) {
                Lock lock = this.locks.writeLock(sha1);
                try {
                    if (!persistedFile.exists() || !persistedFile.delete() || !this.removeAllTrashFilesFor(key)) continue;
                    pruneTrashRequired = true;
                    continue;
                }
                finally {
                    lock.unlock();
                }
            }
            if (!this.removeAllTrashFilesFor(key)) continue;
            pruneTrashRequired = true;
        }
        if (pruneTrashRequired) {
            this.pruneEmptyDirectories(this.trash, parentDirectory);
        }
    }

    @Override
    public String getExtractedText(BinaryValue source) throws BinaryStoreException {
        if (!this.binaryValueExists(source)) {
            throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{source.getKey(), this.directory}));
        }
        BinaryKey extractedTextKey = this.createKeyFromSourceWithSuffix(source.getKey(), EXTRACTED_TEXT_SUFFIX);
        return this.storedStringAtKey(extractedTextKey);
    }

    private String storedStringAtKey(BinaryKey key) throws BinaryStoreException {
        InputStream is = null;
        try {
            is = this.getInputStream(key);
        }
        catch (BinaryStoreException e) {
            return null;
        }
        try {
            return IoUtil.read((InputStream)is);
        }
        catch (IOException e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    public void storeExtractedText(BinaryValue source, String extractedText) throws BinaryStoreException {
        if (!this.binaryValueExists(source)) {
            return;
        }
        BinaryKey extractedTextKey = this.createKeyFromSourceWithSuffix(source.getKey(), EXTRACTED_TEXT_SUFFIX);
        this.storeStringAtKey(extractedText, extractedTextKey);
    }

    private void storeStringAtKey(String string, BinaryKey key) throws BinaryStoreException {
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile(TEMP_FILE_PREFIX, "hashing-extracted-text");
            IoUtil.write((String)string, (OutputStream)new BufferedOutputStream(new FileOutputStream(tmpFile)));
            this.saveTempFileToStore(tmpFile, key, tmpFile.length());
        }
        catch (IOException e) {
            throw new BinaryStoreException(e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    @Override
    protected String getStoredMimeType(BinaryValue binaryValue) throws BinaryStoreException {
        if (!this.binaryValueExists(binaryValue)) {
            throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{binaryValue.getKey(), this.directory}));
        }
        BinaryKey mimeTypeKey = this.createKeyFromSourceWithSuffix(binaryValue.getKey(), MIME_TYPE_SUFFIX);
        return this.storedStringAtKey(mimeTypeKey);
    }

    @Override
    protected void storeMimeType(BinaryValue binaryValue, String mimeType) throws BinaryStoreException {
        if (!this.binaryValueExists(binaryValue)) {
            return;
        }
        BinaryKey mimeTypeKey = this.createKeyFromSourceWithSuffix(binaryValue.getKey(), MIME_TYPE_SUFFIX);
        this.storeStringAtKey(mimeType, mimeTypeKey);
    }

    private boolean binaryValueExists(BinaryValue binaryValue) throws BinaryStoreException {
        File fileInMainStorage = this.findFile(this.directory, binaryValue.getKey(), false);
        return fileInMainStorage.exists() && fileInMainStorage.canRead();
    }

    private BinaryKey createKeyFromSourceWithSuffix(BinaryKey sourceKey, String suffix) {
        String extractTextKeyContent = sourceKey.toString() + suffix;
        return BinaryKey.keyFor(extractTextKeyContent.getBytes());
    }

    @Override
    public Iterable<BinaryKey> getAllBinaryKeys() throws BinaryStoreException {
        HashSet<BinaryKey> keys = new HashSet<BinaryKey>();
        HashSet<BinaryKey> keysToExclude = new HashSet<BinaryKey>();
        if (this.isReadableDir(this.directory)) {
            for (File first : this.directory.listFiles()) {
                if (!this.isReadableDir(first)) continue;
                for (File second : first.listFiles()) {
                    if (!this.isReadableDir(second)) continue;
                    for (File third : second.listFiles()) {
                        if (!this.isReadableDir(third)) continue;
                        for (File file : third.listFiles()) {
                            BinaryKey key;
                            String filename;
                            if (!file.canRead() || !file.isFile() || (filename = file.getName()).length() != 40 || this.getTrashFile(key = new BinaryKey(file.getName()), false) != null) continue;
                            keys.add(key);
                            BinaryKey mimeTypeKey = this.createKeyFromSourceWithSuffix(key, MIME_TYPE_SUFFIX);
                            keysToExclude.add(mimeTypeKey);
                            BinaryKey textKey = this.createKeyFromSourceWithSuffix(key, EXTRACTED_TEXT_SUFFIX);
                            keysToExclude.add(textKey);
                        }
                    }
                }
            }
        }
        keys.removeAll(keysToExclude);
        return keys;
    }

    private boolean isReadableDir(File dir) {
        return dir != null && dir.isDirectory() && dir.canRead();
    }
}

