/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.util.Comparator;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.DB;
import org.mapdb.Serializer;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.cache.change.ChangeSetAdapter;
import org.modeshape.jcr.index.local.IndexValues;
import org.modeshape.jcr.index.local.LocalDuplicateIndex;
import org.modeshape.jcr.index.local.LocalEnumeratedIndex;
import org.modeshape.jcr.index.local.LocalIndexException;
import org.modeshape.jcr.index.local.LocalUniqueIndex;
import org.modeshape.jcr.index.local.MapDB;
import org.modeshape.jcr.spi.index.provider.ManagedIndexBuilder;
import org.modeshape.jcr.spi.index.provider.ProvidedIndex;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.ValueComparators;
import org.modeshape.jcr.value.ValueFactory;

public abstract class LocalIndexBuilder<T>
extends ManagedIndexBuilder {
    protected final MapDB.Serializers serializers;

    public static <T> LocalIndexBuilder<T> create(ExecutionContext context, IndexDefinition defn, NodeTypes.Supplier nodeTypesSupplier, String workspaceName, ChangeSetAdapter.NodeTypePredicate matcher, DB db) {
        SimpleProblems problems = new SimpleProblems();
        LocalIndexBuilder.validate(defn, (Problems)problems);
        if (problems.hasErrors()) {
            throw new LocalIndexException(problems.toString());
        }
        PropertyType actualPropertyType = LocalIndexBuilder.determineActualPropertyType(defn.getColumnDefinition(0));
        return new SingleColumnIndexBuilder(context, defn, nodeTypesSupplier, workspaceName, matcher, actualPropertyType, db);
    }

    protected LocalIndexBuilder(ExecutionContext context, IndexDefinition defn, NodeTypes.Supplier nodeTypesSupplier, String workspaceName, ChangeSetAdapter.NodeTypePredicate matcher) {
        super(context, defn, workspaceName, nodeTypesSupplier, matcher);
        this.serializers = MapDB.serializers(this.context.getValueFactories());
    }

    protected static void validate(IndexDefinition defn, Problems problems) {
        if (!defn.hasSingleColumn()) {
            problems.addError(JcrI18n.localIndexProviderDoesNotSupportMultiColumnIndexes, new Object[]{defn.getName(), defn.getProviderName()});
        }
        switch (defn.getKind()) {
            case TEXT: {
                problems.addError(JcrI18n.localIndexProviderDoesNotSupportTextIndexes, new Object[]{defn.getName(), defn.getProviderName()});
            }
        }
    }

    protected final String indexName() {
        return this.defn.getName();
    }

    protected abstract Serializer<T> getSerializer();

    protected abstract Comparator<T> getComparator();

    protected static class SingleColumnIndexBuilder<T>
    extends LocalIndexBuilder<T> {
        private final PropertyType type;
        private final Serializer<T> serializer;
        private final BTreeKeySerializer<T> btreeKeySerializer;
        private final Comparator<T> comparator;
        private final BTreeKeySerializer<String> stringBtreeSerializer;
        private final Comparator<String> stringComparator;
        private final Class<T> clazz;
        private final IndexValues.Converter<T> converter;
        private final IndexValues.Converter<String> stringConverter;
        private final ValueFactory<T> factory;
        private final ValueFactory<String> stringFactory;
        private final DB db;

        protected SingleColumnIndexBuilder(ExecutionContext context, IndexDefinition defn, NodeTypes.Supplier nodeTypesSupplier, String workspaceName, ChangeSetAdapter.NodeTypePredicate matcher, PropertyType actualPropertyType, DB db) {
            super(context, defn, nodeTypesSupplier, workspaceName, matcher);
            assert (defn.hasSingleColumn());
            this.type = actualPropertyType;
            this.clazz = this.type.getValueClass();
            this.serializer = this.serializers.serializerFor(this.clazz);
            this.comparator = this.type.getComparator();
            this.btreeKeySerializer = this.serializers.bTreeKeySerializerFor(this.clazz, this.comparator, false);
            this.factory = this.context.getValueFactories().getValueFactory(this.type);
            this.converter = IndexValues.converter(this.factory);
            this.stringComparator = ValueComparators.STRING_COMPARATOR;
            this.stringFactory = this.context.getValueFactories().getStringFactory();
            this.stringBtreeSerializer = this.serializers.bTreeKeySerializerFor(String.class, this.stringComparator, false);
            this.stringConverter = IndexValues.converter(this.stringFactory);
            this.db = db;
        }

        @Override
        protected Serializer<T> getSerializer() {
            return this.serializer;
        }

        @Override
        protected Comparator<T> getComparator() {
            return this.comparator;
        }

        protected PropertyType getColumnType() {
            return this.type;
        }

        protected IndexValues.Converter<T> getConverter() {
            return this.converter;
        }

        protected BTreeKeySerializer<T> getBTreeKeySerializer() {
            return this.btreeKeySerializer;
        }

        @Override
        protected ProvidedIndex<?> buildMultiValueIndex(ExecutionContext context, IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
            return LocalDuplicateIndex.create(this.indexName(), workspaceName, this.db, this.getConverter(), this.getSerializer(), this.getComparator());
        }

        @Override
        protected ProvidedIndex<?> buildUniqueValueIndex(ExecutionContext context, IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
            return LocalUniqueIndex.create(this.indexName(), workspaceName, this.db, this.getConverter(), this.getBTreeKeySerializer(), this.getSerializer());
        }

        @Override
        protected ProvidedIndex<?> buildEnumeratedIndex(ExecutionContext context, IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
            return LocalEnumeratedIndex.create(defn.getName(), workspaceName, this.db, this.stringConverter, this.stringBtreeSerializer);
        }

        @Override
        protected ProvidedIndex<?> buildTextIndex(ExecutionContext context, IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
            throw new UnsupportedOperationException("should not ever see this because validation should prevent such indexes from being used");
        }

        @Override
        protected ProvidedIndex<?> buildNodeTypeIndex(ExecutionContext context, IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
            return LocalEnumeratedIndex.create(defn.getName(), workspaceName, this.db, this.stringConverter, this.stringBtreeSerializer);
        }
    }
}

