/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.mimetype;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import org.apache.tika.metadata.Metadata;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.SelfClosingInputStream;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.Environment;
import org.modeshape.jcr.mimetype.MimeTypeDetector;

@Immutable
@ThreadSafe
public abstract class TikaMimeTypeDetector
implements MimeTypeDetector {
    protected final Logger logger;

    protected TikaMimeTypeDetector(Environment environment) {
        assert (environment != null);
        this.logger = Logger.getLogger(this.getClass());
        ClassLoader loader = environment.getClassLoader(this.getClass().getClassLoader(), "org.modeshape.extractor.tika");
        this.logger.debug("Initializing mime-type detector...", new Object[0]);
        this.initDetector(loader);
        this.logger.debug("Successfully initialized detector: {0}", new Object[]{this.getClass().getName()});
    }

    @Override
    public String mimeTypeOf(String name, Binary binaryValue) throws RepositoryException, IOException {
        Metadata metadata = new Metadata();
        if (!StringUtil.isBlank((String)name)) {
            metadata.set("resourceName", name);
        }
        if (binaryValue == null) {
            return name == null ? null : this.detect(null, metadata);
        }
        InputStream stream = binaryValue.getStream();
        if (stream instanceof SelfClosingInputStream) {
            stream = ((SelfClosingInputStream)stream).wrappedStream();
        }
        return this.detect(stream, metadata);
    }

    protected abstract void initDetector(ClassLoader var1);

    protected abstract String detect(InputStream var1, Metadata var2);
}

