/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.spi.index.provider;

import java.util.ArrayList;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.api.index.IndexColumnDefinition;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.cache.change.ChangeSetAdapter;
import org.modeshape.jcr.spi.index.provider.DefaultManagedIndex;
import org.modeshape.jcr.spi.index.provider.IndexChangeAdapter;
import org.modeshape.jcr.spi.index.provider.IndexChangeAdapters;
import org.modeshape.jcr.spi.index.provider.ManagedIndex;
import org.modeshape.jcr.spi.index.provider.ProvidedIndex;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.ValueFactory;

@Immutable
public abstract class ManagedIndexBuilder {
    protected final ExecutionContext context;
    protected final IndexDefinition defn;
    protected final NodeTypes.Supplier nodeTypesSupplier;
    protected final ChangeSetAdapter.NodeTypePredicate matcher;
    protected final String workspaceName;

    protected ManagedIndexBuilder(ExecutionContext context, IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
        this.context = context;
        this.workspaceName = workspaceName;
        this.defn = defn;
        this.nodeTypesSupplier = nodeTypesSupplier;
        this.matcher = matcher;
    }

    public ManagedIndex build() {
        ArrayList<IndexChangeAdapter> changeAdapters = new ArrayList<IndexChangeAdapter>();
        ProvidedIndex<?> index = null;
        switch (this.defn.getKind()) {
            case VALUE: {
                index = this.buildMultiValueIndex(this.context, this.defn, this.workspaceName, this.nodeTypesSupplier, this.matcher);
                for (int i = 0; i < this.defn.size(); ++i) {
                    PropertyType type;
                    IndexColumnDefinition columnDef = this.defn.getColumnDefinition(i);
                    if (this.isPrimaryTypeIndex(columnDef, type = ManagedIndexBuilder.determineActualPropertyType(columnDef))) {
                        changeAdapters.add(IndexChangeAdapters.forPrimaryType(this.context, this.matcher, this.workspaceName, index));
                        continue;
                    }
                    if (this.isMixinTypesIndex(columnDef, type)) {
                        changeAdapters.add(IndexChangeAdapters.forMixinTypes(this.context, this.matcher, this.workspaceName, index));
                        continue;
                    }
                    if (this.isNodeNameIndex(columnDef, type)) {
                        changeAdapters.add(IndexChangeAdapters.forNodeName(this.context, this.matcher, this.workspaceName, index));
                        continue;
                    }
                    if (this.isNodeLocalNameIndex(columnDef, type)) {
                        changeAdapters.add(IndexChangeAdapters.forNodeLocalName(this.context, this.matcher, this.workspaceName, index));
                        continue;
                    }
                    if (this.isNodePathIndex(columnDef, type)) {
                        changeAdapters.add(IndexChangeAdapters.forNodePath(this.context, this.matcher, this.workspaceName, index));
                        continue;
                    }
                    if (this.isNodeDepthIndex(columnDef, type)) {
                        changeAdapters.add(IndexChangeAdapters.forNodeDepth(this.context, this.matcher, this.workspaceName, index));
                        continue;
                    }
                    Name propertyName = this.name(columnDef.getPropertyName());
                    assert (propertyName != null);
                    ValueFactory<?> valueFactory = this.context.getValueFactories().getValueFactory(type);
                    changeAdapters.add(IndexChangeAdapters.forProperty(this.context, this.matcher, this.workspaceName, propertyName, valueFactory, index));
                }
                break;
            }
            case UNIQUE_VALUE: {
                index = this.buildUniqueValueIndex(this.context, this.defn, this.workspaceName, this.nodeTypesSupplier, this.matcher);
                for (int i = 0; i < this.defn.size(); ++i) {
                    IndexColumnDefinition columnDef = this.defn.getColumnDefinition(i);
                    PropertyType type = ManagedIndexBuilder.determineActualPropertyType(columnDef);
                    Name propertyName = this.name(columnDef.getPropertyName());
                    assert (propertyName != null);
                    ValueFactory<?> valueFactory = this.context.getValueFactories().getValueFactory(type);
                    changeAdapters.add(IndexChangeAdapters.forUniqueValuedProperty(this.context, this.matcher, this.workspaceName, propertyName, valueFactory, index));
                }
                break;
            }
            case ENUMERATED_VALUE: {
                index = this.buildEnumeratedIndex(this.context, this.defn, this.workspaceName, this.nodeTypesSupplier, this.matcher);
                for (int i = 0; i < this.defn.size(); ++i) {
                    IndexColumnDefinition columnDef = this.defn.getColumnDefinition(i);
                    Name propertyName = this.name(columnDef.getPropertyName());
                    assert (propertyName != null);
                    changeAdapters.add(IndexChangeAdapters.forEnumeratedProperty(this.context, this.matcher, this.workspaceName, propertyName, index));
                }
                break;
            }
            case NODE_TYPE: {
                index = this.buildNodeTypeIndex(this.context, this.defn, this.workspaceName, this.nodeTypesSupplier, this.matcher);
                if (this.defn.size() > 1) {
                    throw new IllegalArgumentException("Cannot have a multi column node-type index");
                }
                String property = this.defn.getColumnDefinition(0).getPropertyName();
                if (property == null) {
                    property = this.defn.getName();
                }
                changeAdapters.add(IndexChangeAdapters.forNodeTypes(property, this.context, this.matcher, this.workspaceName, index));
                break;
            }
            case TEXT: {
                index = this.buildTextIndex(this.context, this.defn, this.workspaceName, this.nodeTypesSupplier, this.matcher);
                ValueFactory<String> valueFactory = this.context.getValueFactories().getValueFactory(PropertyType.STRING);
                for (int i = 0; i < this.defn.size(); ++i) {
                    IndexColumnDefinition columnDef = this.defn.getColumnDefinition(i);
                    PropertyType type = ManagedIndexBuilder.determineActualPropertyType(columnDef);
                    Name propertyName = this.name(columnDef.getPropertyName());
                    assert (propertyName != null);
                    if (this.isNodeNameIndex(columnDef, type)) {
                        changeAdapters.add(IndexChangeAdapters.forNodeName(this.context, this.matcher, this.workspaceName, index));
                        continue;
                    }
                    if (this.isNodeLocalNameIndex(columnDef, type)) {
                        changeAdapters.add(IndexChangeAdapters.forNodeLocalName(this.context, this.matcher, this.workspaceName, index));
                        continue;
                    }
                    if (this.isNodePathIndex(columnDef, type)) {
                        changeAdapters.add(IndexChangeAdapters.forNodePath(this.context, this.matcher, this.workspaceName, index));
                        continue;
                    }
                    changeAdapters.add(IndexChangeAdapters.forTextProperty(this.context, this.matcher, this.workspaceName, propertyName, valueFactory, index));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected index kind on: " + this.defn);
            }
        }
        assert (!changeAdapters.isEmpty());
        IndexChangeAdapter adapter = changeAdapters.size() == 1 ? (IndexChangeAdapter)changeAdapters.get(0) : IndexChangeAdapters.forMultipleColumns(this.context, this.matcher, this.workspaceName, index, changeAdapters);
        return new DefaultManagedIndex(index, adapter);
    }

    protected boolean isPrimaryTypeIndex(IndexColumnDefinition columnDefn, PropertyType type) {
        return this.matches(columnDefn, JcrLexicon.PRIMARY_TYPE) && this.isType(type, PropertyType.NAME);
    }

    protected boolean isMixinTypesIndex(IndexColumnDefinition columnDefn, PropertyType type) {
        return this.matches(columnDefn, JcrLexicon.MIXIN_TYPES) && this.isType(type, PropertyType.NAME);
    }

    protected boolean isNodeNameIndex(IndexColumnDefinition columnDefn, PropertyType type) {
        return this.matches(columnDefn, JcrLexicon.NAME) && this.isType(type, PropertyType.NAME);
    }

    protected boolean isNodeLocalNameIndex(IndexColumnDefinition columnDefn, PropertyType type) {
        return this.matches(columnDefn, ModeShapeLexicon.LOCALNAME) && this.isType(type, PropertyType.STRING);
    }

    protected boolean isNodeDepthIndex(IndexColumnDefinition columnDefn, PropertyType type) {
        return this.matches(columnDefn, ModeShapeLexicon.DEPTH) && this.isType(type, PropertyType.LONG);
    }

    protected boolean isNodePathIndex(IndexColumnDefinition columnDefn, PropertyType type) {
        return this.matches(columnDefn, JcrLexicon.PATH) && this.isType(type, PropertyType.PATH);
    }

    protected final Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    protected final boolean matches(IndexColumnDefinition defn, Name name) {
        return defn.getPropertyName().equals(name.getString(this.context.getNamespaceRegistry()));
    }

    protected final boolean matches(String actual, Name name) {
        return actual.equals(name.getString(this.context.getNamespaceRegistry()));
    }

    protected final boolean isType(PropertyType propType, PropertyType expected) {
        return propType == expected;
    }

    protected static PropertyType determineActualPropertyType(IndexColumnDefinition columnDefn) {
        PropertyType type = PropertyType.valueFor(columnDefn.getColumnType());
        switch (type) {
            case BOOLEAN: 
            case DATE: 
            case DECIMAL: 
            case DOUBLE: 
            case LONG: 
            case STRING: 
            case NAME: 
            case PATH: {
                return type;
            }
            case BINARY: 
            case OBJECT: 
            case REFERENCE: 
            case SIMPLEREFERENCE: 
            case WEAKREFERENCE: 
            case URI: {
                return PropertyType.STRING;
            }
        }
        assert (false) : "should never get here";
        return type;
    }

    protected abstract ProvidedIndex<?> buildMultiValueIndex(ExecutionContext var1, IndexDefinition var2, String var3, NodeTypes.Supplier var4, ChangeSetAdapter.NodeTypePredicate var5);

    protected abstract ProvidedIndex<?> buildUniqueValueIndex(ExecutionContext var1, IndexDefinition var2, String var3, NodeTypes.Supplier var4, ChangeSetAdapter.NodeTypePredicate var5);

    protected abstract ProvidedIndex<?> buildEnumeratedIndex(ExecutionContext var1, IndexDefinition var2, String var3, NodeTypes.Supplier var4, ChangeSetAdapter.NodeTypePredicate var5);

    protected abstract ProvidedIndex<?> buildTextIndex(ExecutionContext var1, IndexDefinition var2, String var3, NodeTypes.Supplier var4, ChangeSetAdapter.NodeTypePredicate var5);

    protected abstract ProvidedIndex<?> buildNodeTypeIndex(ExecutionContext var1, IndexDefinition var2, String var3, NodeTypes.Supplier var4, ChangeSetAdapter.NodeTypePredicate var5);
}

