/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jcr.RepositoryException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.infinispan.schematic.document.ParsingException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.NoSuchRepositoryException;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.api.NamedRepository;
import org.modeshape.jcr.api.Repositories;
import org.modeshape.jcr.api.RepositoriesContainer;

@ThreadSafe
public final class JcrRepositoriesContainer
implements RepositoriesContainer {
    protected static final Logger LOG = Logger.getLogger(JcrRepositoriesContainer.class);
    protected static final String REPOSITORY_NAME_URL_PARAM = "repositoryName";
    protected static final String FILE_PROTOCOL = "file:";
    protected static final String JNDI_PROTOCOL = "jndi:";
    protected static final ModeShapeEngine ENGINE = new ModeShapeEngine();

    public JcrRepository getRepository(String repositoryName, Map parameters) throws RepositoryException {
        String repositoryURL;
        if (!StringUtil.isBlank((String)repositoryName)) {
            try {
                JcrRepository repository = this.engine().getRepository(repositoryName);
                if (repository.getState() == ModeShapeEngine.State.STARTING || repository.getState() == ModeShapeEngine.State.RUNNING) {
                    return repository;
                }
            }
            catch (NoSuchRepositoryException repository) {
                // empty catch block
            }
        }
        if (StringUtil.isBlank((String)(repositoryURL = this.repositoryURLFromParams(parameters)))) {
            LOG.debug("No repository URL parameter found", new Object[0]);
            return null;
        }
        HashMap<String, String> configParams = parameters;
        if (!StringUtil.isBlank((String)repositoryName)) {
            configParams = new HashMap<String, String>(parameters);
            configParams.put("org.modeshape.jcr.RepositoryName", repositoryName);
        }
        if (repositoryURL.toLowerCase().startsWith(JNDI_PROTOCOL)) {
            return new JNDIRepositoryLookup().repository(configParams, repositoryURL);
        }
        return new UrlRepositoryLookup().repository(configParams, repositoryURL);
    }

    public Set<String> getRepositoryNames(Map<?, ?> parameters) throws RepositoryException {
        Set<String> repositoryNames = this.engine().getRepositoryNames();
        String repositoryURL = this.repositoryURLFromParams(parameters);
        if (repositoryURL == null) {
            LOG.debug("No repository URL parameter found", new Object[0]);
            return repositoryNames;
        }
        if (repositoryURL.toLowerCase().startsWith(JNDI_PROTOCOL)) {
            Set<String> jndiRepositories = new JNDIRepositoryLookup().repositoryNames(parameters, repositoryURL);
            repositoryNames.addAll(jndiRepositories);
        } else {
            JcrRepository repository = new UrlRepositoryLookup().repository(parameters, repositoryURL);
            if (repository != null) {
                repositoryNames.add(repository.getName());
            }
        }
        return repositoryNames;
    }

    public Future<Boolean> shutdown() {
        return ENGINE.shutdown();
    }

    public boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            return ENGINE.shutdown().get(timeout, unit);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e, (I18nResource)JcrI18n.errorShuttingDownJcrRepositoryFactory, new Object[0]);
            return false;
        }
        catch (TimeoutException e) {
            LOG.warn((Throwable)e, (I18nResource)JcrI18n.timeoutWhileShuttingRepositoryDown, new Object[0]);
            return false;
        }
    }

    protected ModeShapeEngine engine() {
        switch (ENGINE.getState()) {
            case NOT_RUNNING: {
                ENGINE.start();
                break;
            }
            case STOPPING: {
                try {
                    ENGINE.shutdown().get(10L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {}
                break;
            }
        }
        return ENGINE;
    }

    private String repositoryURLFromParams(Map<?, ?> parameters) {
        if (parameters == null) {
            LOG.debug("The supplied parameters are null", new Object[0]);
            return null;
        }
        Object rawUrl = parameters.get("org.modeshape.jcr.URL");
        if (rawUrl == null) {
            LOG.debug("No parameter found with key: org.modeshape.jcr.URL", new Object[0]);
            return null;
        }
        return rawUrl.toString();
    }

    protected String repositoryNameFrom(String url, Map<?, ?> parameters) {
        Object repoName = parameters.get("org.modeshape.jcr.RepositoryName");
        if (repoName != null) {
            return repoName.toString();
        }
        int queryBeginIndex = url.indexOf("?") + 1;
        if (queryBeginIndex > 0 && queryBeginIndex < url.length()) {
            String query = url.substring(queryBeginIndex);
            for (String keyValuePair : query.split("&")) {
                String[] splitPair = keyValuePair.split("=");
                if (splitPair.length != 2 || !REPOSITORY_NAME_URL_PARAM.equals(splitPair[0])) continue;
                return splitPair[1];
            }
        }
        return null;
    }

    protected class JNDIRepositoryLookup {
        protected JNDIRepositoryLookup() {
        }

        private Object doJNDILookup(String jndiName, Map<?, ?> parameters) throws RepositoryException {
            if (jndiName == null) {
                return null;
            }
            try {
                InitialContext ic = new InitialContext(this.hashtable(parameters));
                return ic.lookup(jndiName);
            }
            catch (NamingException e) {
                throw new RepositoryException((Throwable)e);
            }
        }

        protected JcrRepository repository(Map<?, ?> parameters, String repositoryURL) throws RepositoryException {
            String jndiName = repositoryURL.substring(JcrRepositoriesContainer.JNDI_PROTOCOL.length());
            if (jndiName.indexOf("?") > 0) {
                jndiName = jndiName.substring(0, jndiName.indexOf("?"));
            }
            String repositoryName = JcrRepositoriesContainer.this.repositoryNameFrom(repositoryURL, parameters);
            Object jndiObject = this.doJNDILookup(jndiName, parameters);
            if (jndiObject instanceof ModeShapeEngine) {
                return this.repositoryFromEngine((ModeShapeEngine)jndiObject, jndiName, repositoryName);
            }
            if (jndiObject instanceof JcrRepository) {
                return (JcrRepository)jndiObject;
            }
            return null;
        }

        protected Set<String> repositoryNames(Map<?, ?> parameters, String repositoryURL) throws RepositoryException {
            String jndiName = repositoryURL.substring(JcrRepositoriesContainer.JNDI_PROTOCOL.length());
            Object jndiObject = this.doJNDILookup(jndiName, parameters);
            if (jndiObject instanceof NamedRepository) {
                return Collections.singleton(((NamedRepository)jndiObject).getName());
            }
            if (jndiObject instanceof Repositories) {
                return ((Repositories)jndiObject).getRepositoryNames();
            }
            return Collections.emptySet();
        }

        private JcrRepository repositoryFromEngine(ModeShapeEngine engine, String jndiName, String repositoryName) {
            switch (engine.getState()) {
                case NOT_RUNNING: 
                case STOPPING: {
                    LOG.error((I18nResource)JcrI18n.engineAtJndiLocationIsNotRunning, new Object[]{jndiName});
                    return null;
                }
            }
            if (repositoryName == null && engine.getRepositories().size() == 1) {
                repositoryName = engine.getRepositories().keySet().iterator().next();
            }
            if (StringUtil.isBlank((String)repositoryName)) {
                return null;
            }
            if (repositoryName != null) {
                repositoryName = repositoryName.trim();
            }
            try {
                JcrRepository repository = engine.getRepository(repositoryName);
                switch (repository.getState()) {
                    case RUNNING: 
                    case STARTING: {
                        return repository;
                    }
                }
                LOG.debug("The '{0}' repository in JNDI at '{1}' is not (yet) running, but may be (re)started when needed.", new Object[]{repositoryName, jndiName});
                return repository;
            }
            catch (NoSuchRepositoryException e) {
                LOG.warn((I18nResource)JcrI18n.repositoryNotFoundInEngineAtJndiLocation, new Object[]{repositoryName, jndiName});
                return null;
            }
        }

        private Hashtable<String, String> hashtable(Map<?, ?> map) {
            if (map == null) {
                return new Hashtable<String, String>();
            }
            Hashtable<String, String> hash = new Hashtable<String, String>(map.size());
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Object value = entry.getValue();
                hash.put(entry.getKey().toString(), value != null ? value.toString() : null);
            }
            return hash;
        }
    }

    protected class UrlRepositoryLookup {
        protected UrlRepositoryLookup() {
        }

        protected JcrRepository repository(Map<?, ?> parameters, String repositoryURL) throws RepositoryException {
            String repositoryName = JcrRepositoriesContainer.this.repositoryNameFrom(repositoryURL, parameters);
            JcrRepository repository = this.lookForAlreadyDeployedRepositoryKey(repositoryURL);
            if (repository != null) {
                return repository;
            }
            RepositoryConfiguration configuration = this.loadRepositoryConfigurationFrom(repositoryURL);
            repository = this.lookForAlreadyDeployedRepositoryName(configuration.getName());
            if (repository != null) {
                return StringUtil.isBlank((String)repositoryName) || configuration.getName().equalsIgnoreCase(repositoryName) ? repository : null;
            }
            try {
                repository = ENGINE.deploy(configuration);
                repository.start();
                if (StringUtil.isBlank((String)repositoryName) || repository.getName().equals(repositoryName)) {
                    return repository;
                }
                LOG.warn((I18nResource)JcrI18n.repositoryNotFound, new Object[]{repositoryName, repositoryURL, parameters});
                return null;
            }
            catch (RepositoryException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }

        private JcrRepository lookForAlreadyDeployedRepositoryKey(String key) {
            if (JcrRepositoriesContainer.this.engine().getRepositoryKeys().contains(key)) {
                try {
                    return JcrRepositoriesContainer.this.engine().getRepository(key);
                }
                catch (NoSuchRepositoryException noSuchRepositoryException) {
                    // empty catch block
                }
            }
            return null;
        }

        private JcrRepository lookForAlreadyDeployedRepositoryName(String name) {
            if (JcrRepositoriesContainer.this.engine().getRepositoryNames().contains(name)) {
                try {
                    return JcrRepositoriesContainer.this.engine().getRepository(name);
                }
                catch (NoSuchRepositoryException noSuchRepositoryException) {
                    // empty catch block
                }
            }
            return null;
        }

        private RepositoryConfiguration loadRepositoryConfigurationFrom(String repositoryURL) throws RepositoryException {
            try {
                assert (!repositoryURL.toLowerCase().startsWith(JcrRepositoriesContainer.JNDI_PROTOCOL));
                try {
                    URL url = new URL(repositoryURL);
                    if (!repositoryURL.toLowerCase().startsWith(JcrRepositoriesContainer.FILE_PROTOCOL)) {
                        return RepositoryConfiguration.read(url);
                    }
                    url = this.removeQueryParameters(url);
                    try {
                        return RepositoryConfiguration.read(url);
                    }
                    catch (ParsingException pe) {
                        String path = url.getPath().replaceFirst("//+", "");
                        try {
                            return RepositoryConfiguration.read(path);
                        }
                        catch (FileNotFoundException e) {
                            path = path.replaceFirst("/+", "");
                            try {
                                return RepositoryConfiguration.read(path);
                            }
                            catch (FileNotFoundException e2) {
                                throw e;
                            }
                        }
                    }
                }
                catch (MalformedURLException e) {
                    return RepositoryConfiguration.read(repositoryURL);
                }
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }

        private URL removeQueryParameters(URL url) {
            try {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath());
            }
            catch (MalformedURLException e) {
                return url;
            }
        }
    }
}

