/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.txn;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.document.WorkspaceCache;

public abstract class Transactions {
    protected final TransactionManager txnMgr;
    protected final Logger logger = Logger.getLogger(Transactions.class);

    protected Transactions(TransactionManager txnMgr) {
        this.txnMgr = txnMgr;
    }

    public boolean isCurrentlyInTransaction() throws SystemException {
        return this.txnMgr.getTransaction() != null;
    }

    public String currentTransactionId() {
        try {
            javax.transaction.Transaction txn = this.txnMgr.getTransaction();
            return txn != null ? txn.toString() : null;
        }
        catch (SystemException e) {
            return null;
        }
    }

    public TransactionManager getTransactionManager() {
        return this.txnMgr;
    }

    public abstract Transaction begin() throws NotSupportedException, SystemException;

    public abstract Transaction currentTransaction();

    public void updateCache(WorkspaceCache workspace, ChangeSet changes, Transaction transaction) {
        if (changes != null && !changes.isEmpty()) {
            workspace.changed(changes);
        }
    }

    public javax.transaction.Transaction suspend() throws SystemException {
        return this.txnMgr.suspend();
    }

    public void resume(javax.transaction.Transaction transaction) throws SystemException {
        if (transaction != null && this.txnMgr.getTransaction() == null) {
            try {
                this.txnMgr.resume(transaction);
            }
            catch (InvalidTransactionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected class NestableThreadLocalTransaction
    extends TraceableSimpleTransaction {
        private AtomicInteger nestedLevel;
        private ThreadLocal<NestableThreadLocalTransaction> txHolder;

        protected NestableThreadLocalTransaction(TransactionManager txnMgr, ThreadLocal<NestableThreadLocalTransaction> txHolder) {
            super(txnMgr);
            this.nestedLevel = new AtomicInteger(0);
            this.txHolder = txHolder;
            this.txHolder.set(this);
        }

        @Override
        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            try {
                super.rollback();
            }
            finally {
                this.cleanup();
            }
        }

        @Override
        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            if (this.nestedLevel.getAndDecrement() == 1) {
                try {
                    super.commit();
                }
                finally {
                    this.cleanup();
                }
            } else {
                Transactions.this.logger.trace("Not committing transaction because it's nested within another transaction. Only the top level transaction should commit", new Object[0]);
            }
        }

        protected void cleanup() {
            if (this.txHolder != null) {
                this.txHolder.remove();
                this.txHolder = null;
            }
            this.nestedLevel = null;
        }

        protected NestableThreadLocalTransaction begin() {
            this.nestedLevel.incrementAndGet();
            return this;
        }
    }

    protected abstract class TraceableSimpleTransaction
    extends SimpleTransaction {
        protected TraceableSimpleTransaction(TransactionManager txnMgr) {
            super(txnMgr);
        }

        @Override
        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            if (Transactions.this.logger.isTraceEnabled()) {
                Transactions.this.logger.trace("Rolling back transaction '{0}'", new Object[]{Transactions.this.currentTransactionId()});
            }
            super.rollback();
        }

        @Override
        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            if (Transactions.this.logger.isTraceEnabled()) {
                String id = Transactions.this.currentTransactionId();
                super.commit();
                Transactions.this.logger.trace("Committed transaction '{0}'", new Object[]{id});
            } else {
                super.commit();
            }
        }
    }

    protected abstract class SimpleTransaction
    extends BaseTransaction {
        protected SimpleTransaction(TransactionManager txnMgr) {
            super(txnMgr);
        }

        @Override
        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            try {
                if (this.canRollback()) {
                    this.txnMgr.rollback();
                }
            }
            finally {
                this.executeFunctionsUponCompletion();
            }
        }

        @Override
        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            try {
                this.txnMgr.commit();
                this.executeFunctionsUponCommit();
            }
            finally {
                this.executeFunctionsUponCompletion();
            }
        }

        protected boolean canRollback() {
            try {
                switch (super.status()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }
            catch (SystemException e) {
                return false;
            }
        }
    }

    protected abstract class BaseTransaction
    implements Transaction {
        protected final TransactionManager txnMgr;
        private Set<TransactionFunction> uponCompletionFunctions;
        private Set<TransactionFunction> uponCommitFunctions;

        protected BaseTransaction(TransactionManager txnMgr) {
            this.txnMgr = txnMgr;
        }

        @Override
        public void uponCompletion(TransactionFunction function) {
            if (this.uponCompletionFunctions == null) {
                this.uponCompletionFunctions = new LinkedHashSet<TransactionFunction>();
            }
            this.uponCompletionFunctions.add(function);
        }

        @Override
        public void uponCommit(TransactionFunction function) {
            if (this.uponCommitFunctions == null) {
                this.uponCommitFunctions = new LinkedHashSet<TransactionFunction>();
            }
            this.uponCommitFunctions.add(function);
        }

        @Override
        public int status() throws SystemException {
            return this.txnMgr.getStatus();
        }

        protected void executeFunctionsUponCompletion() {
            if (this.uponCompletionFunctions != null) {
                this.executeFunctions(this.uponCompletionFunctions);
                this.uponCompletionFunctions = null;
            }
        }

        protected void executeFunctionsUponCommit() {
            if (this.uponCommitFunctions != null) {
                this.executeFunctions(this.uponCommitFunctions);
                this.uponCommitFunctions = null;
            }
        }

        private void executeFunctions(Set<TransactionFunction> functions) {
            for (TransactionFunction function : functions) {
                function.execute();
            }
            functions.clear();
        }
    }

    public static interface TransactionFunction {
        public void execute();
    }

    public static interface Transaction {
        public int status() throws SystemException;

        public void uponCompletion(TransactionFunction var1);

        public void uponCommit(TransactionFunction var1);

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException;

        public void rollback() throws IllegalStateException, SecurityException, SystemException;
    }
}

