/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.query.Tuples;
import org.modeshape.jcr.query.model.NullOrder;
import org.modeshape.jcr.query.model.Order;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.InvalidPathException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;

public class RowExtractors {
    public static ExtractFromRow convert(final ExtractFromRow extractor, final TypeSystem.TypeFactory<?> newType) {
        return new ExtractFromRow(){

            @Override
            public TypeSystem.TypeFactory<?> getType() {
                return newType;
            }

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                Object value = extractor.getValueInRow(row);
                if (value == null) {
                    return value;
                }
                if (value instanceof Object[]) {
                    Object[] values = (Object[])value;
                    for (int i = 0; i != values.length; ++i) {
                        values[i] = newType.create(values[i]);
                    }
                    return values;
                }
                return newType.create(extractor.getValueInRow(row));
            }

            public String toString() {
                return "(as-string " + extractor.toString() + " )";
            }
        };
    }

    public static ExtractFromRow extractFullText(final int indexInRow, final NodeCache cache, TypeSystem types, final BinaryStore binaries) {
        final TypeSystem.TypeFactory<String> type = types.getStringFactory();
        final boolean trace = NodeSequence.LOGGER.isTraceEnabled();
        return new ExtractFromRow(){

            public TypeSystem.TypeFactory<String> getType() {
                return type;
            }

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                CachedNode node = row.getNode(indexInRow);
                if (node == null) {
                    return null;
                }
                StringBuilder fullTextString = new StringBuilder();
                Name name = node.getName(cache);
                fullTextString.append(name.getLocalName());
                Iterator<Property> iter = node.getProperties(cache);
                while (iter.hasNext()) {
                    RowExtractors.extractFullTextFrom(iter.next(), type, fullTextString, binaries, node, cache);
                }
                if (trace) {
                    NodeSequence.LOGGER.trace("Extracting full-text from {0}: {1}", new Object[]{node.getPath(cache), fullTextString});
                }
                return fullTextString.toString();
            }

            public String toString() {
                return "(extract-full-text)";
            }
        };
    }

    public static ExtractFromRow extractFullText(final int indexInRow, final NodeCache cache, final Name propertyName, TypeSystem types, final BinaryStore binaries) {
        final TypeSystem.TypeFactory<String> type = types.getStringFactory();
        return new ExtractFromRow(){

            public TypeSystem.TypeFactory<String> getType() {
                return type;
            }

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                CachedNode node = row.getNode(indexInRow);
                if (node == null) {
                    return null;
                }
                Property prop = node.getProperty(propertyName, cache);
                if (prop == null || prop.isEmpty()) {
                    return null;
                }
                StringBuilder fullTextString = new StringBuilder();
                RowExtractors.extractFullTextFrom(prop, type, fullTextString, binaries, node, cache);
                return fullTextString.toString();
            }

            public String toString() {
                return "(extract-full-text property=" + (String)type.create(propertyName) + ")";
            }
        };
    }

    protected static void extractFullTextFrom(Property property, TypeSystem.TypeFactory<String> type, StringBuilder fullTextString, BinaryStore binaries, CachedNode node, NodeCache cache) {
        for (Object value : property) {
            RowExtractors.extractFullTextFrom(value, type, binaries, fullTextString);
        }
    }

    public static void extractFullTextFrom(Object propertyValue, TypeSystem.TypeFactory<String> type, BinaryStore binaries, StringBuilder fullTextString) {
        if (propertyValue instanceof Object[]) {
            Arrays.stream((Object[])propertyValue).forEach(value -> RowExtractors.extractTextFromSingleProperty(value, type, binaries, fullTextString));
        } else {
            RowExtractors.extractTextFromSingleProperty(propertyValue, type, binaries, fullTextString);
        }
    }

    public static void extractTextFromSingleProperty(Object propertyValue, TypeSystem.TypeFactory<String> type, BinaryStore binaries, StringBuilder fullTextString) {
        if (propertyValue instanceof Binary && binaries != null) {
            try {
                propertyValue = binaries.getText((BinaryValue)propertyValue);
            }
            catch (BinaryStoreException e) {
                NodeSequence.LOGGER.debug("Error getting full text from binary {0}", new Object[]{propertyValue});
            }
        }
        if (propertyValue != null) {
            fullTextString.append(' ').append(type.create(propertyValue));
        }
    }

    public static ExtractFromRow extractNodeKey(final int indexInRow, final NodeCache cache, TypeSystem types) {
        final TypeSystem.TypeFactory<String> type = types.getStringFactory();
        final boolean trace = NodeSequence.LOGGER.isTraceEnabled();
        return new ExtractFromRow(){

            public TypeSystem.TypeFactory<String> getType() {
                return type;
            }

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                CachedNode node = row.getNode(indexInRow);
                if (node == null) {
                    return null;
                }
                if (trace) {
                    NodeSequence.LOGGER.trace("Extracting node key from {0}: {1}", new Object[]{node.getPath(cache), node.getKey()});
                }
                return node.getKey().toString();
            }

            public String toString() {
                return "(extract-node-key)";
            }
        };
    }

    public static ExtractFromRow extractParentNodeKey(final int indexInRow, final NodeCache cache, TypeSystem types) {
        final TypeSystem.TypeFactory<String> type = types.getStringFactory();
        final boolean trace = NodeSequence.LOGGER.isTraceEnabled();
        return new ExtractFromRow(){

            public TypeSystem.TypeFactory<String> getType() {
                return type;
            }

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                CachedNode node = row.getNode(indexInRow);
                if (node == null) {
                    return null;
                }
                NodeKey parentKey = node.getParentKey(cache);
                if (trace) {
                    NodeSequence.LOGGER.trace("Extracting parent key from {0}: {1}", new Object[]{node.getPath(cache), parentKey});
                }
                return parentKey != null ? parentKey.toString() : null;
            }

            public String toString() {
                return "(extract-parent-key)";
            }
        };
    }

    public static ExtractFromRow extractPath(final int indexInRow, final NodeCache cache, TypeSystem types) {
        final TypeSystem.TypeFactory<Path> type = types.getPathFactory();
        final boolean trace = NodeSequence.LOGGER.isTraceEnabled();
        return new ExtractFromRow(){

            public TypeSystem.TypeFactory<Path> getType() {
                return type;
            }

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                CachedNode node = row.getNode(indexInRow);
                if (node == null) {
                    return null;
                }
                Path path = node.getPath(cache);
                if (trace) {
                    NodeSequence.LOGGER.trace("Extracting path from {0}", new Object[]{path});
                }
                return path;
            }

            public String toString() {
                return "(extract-path)";
            }
        };
    }

    public static ExtractFromRow extractParentPath(final int indexInRow, final NodeCache cache, TypeSystem types) {
        final TypeSystem.TypeFactory<Path> type = types.getPathFactory();
        final boolean trace = NodeSequence.LOGGER.isTraceEnabled();
        return new ExtractFromRow(){

            public TypeSystem.TypeFactory<Path> getType() {
                return type;
            }

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                CachedNode node = row.getNode(indexInRow);
                if (node == null) {
                    return null;
                }
                NodeKey parentKey = node.getParentKey(cache);
                if (parentKey == null) {
                    return null;
                }
                CachedNode parent = cache.getNode(parentKey);
                if (parent == null) {
                    return null;
                }
                Path parentPath = parent.getPath(cache);
                if (trace) {
                    NodeSequence.LOGGER.trace("Extracting parent path from {0}: {1}", new Object[]{node.getPath(cache), parentPath});
                }
                return parentPath;
            }

            public String toString() {
                return "(extract-parent-path)";
            }
        };
    }

    public static ExtractFromRow extractRelativePath(final int indexInRow, final Path relativePath, final NodeCache cache, TypeSystem types) {
        CheckArg.isNotNull((Object)relativePath, (String)"relativePath");
        final TypeSystem.TypeFactory<Path> type = types.getPathFactory();
        final boolean trace = NodeSequence.LOGGER.isTraceEnabled();
        return new ExtractFromRow(){

            public TypeSystem.TypeFactory<Path> getType() {
                return type;
            }

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                CachedNode node = row.getNode(indexInRow);
                if (node == null) {
                    return null;
                }
                Path nodePath = node.getPath(cache);
                try {
                    Path path = nodePath.resolve(relativePath);
                    if (trace) {
                        NodeSequence.LOGGER.trace("Extracting relative path {2} from {0}: {2}", new Object[]{node.getPath(cache), relativePath, path});
                    }
                    return path;
                }
                catch (InvalidPathException e) {
                    return null;
                }
            }

            public String toString() {
                return "(extract-relative-path)";
            }
        };
    }

    public static ExtractFromRow extractName(final int indexInRow, final NodeCache cache, TypeSystem types) {
        final TypeSystem.TypeFactory<Name> type = types.getNameFactory();
        final boolean trace = NodeSequence.LOGGER.isTraceEnabled();
        return new ExtractFromRow(){

            public TypeSystem.TypeFactory<Name> getType() {
                return type;
            }

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                CachedNode node = row.getNode(indexInRow);
                if (node == null) {
                    return null;
                }
                Name name = node.getName(cache);
                if (trace) {
                    NodeSequence.LOGGER.trace("Extracting name from {0}: {1}", new Object[]{node.getPath(cache), name});
                }
                return name;
            }

            public String toString() {
                return "(extract-name)";
            }
        };
    }

    public static ExtractFromRow extractLocalName(final int indexInRow, final NodeCache cache, TypeSystem types) {
        final TypeSystem.TypeFactory<String> type = types.getStringFactory();
        final boolean trace = NodeSequence.LOGGER.isTraceEnabled();
        return new ExtractFromRow(){

            public TypeSystem.TypeFactory<String> getType() {
                return type;
            }

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                CachedNode node = row.getNode(indexInRow);
                String name = node.getName(cache).getLocalName();
                if (trace) {
                    NodeSequence.LOGGER.trace("Extracting name from {0}: {1}", new Object[]{node.getPath(cache), name});
                }
                return name;
            }

            public String toString() {
                return "(extract-local-name)";
            }
        };
    }

    public static ExtractFromRow extractUniqueKey(final int rowWidth, TypeSystem types) {
        final TypeSystem.TypeFactory<NodeKey> keyType = types.getNodeKeyFactory();
        assert (rowWidth > 0);
        if (rowWidth == 1) {
            return new ExtractFromRow(){

                public TypeSystem.TypeFactory<NodeKey> getType() {
                    return keyType;
                }

                @Override
                public Object getValueInRow(NodeSequence.RowAccessor row) {
                    return NodeSequence.keyFor(row.getNode());
                }

                public String toString() {
                    return "(extract-key-for-order-1-tuples)";
                }
            };
        }
        if (rowWidth == 2) {
            final TypeSystem.TypeFactory<Tuples.Tuple2<NodeKey, NodeKey>> tupleType = Tuples.typeFactory(keyType, keyType);
            return new ExtractFromRow(){

                @Override
                public TypeSystem.TypeFactory<?> getType() {
                    return tupleType;
                }

                @Override
                public Object getValueInRow(NodeSequence.RowAccessor row) {
                    return Tuples.tuple(NodeSequence.keyFor(row.getNode(0)), NodeSequence.keyFor(row.getNode(1)));
                }

                public String toString() {
                    return "(extract-key-for-order-2-tuples)";
                }
            };
        }
        if (rowWidth == 3) {
            final TypeSystem.TypeFactory<Tuples.Tuple3<NodeKey, NodeKey, NodeKey>> tupleType = Tuples.typeFactory(keyType, keyType, keyType);
            return new ExtractFromRow(){

                @Override
                public TypeSystem.TypeFactory<?> getType() {
                    return tupleType;
                }

                @Override
                public Object getValueInRow(NodeSequence.RowAccessor row) {
                    return Tuples.tuple(NodeSequence.keyFor(row.getNode(0)), NodeSequence.keyFor(row.getNode(1)), NodeSequence.keyFor(row.getNode(2)));
                }

                public String toString() {
                    return "(extract-key-for-order-3-tuples)";
                }
            };
        }
        if (rowWidth == 4) {
            final TypeSystem.TypeFactory<Tuples.Tuple4<NodeKey, NodeKey, NodeKey, NodeKey>> tupleType = Tuples.typeFactory(keyType, keyType, keyType, keyType);
            return new ExtractFromRow(){

                @Override
                public TypeSystem.TypeFactory<?> getType() {
                    return tupleType;
                }

                @Override
                public Object getValueInRow(NodeSequence.RowAccessor row) {
                    return Tuples.tuple(NodeSequence.keyFor(row.getNode(0)), NodeSequence.keyFor(row.getNode(1)), NodeSequence.keyFor(row.getNode(2)), NodeSequence.keyFor(row.getNode(3)));
                }

                public String toString() {
                    return "(extract-key-for-order-4-tuples)";
                }
            };
        }
        final TypeSystem.TypeFactory<?> tupleType = Tuples.typeFactory(keyType, rowWidth);
        return new ExtractFromRow(){

            @Override
            public TypeSystem.TypeFactory<?> getType() {
                return tupleType;
            }

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                Object[] keys = new Object[rowWidth];
                for (int i = 0; i != rowWidth; ++i) {
                    keys[i] = NodeSequence.keyFor(row.getNode(i));
                }
                return Tuples.tuple(keys);
            }

            public String toString() {
                return "(extract-key-for-order-N-tuples)";
            }
        };
    }

    public static ExtractFromRow extractPropertyValue(final Name propertyName, final int indexInRow, final NodeCache cache, final TypeSystem.TypeFactory<?> desiredType) {
        return new ExtractFromRow(){

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                CachedNode node = row.getNode(indexInRow);
                if (node == null) {
                    return null;
                }
                Property prop = node.getProperty(propertyName, cache);
                return prop == null ? null : desiredType.create(prop.getFirstValue());
            }

            @Override
            public TypeSystem.TypeFactory<?> getType() {
                return desiredType;
            }
        };
    }

    public static ExtractFromRow extractorWith(final ExtractFromRow first, final ExtractFromRow second) {
        final TypeSystem.TypeFactory<Tuples.Tuple2<?, ?>> type = Tuples.typeFactory(first.getType(), second.getType());
        return new ExtractFromRow(){

            @Override
            public TypeSystem.TypeFactory<?> getType() {
                return type;
            }

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                return Tuples.tuple(first.getValueInRow(row), second.getValueInRow(row));
            }
        };
    }

    public static ExtractFromRow extractorWith(final ExtractFromRow first, final ExtractFromRow second, final ExtractFromRow third) {
        final TypeSystem.TypeFactory<Tuples.Tuple3<?, ?, ?>> type = Tuples.typeFactory(first.getType(), second.getType(), third.getType());
        return new ExtractFromRow(){

            @Override
            public TypeSystem.TypeFactory<?> getType() {
                return type;
            }

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                return Tuples.tuple(first.getValueInRow(row), second.getValueInRow(row), third.getValueInRow(row));
            }
        };
    }

    public static ExtractFromRow extractorWith(final ExtractFromRow first, final ExtractFromRow second, final ExtractFromRow third, final ExtractFromRow fourth) {
        final TypeSystem.TypeFactory<Tuples.Tuple4<?, ?, ?, ?>> type = Tuples.typeFactory(first.getType(), second.getType(), third.getType(), fourth.getType());
        return new ExtractFromRow(){

            @Override
            public TypeSystem.TypeFactory<?> getType() {
                return type;
            }

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                return Tuples.tuple(first.getValueInRow(row), second.getValueInRow(row), third.getValueInRow(row), fourth.getValueInRow(row));
            }
        };
    }

    public static ExtractFromRow extractorWith(Collection<ExtractFromRow> extractors) {
        final int len = extractors.size();
        assert (len > 0);
        if (len == 1) {
            return extractors.iterator().next();
        }
        if (len == 2) {
            Iterator<ExtractFromRow> iter = extractors.iterator();
            ExtractFromRow first = iter.next();
            ExtractFromRow second = iter.next();
            return RowExtractors.extractorWith(first, second);
        }
        if (len == 3) {
            Iterator<ExtractFromRow> iter = extractors.iterator();
            ExtractFromRow first = iter.next();
            ExtractFromRow second = iter.next();
            ExtractFromRow third = iter.next();
            return RowExtractors.extractorWith(first, second, third);
        }
        if (len == 4) {
            Iterator<ExtractFromRow> iter = extractors.iterator();
            ExtractFromRow first = iter.next();
            ExtractFromRow second = iter.next();
            ExtractFromRow third = iter.next();
            ExtractFromRow fourth = iter.next();
            return RowExtractors.extractorWith(first, second, third, fourth);
        }
        ArrayList types = new ArrayList();
        final ExtractFromRow[] extracts = new ExtractFromRow[len];
        int i = 0;
        for (ExtractFromRow extractor : extractors) {
            extracts[i++] = extractor;
            types.add(extractor.getType());
        }
        final TypeSystem.TypeFactory<?> type = Tuples.typeFactory(types);
        return new ExtractFromRow(){

            @Override
            public TypeSystem.TypeFactory<?> getType() {
                return type;
            }

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                Object[] values = new Object[len];
                for (int i = 0; i != len; ++i) {
                    values[i] = extracts[i].getValueInRow(row);
                }
                return Tuples.tuple(values);
            }
        };
    }

    public static ExtractFromRow extractorWith(final ExtractFromRow extractor, final Order order, final NullOrder nullOrder) {
        final TypeSystem.TypeFactory<?> type = TypeSystem.with(extractor.getType(), order, nullOrder);
        return new ExtractFromRow(){

            @Override
            public TypeSystem.TypeFactory<?> getType() {
                return type;
            }

            @Override
            public Object getValueInRow(NodeSequence.RowAccessor row) {
                return extractor.getValueInRow(row);
            }

            public String toString() {
                return extractor.toString() + " " + order + " " + nullOrder;
            }
        };
    }

    private RowExtractors() {
    }

    public static interface ExtractFromRow {
        public TypeSystem.TypeFactory<?> getType();

        public Object getValueInRow(NodeSequence.RowAccessor var1);
    }
}

