/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.spi.index.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.JoinCondition;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.collection.DelegateIterable;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.function.Function;
import org.modeshape.common.function.Predicate;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.Environment;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.api.Logger;
import org.modeshape.jcr.api.index.IndexColumnDefinition;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.bus.ChangeBus;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetAdapter;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.engine.NoOpQueryIndexWriter;
import org.modeshape.jcr.spi.index.Index;
import org.modeshape.jcr.spi.index.IndexConstraints;
import org.modeshape.jcr.spi.index.IndexCostCalculator;
import org.modeshape.jcr.spi.index.IndexDefinitionChanges;
import org.modeshape.jcr.spi.index.IndexFeedback;
import org.modeshape.jcr.spi.index.IndexWriter;
import org.modeshape.jcr.spi.index.WorkspaceChanges;
import org.modeshape.jcr.spi.index.provider.Filter;
import org.modeshape.jcr.spi.index.provider.IndexChangeAdapter;
import org.modeshape.jcr.spi.index.provider.IndexPlanner;
import org.modeshape.jcr.spi.index.provider.IndexUsage;
import org.modeshape.jcr.spi.index.provider.ManagedIndex;
import org.modeshape.jcr.spi.index.provider.ManagedIndexBuilder;
import org.modeshape.jcr.spi.index.provider.NodeTypeMatcher;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.ValueFactories;

public abstract class IndexProvider {
    public static final int DEFAULT_BATCH_SIZE = 100;
    private static final IndexWriter EMPTY_WRITER = NoOpQueryIndexWriter.INSTANCE;
    private Logger logger;
    private String name;
    private ExecutionContext context;
    private Environment environment;
    private String repositoryName;
    private String systemWorkspaceName;
    private boolean initialized = false;
    private final IndexPlanner planner;
    private final Map<String, Map<String, AtomicIndex>> providedIndexesByWorkspaceNameByIndexName = new HashMap<String, Map<String, AtomicIndex>>();
    private final Map<String, Map<String, AtomicIndex>> providedIndexesByIndexNameByWorkspaceName = new HashMap<String, Map<String, AtomicIndex>>();
    private volatile IndexWriter delegateWriter = EMPTY_WRITER;
    private final IndexWriter publicWriter = new IndexWriter(){

        @Override
        public boolean canBeSkipped() {
            return IndexProvider.this.delegateWriter.canBeSkipped();
        }

        @Override
        public void clearAllIndexes() {
            IndexProvider.this.delegateWriter.clearAllIndexes();
        }

        @Override
        public boolean add(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties) {
            return IndexProvider.this.delegateWriter.add(workspace, key, path, primaryType, mixinTypes, properties);
        }

        @Override
        public boolean remove(String workspace, NodeKey key) {
            return IndexProvider.this.delegateWriter.remove(workspace, key);
        }

        @Override
        public void commit(String workspace) {
            IndexProvider.this.delegateWriter.commit(workspace);
        }
    };

    protected IndexProvider() {
        this.planner = new BasicPlanner();
    }

    protected IndexProvider(IndexPlanner planner) {
        assert (planner != null);
        this.planner = planner;
    }

    protected final Logger logger() {
        return this.logger;
    }

    public final String getName() {
        return this.name;
    }

    public final String getRepositoryName() {
        return this.repositoryName;
    }

    public int batchSize() {
        return 100;
    }

    public Set<String> getIndexNames() {
        return new HashSet<String>(this.providedIndexesByIndexNameByWorkspaceName.keySet());
    }

    protected final ExecutionContext context() {
        return this.context;
    }

    protected final Environment environment() {
        return this.environment;
    }

    public final synchronized void initialize() throws RepositoryException {
        if (!this.initialized) {
            try {
                this.doInitialize();
                this.initialized = true;
            }
            catch (RuntimeException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    private void postInitialize() {
        if (!this.initialized) {
            this.initialized = true;
        }
    }

    protected abstract void doInitialize() throws RepositoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void shutdown() throws RepositoryException {
        this.preShutdown();
        this.delegateWriter = NoOpQueryIndexWriter.INSTANCE;
        try {
            for (Map<String, AtomicIndex> byWorkspaceName : this.providedIndexesByWorkspaceNameByIndexName.values()) {
                for (AtomicIndex provided : byWorkspaceName.values()) {
                    provided.shutdown(false);
                }
            }
        }
        finally {
            this.providedIndexesByWorkspaceNameByIndexName.clear();
            this.providedIndexesByIndexNameByWorkspaceName.clear();
            this.postShutdown();
        }
    }

    protected void preShutdown() throws RepositoryException {
    }

    protected void postShutdown() throws RepositoryException {
    }

    public void notify(final NodeTypes updatedNodeTypes) {
        CheckArg.isNotNull((Object)updatedNodeTypes, (String)"updatedNodeTypes");
        this.onEachIndex(new ProvidedIndexOperation(){

            @Override
            public void apply(String workspaceName, AtomicIndex index) {
                NodeTypeMatcher matcher = IndexProvider.this.nodeTypePredicate(updatedNodeTypes, index.indexDefinition());
                index.update(index.managed(), index.indexDefinition(), matcher);
            }
        });
    }

    public void validateProposedIndex(ExecutionContext context, IndexDefinition defn, NodeTypes.Supplier nodeTypesSupplier, Problems problems) {
    }

    public void validateDefaultColumnTypes(ExecutionContext context, IndexDefinition defn, Problems problems) {
        assert (defn != null);
        for (int i = 0; i < defn.size(); ++i) {
            this.validateDefaultColumnDefinitionType(context, defn, defn.getColumnDefinition(i), problems);
        }
    }

    protected void validateDefaultColumnDefinitionType(ExecutionContext context, IndexDefinition defn, IndexColumnDefinition columnDefn, Problems problems) {
        int columnType = columnDefn.getColumnType();
        PropertyType type = PropertyType.valueFor(columnType);
        switch (defn.getKind()) {
            case UNIQUE_VALUE: 
            case ENUMERATED_VALUE: 
            case VALUE: {
                if (this.matches(context, columnDefn, JcrLexicon.PATH) && !this.isType(type, PropertyType.PATH)) {
                    problems.addError(JcrI18n.indexMustHaveOneColumnOfSpecificType, new Object[]{defn.getProviderName(), defn.getName(), columnDefn.getPropertyName(), type, PropertyType.PATH});
                }
                if (this.matches(context, columnDefn, ModeShapeLexicon.LOCALNAME) && !this.isType(type, PropertyType.STRING) || this.matches(context, columnDefn, ModeShapeLexicon.ID) && !this.isType(type, PropertyType.STRING)) {
                    problems.addError(JcrI18n.indexMustHaveOneColumnOfSpecificType, new Object[]{defn.getProviderName(), defn.getName(), columnDefn.getPropertyName(), type, PropertyType.STRING});
                }
                if (this.matches(context, columnDefn, ModeShapeLexicon.DEPTH) && !this.isType(type, PropertyType.LONG)) {
                    problems.addError(JcrI18n.indexMustHaveOneColumnOfSpecificType, new Object[]{defn.getProviderName(), defn.getName(), columnDefn.getPropertyName(), type, PropertyType.LONG});
                }
                if (!(this.matches(context, columnDefn, JcrLexicon.PRIMARY_TYPE) && !this.isType(type, PropertyType.NAME) || this.matches(context, columnDefn, JcrLexicon.MIXIN_TYPES) && !this.isType(type, PropertyType.NAME)) && (!this.matches(context, columnDefn, JcrLexicon.NAME) || this.isType(type, PropertyType.NAME))) break;
                problems.addError(JcrI18n.indexMustHaveOneColumnOfSpecificType, new Object[]{defn.getProviderName(), defn.getName(), columnDefn.getPropertyName(), type, PropertyType.NAME});
                break;
            }
            case NODE_TYPE: {
                if (PropertyType.STRING == type) break;
                problems.addError(JcrI18n.indexMustHaveOneColumnOfSpecificType, new Object[]{defn.getProviderName(), defn.getName(), columnDefn.getPropertyName(), type, PropertyType.STRING});
                break;
            }
            case TEXT: {
                if (PropertyType.STRING == type || PropertyType.BINARY == type || PropertyType.PATH == type || PropertyType.NAME == type) break;
                String expectedTypeMsg = (Object)((Object)PropertyType.STRING) + " or " + (Object)((Object)PropertyType.BINARY);
                problems.addError(JcrI18n.indexMustHaveOneColumnOfSpecificType, new Object[]{defn.getProviderName(), defn.getName(), columnDefn.getPropertyName(), type, expectedTypeMsg});
            }
        }
    }

    protected final boolean matches(ExecutionContext context, IndexColumnDefinition defn, Name name) {
        return defn.getPropertyName().equals(name.getString(context.getNamespaceRegistry()));
    }

    protected final boolean matches(ExecutionContext context, String actual, Name name) {
        return actual.equals(name.getString(context.getNamespaceRegistry()));
    }

    protected final boolean isType(PropertyType propType, PropertyType expected) {
        return propType == expected;
    }

    public final IndexWriter getIndexWriter() {
        return this.publicWriter;
    }

    public final Index getIndex(String indexName, String workspaceName) {
        this.logger().trace("Looking for index '{0}' in '{1}' provider for query in workspace '{2}'", new Object[]{indexName, this.getName(), workspaceName});
        Map<String, AtomicIndex> byWorkspaceNames = this.providedIndexesByWorkspaceNameByIndexName.get(indexName);
        return byWorkspaceNames == null ? null : (Index)byWorkspaceNames.get(workspaceName);
    }

    public final ManagedIndex getManagedIndex(String indexName, String workspaceName) {
        this.logger().trace("Looking for managed index '{0}' in '{1}' provider in workspace '{2}'", new Object[]{indexName, this.getName(), workspaceName});
        Map<String, AtomicIndex> byWorkspaceNames = this.providedIndexesByWorkspaceNameByIndexName.get(indexName);
        if (byWorkspaceNames == null) {
            return null;
        }
        AtomicIndex atomicIndex = byWorkspaceNames.get(workspaceName);
        return atomicIndex == null ? null : atomicIndex.managed();
    }

    public Long getLatestIndexUpdateTime() {
        return null;
    }

    protected final Iterable<ManagedIndex> getIndexes(String workspaceName) {
        Map<String, AtomicIndex> byIndexName = this.providedIndexesByIndexNameByWorkspaceName.get(workspaceName);
        if (byIndexName == null) {
            return Collections.emptySet();
        }
        return DelegateIterable.around(byIndexName.values(), (Function)new Function<AtomicIndex, ManagedIndex>(){

            public ManagedIndex apply(AtomicIndex input) {
                return input.managed();
            }
        });
    }

    protected final void onEachIndex(ManagedIndexOperation op) {
        for (String workspaceName : this.workspaceNames()) {
            this.onEachIndexInWorkspace(workspaceName, op);
        }
    }

    private final void onEachIndex(ProvidedIndexOperation op) {
        for (String workspaceName : this.workspaceNames()) {
            Collection<AtomicIndex> indexes = this.providedIndexesFor(workspaceName);
            if (indexes == null) continue;
            for (AtomicIndex atomicIndex : indexes) {
                assert (atomicIndex.managed() != null);
                assert (atomicIndex.indexDefinition() != null);
                op.apply(workspaceName, atomicIndex);
            }
        }
    }

    private synchronized Set<String> workspaceNames() {
        return new HashSet<String>(this.providedIndexesByIndexNameByWorkspaceName.keySet());
    }

    private synchronized Collection<AtomicIndex> providedIndexesFor(String workspaceName) {
        Map<String, AtomicIndex> byIndexName = this.providedIndexesByIndexNameByWorkspaceName.get(workspaceName);
        if (byIndexName != null) {
            return new ArrayList<AtomicIndex>(byIndexName.values());
        }
        return null;
    }

    public final void onEachIndexInWorkspace(String workspaceName, ManagedIndexOperation op) {
        assert (workspaceName != null);
        Collection<AtomicIndex> indexes = this.providedIndexesFor(workspaceName);
        if (indexes != null) {
            for (AtomicIndex atomicIndex : indexes) {
                assert (atomicIndex.managed() != null);
                assert (atomicIndex.indexDefinition() != null);
                op.apply(workspaceName, atomicIndex.managed(), atomicIndex.indexDefinition());
            }
        }
    }

    private boolean matchesType(IndexDefinition defn, IndexCostCalculator calculator, QueryContext context) {
        NodeTypes nodeTypes = context.getNodeTypes();
        NameFactory nameFactory = context.getExecutionContext().getValueFactories().getNameFactory();
        String indexedNodeType = defn.getNodeTypeName();
        Name indexedNodeTypeName = (Name)nameFactory.create(indexedNodeType);
        Set<String> selectedNodeTypes = calculator.selectedNodeTypes();
        assert (!selectedNodeTypes.isEmpty());
        for (String nodeTypeOrAlias : selectedNodeTypes) {
            Name selectedNodeTypeName = (Name)nameFactory.create(nodeTypeOrAlias);
            if (!nodeTypes.isTypeOrSubtype(selectedNodeTypeName, indexedNodeTypeName)) continue;
            return true;
        }
        return false;
    }

    protected void planUseOfIndex(QueryContext context, IndexCostCalculator calculator, String workspaceName, ManagedIndex index, IndexDefinition defn) {
        Collection<JoinCondition> joinConditions;
        IndexUsage planner = this.evaluateUsage(context, calculator, defn);
        if (planner == null) {
            throw new UnsupportedOperationException("Providers should either override this method or the #evaluateUsage method");
        }
        int costEstimate = this.getCostEstimate();
        ArrayList<Constraint> applicableConstraints = new ArrayList<Constraint>();
        for (Constraint constraint : calculator.andedConstraints()) {
            if (!planner.indexAppliesTo(constraint)) continue;
            this.logger().trace("Index '{0}' in '{1}' provider applies to query in workspace '{2}' with constraint: {3}", new Object[]{defn.getName(), this.getName(), workspaceName, constraint});
            applicableConstraints.add(constraint);
        }
        if (!applicableConstraints.isEmpty()) {
            long cardinality = index.estimateCardinality(applicableConstraints, context.getVariables());
            long total = index.estimateTotalCount();
            Float selectivity = null;
            if (total > 0L) {
                double ratio = (double)cardinality / (double)total;
                selectivity = cardinality <= total ? new Float(ratio) : IndexCostCalculator.MAX_SELECTIVITY;
            }
            calculator.addIndex(defn.getName(), workspaceName, this.getName(), applicableConstraints, costEstimate, cardinality, selectivity);
        }
        if ((joinConditions = calculator.joinConditions()).isEmpty()) {
            return;
        }
        ArrayList<JoinCondition> applicableJoins = new ArrayList<JoinCondition>();
        for (JoinCondition joinCondition : joinConditions) {
            if (!planner.indexAppliesTo(joinCondition)) continue;
            this.logger().trace("Index '{0}' in '{1}' provider applies to query in workspace '{2}' with constraint: {3}", new Object[]{defn.getName(), this.getName(), workspaceName, joinCondition});
            applicableJoins.add(joinCondition);
        }
        if (!applicableJoins.isEmpty()) {
            long total = index.estimateTotalCount();
            calculator.addIndex(defn.getName(), workspaceName, this.getName(), applicableJoins, costEstimate, total);
        }
    }

    protected IndexUsage evaluateUsage(QueryContext context, IndexCostCalculator calculator, IndexDefinition defn) {
        return null;
    }

    protected int getCostEstimate() {
        return 100;
    }

    public final IndexPlanner getIndexPlanner() {
        return this.planner;
    }

    protected final NamespaceRegistry namespaces() {
        return this.context.getNamespaceRegistry();
    }

    protected final ValueFactories valueFactories() {
        return this.context.getValueFactories();
    }

    protected final NameFactory names() {
        return this.valueFactories().getNameFactory();
    }

    public final synchronized void notify(WorkspaceChanges changes, ChangeBus observable, NodeTypes.Supplier nodeTypesSupplier, Set<String> workspaceNames, IndexFeedback feedback) {
        for (IndexDefinition defn : changes.getIndexDefinitions()) {
            for (String workspaceName : changes.getAddedWorkspaces()) {
                if (!defn.getWorkspaceMatchRule().usedInWorkspace(workspaceName)) continue;
                try {
                    NodeTypeMatcher matcher = this.nodeTypePredicate(nodeTypesSupplier.getNodeTypes(), defn);
                    ManagedIndex managedIndex = this.createIndex(defn, workspaceName, nodeTypesSupplier, matcher, feedback);
                    AtomicIndex index = new AtomicIndex(defn, managedIndex, workspaceName, matcher);
                    this.addProvidedIndex(index);
                    this.registerIndex(index, observable);
                }
                catch (RuntimeException e) {
                    String msg = "Error updating index '{0}' in workspace '{1}' with definition: {2}";
                    this.logger().error((Throwable)e, msg, new Object[]{defn.getName(), workspaceName, defn});
                }
            }
        }
        final Set<String> removedWorkspaces = changes.getRemovedWorkspaces();
        if (!removedWorkspaces.isEmpty()) {
            this.removeProvidedIndexes(observable, new Predicate<AtomicIndex>(){

                public boolean test(AtomicIndex index) {
                    return removedWorkspaces.contains(index.workspaceName());
                }
            });
        }
        this.refreshDelegateIndexWriter(nodeTypesSupplier);
    }

    public final synchronized void notify(IndexDefinitionChanges changes, ChangeBus observable, NodeTypes.Supplier nodeTypesSupplier, final Set<String> workspaceNames, IndexFeedback feedback) {
        for (IndexDefinition defn : changes.getUpdatedIndexDefinitions().values()) {
            Map<String, AtomicIndex> providedIndexesByWorkspaceName = this.providedIndexesByWorkspaceNameByIndexName.get(defn.getName());
            if (providedIndexesByWorkspaceName == null || providedIndexesByWorkspaceName.isEmpty()) {
                for (String workspaceName : workspaceNames) {
                    if (!defn.getWorkspaceMatchRule().usedInWorkspace(workspaceName)) continue;
                    try {
                        NodeTypeMatcher matcher = this.nodeTypePredicate(nodeTypesSupplier.getNodeTypes(), defn);
                        ManagedIndex managedIndex = this.createIndex(defn, workspaceName, nodeTypesSupplier, matcher, feedback);
                        AtomicIndex index = new AtomicIndex(defn, managedIndex, workspaceName, matcher);
                        this.addProvidedIndex(index);
                        this.registerIndex(index, observable);
                    }
                    catch (RuntimeException e) {
                        String msg = "Error updating index '{0}' in workspace '{1}' with definition: {2}";
                        this.logger().error((Throwable)e, msg, new Object[]{defn.getName(), workspaceName, defn});
                    }
                }
                continue;
            }
            assert (providedIndexesByWorkspaceName != null && !providedIndexesByWorkspaceName.isEmpty());
            for (String workspaceName : workspaceNames) {
                AtomicIndex provided = providedIndexesByWorkspaceName.get(workspaceName);
                if (provided != null) {
                    if (defn.getWorkspaceMatchRule().usedInWorkspace(workspaceName)) {
                        IndexDefinition oldDefn = provided.indexDefinition();
                        if (!this.isChanged(oldDefn, defn)) {
                            this.logger().debug("Index provider '{0}' is not updating index in workspace '{1}' because there were no changes: {2}", new Object[]{this.getName(), workspaceName, defn});
                            continue;
                        }
                        try {
                            NodeTypeMatcher matcher = this.nodeTypePredicate(nodeTypesSupplier.getNodeTypes(), defn);
                            ManagedIndex managedIndex = this.updateIndex(oldDefn, defn, provided.managed(), workspaceName, nodeTypesSupplier, matcher, feedback);
                            provided.update(managedIndex, defn, matcher);
                        }
                        catch (RuntimeException e) {
                            String msg = "Error updating index '{0}' in workspace '{1}' with definition: {2}";
                            this.logger().error((Throwable)e, msg, new Object[]{defn.getName(), workspaceName, defn});
                        }
                        continue;
                    }
                    this.removeProvidedIndex(provided, observable);
                    continue;
                }
                try {
                    NodeTypeMatcher matcher = this.nodeTypePredicate(nodeTypesSupplier.getNodeTypes(), defn);
                    ManagedIndex managedIndex = this.createIndex(defn, workspaceName, nodeTypesSupplier, matcher, feedback);
                    AtomicIndex index = new AtomicIndex(defn, managedIndex, workspaceName, matcher);
                    this.addProvidedIndex(index);
                    this.registerIndex(index, observable);
                }
                catch (RuntimeException e) {
                    String msg = "Error adding index '{0}' in workspace '{1}' with definition: {2}";
                    this.logger().error((Throwable)e, msg, new Object[]{defn.getName(), workspaceName, defn});
                }
            }
            this.removeProvidedIndexes(observable, new Predicate<AtomicIndex>(){

                public boolean test(AtomicIndex index) {
                    return !workspaceNames.contains(index.workspaceName());
                }
            });
        }
        final Set<String> removedIndexDefinitions = changes.getRemovedIndexDefinitions();
        if (!removedIndexDefinitions.isEmpty()) {
            this.removeProvidedIndexes(observable, new Predicate<AtomicIndex>(){

                public boolean test(AtomicIndex index) {
                    return removedIndexDefinitions.contains(index.getName());
                }
            });
        }
        this.refreshDelegateIndexWriter(nodeTypesSupplier);
    }

    private boolean isChanged(IndexDefinition defn1, IndexDefinition defn2) {
        if (defn1.getKind() != defn2.getKind()) {
            return true;
        }
        if (defn1.size() != defn2.size()) {
            return true;
        }
        for (int i = 0; i != defn1.size(); ++i) {
            IndexColumnDefinition col2;
            IndexColumnDefinition col1 = defn1.getColumnDefinition(i);
            if (!this.isChanged(col1, col2 = defn2.getColumnDefinition(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isChanged(IndexColumnDefinition defn1, IndexColumnDefinition defn2) {
        if (defn1.getColumnType() != defn2.getColumnType()) {
            return true;
        }
        return !defn1.getPropertyName().equals(defn2.getPropertyName());
    }

    private void addProvidedIndex(AtomicIndex index) {
        String indexName = index.getName();
        String workspaceName = index.workspaceName();
        Map<String, AtomicIndex> managedIndexesByWorkspaceName = this.providedIndexesByWorkspaceNameByIndexName.get(indexName);
        if (managedIndexesByWorkspaceName == null) {
            managedIndexesByWorkspaceName = new HashMap<String, AtomicIndex>();
            this.providedIndexesByWorkspaceNameByIndexName.put(indexName, managedIndexesByWorkspaceName);
        }
        managedIndexesByWorkspaceName.put(workspaceName, index);
        Map<String, AtomicIndex> byName = this.providedIndexesByIndexNameByWorkspaceName.get(workspaceName);
        if (byName == null) {
            byName = new HashMap<String, AtomicIndex>();
            this.providedIndexesByIndexNameByWorkspaceName.put(workspaceName, byName);
        }
        byName.put(indexName, index);
    }

    private void scanWorkspace(IndexFeedback feedback, final IndexDefinition defn, final String workspaceName, final ManagedIndex managedIndex, final NodeTypes.Supplier nodeTypesSupplier) {
        feedback.scan(workspaceName, new IndexFeedback.IndexingCallback(){

            @Override
            public void beforeIndexing() {
                IndexProvider.this.logger().debug("Disabling index '{0}' from provider '{1}' in workspace '{2}' while it is reindexed. It will not be used in queries until reindexing has completed", new Object[]{defn.getName(), defn.getProviderName(), workspaceName});
                managedIndex.enable(false);
            }

            @Override
            public void afterIndexing() {
                managedIndex.enable(true);
                IndexProvider.this.logger().debug("Enabled index '{0}' from provider '{1}' in workspace '{2}' after reindexing has completed", new Object[]{defn.getName(), defn.getProviderName(), workspaceName});
            }

            @Override
            public IndexWriter writer() {
                return new IndexWriter(){

                    @Override
                    public boolean canBeSkipped() {
                        return false;
                    }

                    @Override
                    public void clearAllIndexes() {
                        managedIndex.clearAllData();
                    }

                    @Override
                    public boolean add(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties) {
                        boolean queryable = nodeTypesSupplier.getNodeTypes().isQueryable(primaryType, mixinTypes);
                        return managedIndex.getIndexChangeAdapter().reindex(workspace, key, path, primaryType, mixinTypes, properties, queryable);
                    }

                    @Override
                    public boolean remove(String workspace, NodeKey key) {
                        managedIndex.getIndexChangeAdapter().clearDataFor(key);
                        return true;
                    }

                    @Override
                    public void commit(String workspace) {
                        managedIndex.getIndexChangeAdapter().index().commit();
                    }
                };
            }
        });
    }

    private void refreshDelegateIndexWriter(final NodeTypes.Supplier nodeTypesSupplier) {
        final HashMap<String, ArrayList<IndexChangeAdapter>> adaptersByWorkspaceName = new HashMap<String, ArrayList<IndexChangeAdapter>>();
        final ArrayList<ManagedIndex> managedIndexes = new ArrayList<ManagedIndex>();
        for (Map<String, AtomicIndex> providedIndexesByWorkspaceName : this.providedIndexesByWorkspaceNameByIndexName.values()) {
            for (Map.Entry<String, AtomicIndex> entry : providedIndexesByWorkspaceName.entrySet()) {
                String workspaceName = entry.getKey();
                AtomicIndex index = entry.getValue();
                ArrayList<IndexChangeAdapter> adaptersForWorkspace = (ArrayList<IndexChangeAdapter>)adaptersByWorkspaceName.get(workspaceName);
                if (adaptersForWorkspace == null) {
                    adaptersForWorkspace = new ArrayList<IndexChangeAdapter>();
                    adaptersByWorkspaceName.put(workspaceName, adaptersForWorkspace);
                }
                adaptersForWorkspace.add(index.managed().getIndexChangeAdapter());
                managedIndexes.add(index.managed());
            }
        }
        final boolean canBeSkipped = managedIndexes.isEmpty();
        this.delegateWriter = new IndexWriter(){

            @Override
            public boolean canBeSkipped() {
                return canBeSkipped;
            }

            @Override
            public void clearAllIndexes() {
                for (ManagedIndex index : managedIndexes) {
                    index.clearAllData();
                }
            }

            @Override
            public boolean add(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties) {
                Collection<IndexChangeAdapter> adapters = this.applicableAdapters(workspace);
                boolean indexesUpdated = false;
                if (adapters != null) {
                    boolean queryable = nodeTypesSupplier.getNodeTypes().isQueryable(primaryType, mixinTypes);
                    for (IndexChangeAdapter adapter : adapters) {
                        if (adapter == null) continue;
                        indexesUpdated |= adapter.reindex(workspace, key, path, primaryType, mixinTypes, properties, queryable);
                    }
                }
                return indexesUpdated;
            }

            @Override
            public boolean remove(String workspace, NodeKey key) {
                Collection<IndexChangeAdapter> adapters = this.applicableAdapters(workspace);
                boolean indexesUpdated = false;
                if (adapters != null) {
                    for (IndexChangeAdapter adapter : adapters) {
                        if (adapter == null) continue;
                        adapter.clearDataFor(key);
                        indexesUpdated = true;
                    }
                }
                return indexesUpdated;
            }

            @Override
            public void commit(String workspace) {
                Collection<IndexChangeAdapter> adapters = this.applicableAdapters(workspace);
                if (adapters != null) {
                    for (IndexChangeAdapter adapter : adapters) {
                        adapter.index().commit();
                    }
                }
            }

            private Collection<IndexChangeAdapter> applicableAdapters(String workspace) {
                ArrayList<IndexChangeAdapter> adapters = null;
                if (IndexProvider.this.systemWorkspaceName.equals(workspace)) {
                    adapters = new ArrayList();
                    for (Collection adapterCollection : adaptersByWorkspaceName.values()) {
                        adapters.addAll(adapterCollection);
                    }
                } else {
                    adapters = (Collection)adaptersByWorkspaceName.get(workspace);
                }
                return adapters;
            }
        };
    }

    protected ManagedIndex createIndex(IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher, IndexFeedback feedback) {
        ManagedIndexBuilder builder = this.getIndexBuilder(defn, workspaceName, nodeTypesSupplier, matcher);
        if (builder == null) {
            throw new UnsupportedOperationException("Index providers should either override this method or the #getIndexBuilder method");
        }
        this.logger().debug("Index provider '{0}' is creating index in workspace '{1}': {2}", new Object[]{this.getName(), workspaceName, defn});
        ManagedIndex index = builder.build();
        if (index.requiresReindexing()) {
            this.scanWorkspace(feedback, defn, workspaceName, index, nodeTypesSupplier);
        }
        return index;
    }

    protected ManagedIndex updateIndex(IndexDefinition oldDefn, IndexDefinition updatedDefn, ManagedIndex existingIndex, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher, IndexFeedback feedback) {
        ManagedIndexBuilder builder = this.getIndexBuilder(updatedDefn, workspaceName, nodeTypesSupplier, matcher);
        if (builder == null) {
            throw new UnsupportedOperationException("Index providers should either override this method or the #getIndexBuilder method");
        }
        this.logger().debug("Index provider '{0}' is updating index in workspace '{1}': {2}", new Object[]{this.getName(), workspaceName, updatedDefn});
        existingIndex.shutdown(true);
        ManagedIndex index = builder.build();
        if (index.requiresReindexing()) {
            this.scanWorkspace(feedback, updatedDefn, workspaceName, index, nodeTypesSupplier);
        }
        return index;
    }

    protected void removeIndex(IndexDefinition oldDefn, ManagedIndex existingIndex, String workspaceName) {
        this.logger().debug("Index provider '{0}' is removing index in workspace '{1}': {2}", new Object[]{this.getName(), workspaceName, oldDefn});
        existingIndex.shutdown(true);
    }

    protected ManagedIndexBuilder getIndexBuilder(IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
        return null;
    }

    private void removeProvidedIndexes(ChangeBus observable, Predicate<AtomicIndex> predicate) {
        Iterator<Map.Entry<String, Map<String, AtomicIndex>>> iter = this.providedIndexesByWorkspaceNameByIndexName.entrySet().iterator();
        while (iter.hasNext()) {
            Map<String, AtomicIndex> byWorkspaceName = iter.next().getValue();
            if (byWorkspaceName.isEmpty()) continue;
            Iterator<Map.Entry<String, AtomicIndex>> providedIter = byWorkspaceName.entrySet().iterator();
            while (providedIter.hasNext()) {
                AtomicIndex index = providedIter.next().getValue();
                if (!predicate.test((Object)index)) continue;
                this.removeProvidedIndex(index, observable);
                providedIter.remove();
                Map<String, AtomicIndex> byIndexName = this.providedIndexesByIndexNameByWorkspaceName.get(index.workspaceName());
                byIndexName.remove(index.getName());
            }
        }
    }

    private void registerIndex(AtomicIndex index, ChangeBus observable) {
        if (index.indexDefinition().isSynchronous()) {
            observable.registerInThread(index);
        } else {
            observable.register(index);
        }
    }

    private void removeProvidedIndex(AtomicIndex index, ChangeBus observable) {
        try {
            observable.unregister(index);
            this.removeIndex(index.indexDefinition(), index.managed(), index.workspaceName());
        }
        catch (RuntimeException e) {
            String msg = "Error removing index '{0}' in workspace '{1}' with definition: {2}";
            this.logger().error((Throwable)e, msg, new Object[]{index.getName(), index.workspaceName(), index.indexDefinition()});
        }
    }

    private NodeTypeMatcher nodeTypePredicate(NodeTypes nodeTypes, IndexDefinition defn) {
        String indexedNodeType = defn.getNodeTypeName();
        Name indexedNodeTypeName = (Name)this.context().getValueFactories().getNameFactory().create(indexedNodeType);
        Set<Name> allNodeTypes = nodeTypes.getAllSubtypes(indexedNodeTypeName);
        assert (allNodeTypes != null);
        return NodeTypeMatcher.create(allNodeTypes, nodeTypes);
    }

    @ThreadSafe
    private final class AtomicIndex
    implements Index,
    ChangeSetListener {
        private final String workspaceName;
        private volatile ManagedIndex managedIndex;
        private volatile IndexDefinition defn;
        private final NodeTypeMatcher matcher;

        protected AtomicIndex(IndexDefinition defn, ManagedIndex managedIndex, String workspaceName, NodeTypeMatcher matcher) {
            this.defn = defn;
            this.managedIndex = managedIndex;
            this.workspaceName = workspaceName;
            this.matcher = matcher;
        }

        protected final IndexDefinition indexDefinition() {
            return this.defn;
        }

        protected final String workspaceName() {
            return this.workspaceName;
        }

        @Override
        public final String getProviderName() {
            return IndexProvider.this.getName();
        }

        @Override
        public final String getName() {
            return this.defn.getName();
        }

        @Override
        public boolean supportsFullTextConstraints() {
            return this.defn.getKind() == IndexDefinition.IndexKind.TEXT;
        }

        @Override
        public boolean isEnabled() {
            return this.managedIndex.isEnabled();
        }

        @Override
        public final Filter.Results filter(IndexConstraints constraints) {
            return this.managedIndex.filter(constraints);
        }

        @Override
        public final void notify(ChangeSet changeSet) {
            if (changeSet.getWorkspaceName() != null) {
                this.managedIndex.getIndexChangeAdapter().notify(changeSet);
            }
        }

        protected ManagedIndex managed() {
            return this.managedIndex;
        }

        public void shutdown(boolean destroyed) {
            this.managedIndex.shutdown(destroyed);
        }

        protected final void update(ManagedIndex managedIndex, IndexDefinition newDefinition, NodeTypeMatcher matcher) {
            this.managedIndex = managedIndex;
            this.defn = newDefinition;
            this.matcher.use(matcher);
        }
    }

    private final class BasicPlanner
    extends IndexPlanner {
        protected BasicPlanner() {
        }

        @Override
        public void applyIndexes(final QueryContext context, final IndexCostCalculator calculator) {
            ManagedIndexOperation planningOp = new ManagedIndexOperation(){

                @Override
                public void apply(String workspaceName, ManagedIndex index, IndexDefinition defn) {
                    boolean traceEnabled = IndexProvider.this.logger().isTraceEnabled();
                    if (!defn.isEnabled()) {
                        if (traceEnabled) {
                            IndexProvider.this.logger().trace("Skipping index '{0}' in '{1}' provider because it is not enabled", new Object[]{defn.getName(), IndexProvider.this.getName()});
                        }
                        return;
                    }
                    if (!defn.getWorkspaceMatchRule().usedInWorkspace(workspaceName)) {
                        if (traceEnabled) {
                            IndexProvider.this.logger().trace("Skipping index '{0}' in '{1}' provider for query because it doest not match the '{2}' workspace", new Object[]{defn.getName(), IndexProvider.this.getName(), workspaceName});
                        }
                        return;
                    }
                    if (IndexProvider.this.matchesType(defn, calculator, context)) {
                        if (traceEnabled) {
                            IndexProvider.this.logger().trace("Considering index '{0}' in '{1}' provider for query in workspace '{2}'", new Object[]{defn.getName(), IndexProvider.this.getName(), workspaceName});
                        }
                        IndexProvider.this.planUseOfIndex(context, calculator, workspaceName, index, defn);
                    } else if (traceEnabled) {
                        IndexProvider.this.logger().trace("Skipping index '{0}' in '{1}' provider for query because the index definition node type '{2}' does not match the selected node types '{3}'", new Object[]{defn.getName(), IndexProvider.this.getName(), defn.getNodeTypeName(), calculator.selectedNodeTypes()});
                    }
                }
            };
            for (String workspaceName : context.getWorkspaceNames()) {
                IndexProvider.this.onEachIndexInWorkspace(workspaceName, planningOp);
            }
        }
    }

    private static interface ProvidedIndexOperation {
        public void apply(String var1, AtomicIndex var2);
    }

    public static interface ManagedIndexOperation {
        public void apply(String var1, ManagedIndex var2, IndexDefinition var3);
    }
}

