/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Transaction;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.document.TransactionalWorkspaceCaches;
import org.modeshape.jcr.cache.document.WorkspaceCache;

public class TransactionalWorkspaceCache
extends WorkspaceCache {
    private final WorkspaceCache sharedWorkspaceCache;
    private final TransactionalWorkspaceCaches txWorkspaceCaches;
    private final Transaction txn;

    protected TransactionalWorkspaceCache(WorkspaceCache sharedWorkspaceCache, TransactionalWorkspaceCaches txWorkspaceCaches, Transaction txn) {
        super(sharedWorkspaceCache, new ConcurrentHashMap<NodeKey, CachedNode>());
        this.sharedWorkspaceCache = sharedWorkspaceCache;
        this.txn = txn;
        this.txWorkspaceCaches = txWorkspaceCaches;
    }

    @Override
    public void changed(ChangeSet changes) {
        this.sharedWorkspaceCache.changed(changes);
        this.changedWithinTransaction(changes);
    }

    public void changedWithinTransaction(ChangeSet changes) {
        this.txWorkspaceCaches.dispatchChangesForTransaction(this.txn, changes);
    }

    @Override
    public void clear() {
        this.txWorkspaceCaches.clearAllCachesForTransaction(this.txn);
    }

    protected void internalClear() {
        super.clear();
    }

    protected void internalChangedWithinTransaction(ChangeSet changes) {
        super.changed(changes);
    }

    @Override
    protected void evictChangedNodes(ChangeSet changeSet) {
        this.sharedWorkspaceCache.evictChangedNodes(changeSet);
        super.evictChangedNodes(changeSet);
    }
}

