/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.query.engine.NoOpQueryIndexWriter;
import org.modeshape.jcr.spi.index.IndexWriter;
import org.modeshape.jcr.spi.index.provider.IndexProvider;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;

public class CompositeIndexWriter
implements IndexWriter {
    private final List<IndexWriter> writers;

    public static IndexWriter create(Iterable<IndexProvider> providers) {
        ArrayList<IndexWriter> writers = new ArrayList<IndexWriter>();
        for (IndexProvider provider : providers) {
            IndexWriter writer;
            if (provider == null || (writer = provider.getIndexWriter()) == null || writer.canBeSkipped()) continue;
            writers.add(writer);
        }
        if (writers.isEmpty()) {
            return NoOpQueryIndexWriter.INSTANCE;
        }
        if (writers.size() == 1) {
            return (IndexWriter)writers.get(0);
        }
        return new CompositeIndexWriter(writers);
    }

    protected CompositeIndexWriter(List<IndexWriter> writers) {
        this.writers = writers;
    }

    @Override
    public void clearAllIndexes() {
        for (IndexWriter writer : this.writers) {
            writer.clearAllIndexes();
        }
    }

    @Override
    public boolean canBeSkipped() {
        if (this.writers.isEmpty()) {
            return true;
        }
        for (IndexWriter writer : this.writers) {
            if (writer.canBeSkipped()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties) {
        boolean indexesUpdated = false;
        for (IndexWriter writer : this.writers) {
            indexesUpdated |= writer.add(workspace, key, path, primaryType, mixinTypes, properties);
        }
        return indexesUpdated;
    }

    @Override
    public boolean remove(String workspace, NodeKey key) {
        boolean indexesUpdated = false;
        for (IndexWriter writer : this.writers) {
            indexesUpdated |= writer.remove(workspace, key);
        }
        return indexesUpdated;
    }

    @Override
    public void commit(String workspace) {
        for (IndexWriter writer : this.writers) {
            writer.commit(workspace);
        }
    }
}

