/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine.process;

import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.CachedNodeSupplier;
import org.modeshape.jcr.query.BufferManager;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.query.RowExtractors;
import org.modeshape.jcr.query.engine.process.BufferingSequence;
import org.modeshape.jcr.query.model.JoinType;

@NotThreadSafe
public abstract class JoinSequence
extends BufferingSequence {
    protected final NodeSequence left;
    protected final RowExtractors.ExtractFromRow leftExtractor;
    protected final int leftWidth;
    protected final int totalWidth;
    protected final JoinType joinType;
    protected int batchSize = 100;
    protected NodeSequence.Batch currentLeft;
    private BatchFactory batchFactory;

    protected JoinSequence(String workspaceName, NodeSequence left, NodeSequence right, RowExtractors.ExtractFromRow leftExtractor, RowExtractors.ExtractFromRow rightExtractor, JoinType joinType, BufferManager bufferMgr, CachedNodeSupplier nodeCache, boolean pack, boolean useHeap, boolean allowDuplicates) {
        super(workspaceName, right, rightExtractor, bufferMgr, nodeCache, pack, useHeap, allowDuplicates);
        this.left = left;
        this.leftExtractor = leftExtractor;
        this.leftWidth = left.width();
        this.joinType = joinType;
        this.totalWidth = left.width() + right.width();
    }

    @Override
    public int width() {
        return this.totalWidth;
    }

    @Override
    public boolean isEmpty() {
        if (this.left.isEmpty()) {
            if (this.useNonMatchingRightRows() || this.useAllRightRowsWhenNoLeftRows()) {
                return this.delegate.isEmpty();
            }
            return true;
        }
        if (this.delegate.isEmpty() && this.useAllLeftRowsWhenNoMatchingRightRows()) {
            assert (!this.left.isEmpty());
            return false;
        }
        return false;
    }

    @Override
    public NodeSequence.Batch nextBatch() {
        this.findNextNonEmptyLeftBatch();
        if (this.batchFactory == null) {
            this.batchFactory = this.currentLeft == null ? (this.useAllRightRowsWhenNoLeftRows() ? new RightOnlyBatchFactory() : new EmptyBatchFactory()) : this.initialize();
        }
        return this.batchFactory.nextBatch();
    }

    protected NodeSequence.Batch findNextNonEmptyLeftBatch() {
        while (this.currentLeft == null) {
            this.currentLeft = this.left.nextBatch();
            if (this.currentLeft == null) {
                return null;
            }
            if (!this.currentLeft.isEmpty() && this.currentLeft.hasNext()) continue;
            this.currentLeft = null;
        }
        return this.currentLeft;
    }

    protected abstract BatchFactory initialize();

    protected boolean useAllRightRowsWhenNoLeftRows() {
        return this.joinType == JoinType.RIGHT_OUTER;
    }

    protected boolean useAllLeftRowsWhenNoMatchingRightRows() {
        return this.joinType == JoinType.FULL_OUTER || this.joinType == JoinType.LEFT_OUTER;
    }

    protected boolean useNonMatchingRightRows() {
        return this.joinType == JoinType.FULL_OUTER || this.joinType == JoinType.RIGHT_OUTER;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            this.left.close();
        }
    }

    protected final class LeftOnlyBatch
    implements NodeSequence.Batch {
        private final NodeSequence.Batch left;

        protected LeftOnlyBatch(NodeSequence.Batch left) {
            this.left = left;
        }

        @Override
        public int width() {
            return JoinSequence.this.totalWidth;
        }

        @Override
        public String getWorkspaceName() {
            return JoinSequence.this.workspaceName;
        }

        @Override
        public boolean isEmpty() {
            return this.left.isEmpty();
        }

        @Override
        public long rowCount() {
            return this.left.rowCount();
        }

        @Override
        public boolean hasNext() {
            return this.left.hasNext();
        }

        @Override
        public void nextRow() {
            this.left.nextRow();
        }

        @Override
        public CachedNode getNode() {
            return this.left.getNode();
        }

        @Override
        public CachedNode getNode(int index) {
            if (index < JoinSequence.this.leftWidth) {
                return this.left.getNode(index);
            }
            return null;
        }

        @Override
        public float getScore() {
            return this.left.getScore();
        }

        @Override
        public float getScore(int index) {
            if (index < JoinSequence.this.leftWidth) {
                return this.left.getScore(index);
            }
            return 0.0f;
        }
    }

    protected final class LeftOnlyBatchFactory
    implements BatchFactory {
        protected LeftOnlyBatchFactory() {
        }

        @Override
        public NodeSequence.Batch nextBatch() {
            NodeSequence.Batch leftBatch = JoinSequence.this.findNextNonEmptyLeftBatch();
            if (leftBatch == null) {
                return null;
            }
            JoinSequence.this.currentLeft = null;
            return new LeftOnlyBatch(leftBatch);
        }
    }

    protected final class RightOnlyBatch
    implements NodeSequence.Batch {
        private final NodeSequence.Batch right;

        protected RightOnlyBatch(NodeSequence.Batch right) {
            this.right = right;
        }

        @Override
        public int width() {
            return JoinSequence.this.totalWidth;
        }

        @Override
        public String getWorkspaceName() {
            return JoinSequence.this.workspaceName;
        }

        @Override
        public boolean isEmpty() {
            return this.right.isEmpty();
        }

        @Override
        public long rowCount() {
            return this.right.rowCount();
        }

        @Override
        public boolean hasNext() {
            return this.right.hasNext();
        }

        @Override
        public void nextRow() {
            this.right.nextRow();
        }

        @Override
        public CachedNode getNode() {
            return null;
        }

        @Override
        public CachedNode getNode(int index) {
            if (index < JoinSequence.this.leftWidth) {
                return null;
            }
            return this.right.getNode(index - JoinSequence.this.leftWidth);
        }

        @Override
        public float getScore() {
            return 0.0f;
        }

        @Override
        public float getScore(int index) {
            if (index < JoinSequence.this.leftWidth) {
                return 0.0f;
            }
            return this.right.getScore(index - JoinSequence.this.leftWidth);
        }
    }

    protected final class RightOnlyBatchFactory
    implements BatchFactory {
        protected RightOnlyBatchFactory() {
        }

        @Override
        public NodeSequence.Batch nextBatch() {
            NodeSequence.Batch right = JoinSequence.this.delegate.nextBatch();
            return right == null ? null : new RightOnlyBatch(right);
        }
    }

    protected final class EmptyBatchFactory
    implements BatchFactory {
        protected EmptyBatchFactory() {
        }

        @Override
        public NodeSequence.Batch nextBatch() {
            return null;
        }
    }

    protected static interface BatchFactory {
        public NodeSequence.Batch nextBatch();
    }

    public static interface RangeProducer<K> {
        public Range<K> getRange(K var1);
    }

    public static final class Range<K> {
        private final K lower;
        private final K upper;
        private final boolean lowerIncluded;
        private final boolean upperIncluded;

        public Range(K lower, boolean lowerIncluded, K upper, boolean upperIncluded) {
            this.lower = lower;
            this.upper = upper;
            this.lowerIncluded = lowerIncluded;
            this.upperIncluded = upperIncluded;
        }

        public K lowerBound() {
            return this.lower;
        }

        public K upperBound() {
            return this.upper;
        }

        public boolean isUpperBoundIncluded() {
            return this.upperIncluded;
        }

        public boolean isLowerBoundIncluded() {
            return this.lowerIncluded;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.lowerIncluded ? (char)'[' : '(');
            sb.append(this.lower);
            sb.append(',');
            sb.append(this.upper);
            sb.append(this.upperIncluded ? (char)']' : ')');
            return sb.toString();
        }
    }
}

