/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.parse;

import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrValueFactory;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.query.JcrTypeSystem;
import org.modeshape.jcr.query.model.LiteralValue;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.query.parse.BasicSqlQueryParser;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFormatException;

public class JcrSql2QueryParser
extends BasicSqlQueryParser {
    public static final String LANGUAGE = "JCR-SQL2";

    @Override
    public String getLanguage() {
        return LANGUAGE;
    }

    @Override
    protected LiteralValue literal(TypeSystem typeSystem, Object value) throws ValueFormatException {
        JcrValueFactory factory = ((JcrTypeSystem)typeSystem).getValueFactory();
        JcrValue jcrValue = null;
        if (value instanceof String) {
            jcrValue = factory.createValue((String)value);
        } else if (value instanceof Boolean) {
            jcrValue = factory.createValue((Boolean)value);
        } else if (value instanceof Binary) {
            jcrValue = factory.createValue((Binary)value);
        } else if (value instanceof DateTime) {
            jcrValue = factory.createValue(((DateTime)value).toCalendar());
        } else if (value instanceof Calendar) {
            jcrValue = factory.createValue((Calendar)value);
        } else if (value instanceof BigDecimal) {
            jcrValue = factory.createValue((BigDecimal)value);
        } else if (value instanceof Double) {
            jcrValue = factory.createValue((Double)value);
        } else if (value instanceof Long) {
            jcrValue = factory.createValue((Long)value);
        } else if (value instanceof Reference) {
            jcrValue = factory.createValue((Reference)value);
        } else if (value instanceof URI) {
            jcrValue = factory.createValue((URI)value);
        } else if (value instanceof InputStream) {
            BinaryValue binary = factory.createBinary((InputStream)value);
            jcrValue = factory.createValue((Binary)binary);
        } else if (value instanceof Name || value instanceof Path) {
            String strValue = typeSystem.getStringFactory().create(value);
            jcrValue = factory.createValue(strValue);
        } else if (value instanceof Node) {
            try {
                jcrValue = factory.createValue((Node)value);
            }
            catch (RepositoryException e) {
                throw new ValueFormatException(value, PropertyType.REFERENCE, GraphI18n.errorConvertingType.text(new Object[]{Node.class.getSimpleName(), Reference.class.getSimpleName(), value}), e);
            }
        } else {
            jcrValue = factory.createValue(value.toString());
        }
        return new LiteralValue(jcrValue, value);
    }
}

