/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.collection.Collections;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.Connectors;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.ModeShape;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.RepositoryEnvironment;
import org.modeshape.jcr.Upgrades;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.bus.ChangeBus;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.WorkspaceNotFoundException;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.RecordingChanges;
import org.modeshape.jcr.cache.change.RepositoryMetadataChanged;
import org.modeshape.jcr.cache.change.WorkspaceAdded;
import org.modeshape.jcr.cache.change.WorkspaceRemoved;
import org.modeshape.jcr.cache.document.DocumentOptimizer;
import org.modeshape.jcr.cache.document.DocumentStore;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.LocalDocumentStore;
import org.modeshape.jcr.cache.document.ReadOnlySessionCache;
import org.modeshape.jcr.cache.document.TransactionalWorkspaceCaches;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.cache.document.WritableSessionCache;
import org.modeshape.jcr.federation.FederatedDocumentStore;
import org.modeshape.jcr.locking.LockingService;
import org.modeshape.jcr.spi.federation.Connector;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.StringFactory;
import org.modeshape.schematic.Schematic;
import org.modeshape.schematic.SchematicEntry;
import org.modeshape.schematic.document.Array;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.EditableArray;
import org.modeshape.schematic.document.EditableDocument;

public class RepositoryCache {
    public static final String REPOSITORY_INFO_KEY = "repository:info";
    public static final String INITIALIZATION_LOCK = "modeshape-init-lock";
    private static final Logger LOGGER = Logger.getLogger(RepositoryCache.class);
    private static final String SYSTEM_METADATA_IDENTIFIER = "jcr:system/mode:metadata";
    private static final String REPOSITORY_NAME_FIELD_NAME = "repositoryName";
    private static final String REPOSITORY_KEY_FIELD_NAME = "repositoryKey";
    private static final String REPOSITORY_SOURCE_NAME_FIELD_NAME = "sourceName";
    private static final String REPOSITORY_SOURCE_KEY_FIELD_NAME = "sourceKey";
    private static final String REPOSITORY_CREATED_AT_FIELD_NAME = "createdAt";
    private static final String REPOSITORY_INITIALIZED_AT_FIELD_NAME = "intializedAt";
    private static final String REPOSITORY_INITIALIZER_FIELD_NAME = "intializer";
    private static final String REPOSITORY_CREATED_WITH_MODESHAPE_VERSION_FIELD_NAME = "createdWithModeShapeVersion";
    private static final String REPOSITORY_UPGRADE_ID_FIELD_NAME = "lastUpgradeId";
    private static final String REPOSITORY_UPGRADED_AT_FIELD_NAME = "lastUpgradedAt";
    private static final String REPOSITORY_UPGRADER_FIELD_NAME = "upgrader";
    private final ExecutionContext context;
    private final RepositoryConfiguration configuration;
    private final DocumentStore documentStore;
    private final DocumentTranslator translator;
    private final ConcurrentHashMap<String, WorkspaceCache> workspaceCachesByName;
    private final AtomicLong minimumStringLengthForBinaryStorage = new AtomicLong();
    private final AtomicBoolean accessControlEnabled = new AtomicBoolean(false);
    private final String name;
    private final String repoKey;
    private final String sourceKey;
    private final String rootNodeId;
    protected final ChangeBus changeBus;
    protected final NodeKey systemMetadataKey;
    private final NodeKey systemKey;
    protected final Set<String> workspaceNames;
    protected final String systemWorkspaceName;
    protected final Logger logger;
    private final RepositoryEnvironment repositoryEnvironment;
    private final TransactionalWorkspaceCaches txWorkspaceCaches;
    private final String processKey;
    protected final Upgrades upgrades;
    private volatile boolean initializingRepository = false;
    private volatile boolean upgradingRepository = false;
    private int lastUpgradeId;
    private final LockingService startupLockingService;
    private volatile boolean isHoldingClusterLock = false;
    private final int workspaceCacheSize;

    public RepositoryCache(ExecutionContext context, DocumentStore documentStore, LockingService startupLockingService, RepositoryConfiguration configuration, ContentInitializer initializer, RepositoryEnvironment repositoryEnvironment, ChangeBus changeBus, Upgrades upgradeFunctions) {
        assert (initializer != null);
        this.context = context;
        this.configuration = configuration;
        this.documentStore = documentStore;
        this.startupLockingService = startupLockingService;
        this.minimumStringLengthForBinaryStorage.set(configuration.getBinaryStorage().getMinimumStringSize());
        this.translator = new DocumentTranslator(this.context, this.documentStore, this.minimumStringLengthForBinaryStorage.get());
        this.repositoryEnvironment = repositoryEnvironment;
        this.txWorkspaceCaches = new TransactionalWorkspaceCaches(repositoryEnvironment.getTransactions());
        this.processKey = context.getProcessId();
        this.logger = Logger.getLogger(this.getClass());
        this.rootNodeId = "/";
        this.name = configuration.getName();
        this.workspaceCachesByName = new ConcurrentHashMap();
        this.workspaceNames = new CopyOnWriteArraySet<String>(configuration.getAllWorkspaceNames());
        this.upgrades = upgradeFunctions;
        this.workspaceCacheSize = configuration.getWorkspaceCacheSize();
        CheckArg.isPositive((int)this.workspaceCacheSize, (String)"workspaceCacheSize");
        if (startupLockingService != null) {
            int minutesToWait = 10;
            LOGGER.debug("Waiting at most for {0} minutes while verifying the status of the '{1}' repository", new Object[]{minutesToWait, this.name});
            this.waitUntil(() -> startupLockingService.tryLock(0L, TimeUnit.MILLISECONDS, INITIALIZATION_LOCK), minutesToWait, TimeUnit.MINUTES, JcrI18n.repositoryWasNeverInitializedAfterMinutes);
            LOGGER.debug("Repository '{0}' acquired clustered-wide lock for performing initialization or verifying status", new Object[]{this.name});
            this.isHoldingClusterLock = true;
        }
        SchematicEntry repositoryInfo = this.documentStore.localStore().get(REPOSITORY_INFO_KEY);
        boolean upgradeRequired = false;
        String databaseId = documentStore.localStore().databaseId();
        if (repositoryInfo == null) {
            String initializerId = UUID.randomUUID().toString();
            this.repoKey = NodeKey.keyForSourceName(this.name);
            this.sourceKey = NodeKey.keyForSourceName(databaseId);
            DateTime now = context.getValueFactories().getDateFactory().create();
            EditableDocument doc = Schematic.newDocument();
            doc.setString(REPOSITORY_NAME_FIELD_NAME, this.name);
            doc.setString(REPOSITORY_KEY_FIELD_NAME, this.repoKey);
            doc.setString(REPOSITORY_SOURCE_NAME_FIELD_NAME, databaseId);
            doc.setString(REPOSITORY_SOURCE_KEY_FIELD_NAME, this.sourceKey);
            doc.setDate(REPOSITORY_CREATED_AT_FIELD_NAME, now.toDate());
            doc.setString(REPOSITORY_INITIALIZER_FIELD_NAME, initializerId);
            doc.setString(REPOSITORY_CREATED_WITH_MODESHAPE_VERSION_FIELD_NAME, ModeShape.getVersion());
            doc.setNumber(REPOSITORY_UPGRADE_ID_FIELD_NAME, this.upgrades.getLatestAvailableUpgradeId());
            SchematicEntry entryWrittenBySomeOtherProcess = this.localStore().runInTransaction(() -> this.documentStore.storeIfAbsent(REPOSITORY_INFO_KEY, (Document)doc), 0, new String[0]);
            if (entryWrittenBySomeOtherProcess != null) {
                throw new SystemFailureException(JcrI18n.repositoryWasInitializedByOtherProcess.text(new Object[]{this.name}));
            }
            repositoryInfo = this.documentStore.get(REPOSITORY_INFO_KEY);
            this.initializingRepository = true;
            LOGGER.debug("Initializing the '{0}' repository", new Object[]{this.name});
        } else {
            Document info = repositoryInfo.content();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Repository '{0}' already initialized at '{1}'", new Object[]{this.name, info.get(REPOSITORY_INITIALIZED_AT_FIELD_NAME)});
            }
            String repoName = info.getString(REPOSITORY_NAME_FIELD_NAME, this.name);
            String sourceName = info.getString(REPOSITORY_SOURCE_NAME_FIELD_NAME, databaseId);
            this.repoKey = info.getString(REPOSITORY_KEY_FIELD_NAME, NodeKey.keyForSourceName(repoName));
            this.sourceKey = info.getString(REPOSITORY_SOURCE_KEY_FIELD_NAME, NodeKey.keyForSourceName(sourceName));
            this.lastUpgradeId = info.getInteger(REPOSITORY_UPGRADE_ID_FIELD_NAME, 0);
            upgradeRequired = this.upgrades.isUpgradeRequired(this.lastUpgradeId);
            if (upgradeRequired && info.getString(REPOSITORY_UPGRADER_FIELD_NAME) == null) {
                int nextId = this.upgrades.getLatestAvailableUpgradeId();
                LOGGER.debug("The content in repository '{0}' needs to be upgraded (steps {1}->{2})", new Object[]{this.name, this.lastUpgradeId, nextId});
                this.upgradingRepository = this.localStore().runInTransaction(() -> {
                    int lastUpgradeId;
                    LocalDocumentStore store = this.documentStore().localStore();
                    EditableDocument editor = store.edit(REPOSITORY_INFO_KEY, true);
                    if (editor.get(REPOSITORY_UPGRADER_FIELD_NAME) == null && this.upgrades.isUpgradeRequired(lastUpgradeId = editor.getInteger(REPOSITORY_UPGRADE_ID_FIELD_NAME, 0))) {
                        String upgraderId = UUID.randomUUID().toString();
                        editor.setString(REPOSITORY_UPGRADER_FIELD_NAME, upgraderId);
                        return true;
                    }
                    return false;
                }, 1, REPOSITORY_INFO_KEY);
                if (this.upgradingRepository) {
                    LOGGER.debug("This process will upgrade the content in repository '{0}'", new Object[]{this.name});
                } else {
                    LOGGER.debug("The content in repository '{0}' does not need to be upgraded", new Object[]{this.name});
                }
            }
        }
        if (upgradeRequired && !this.upgradingRepository) {
            LOGGER.debug("Waiting at most for 10 minutes for another process in the cluster to upgrade the content in existing repository '{0}'", new Object[]{this.name});
            this.waitUntil(() -> {
                Document info = this.documentStore().localStore().get(REPOSITORY_INFO_KEY).content();
                int lastUpgradeId = info.getInteger(REPOSITORY_UPGRADE_ID_FIELD_NAME, 0);
                return !this.upgrades.isUpgradeRequired(lastUpgradeId);
            }, 10L, TimeUnit.MINUTES, JcrI18n.repositoryWasNeverUpgradedAfterMinutes);
            LOGGER.debug("Content in existing repository '{0}' has been fully upgraded", new Object[]{this.name});
        } else if (!this.initializingRepository) {
            LOGGER.debug("Content in existing repository '{0}' does not need to be upgraded", new Object[]{this.name});
        }
        this.systemWorkspaceName = "system";
        String systemWorkspaceKey = NodeKey.keyForWorkspaceName(this.systemWorkspaceName);
        this.systemMetadataKey = new NodeKey(this.sourceKey, systemWorkspaceKey, SYSTEM_METADATA_IDENTIFIER);
        this.refreshRepositoryMetadata(false);
        this.changeBus = changeBus;
        this.changeBus.registerInThread(new ChangesToWorkspacesListener());
        SessionCache systemSession = this.createSession(context, this.systemWorkspaceName, false);
        NodeKey systemRootKey = systemSession.getRootKey();
        CachedNode systemRoot = systemSession.getNode(systemRootKey);
        this.logger.debug("System root: {0}", new Object[]{systemRoot});
        ChildReference systemRef = systemRoot.getChildReferences(systemSession).getChild(JcrLexicon.SYSTEM);
        this.logger.debug("jcr:system child reference: {0}", new Object[]{systemRef});
        CachedNode systemNode = systemRef != null ? systemSession.getNode(systemRef) : null;
        this.logger.debug("System node: {0}", new Object[]{systemNode});
        if (systemRef == null || systemNode == null) {
            this.logger.debug("Creating the '{0}' workspace in repository '{1}'", new Object[]{this.systemWorkspaceName, this.name});
            MutableCachedNode root = systemSession.mutable(systemRootKey);
            initializer.initializeSystemArea(systemSession, root);
            systemSession.save();
            this.refreshWorkspace(this.systemWorkspaceName);
            systemSession = this.createSession(context, this.systemWorkspaceName, false);
            systemRoot = systemSession.getNode(systemRootKey);
            systemRef = systemRoot.getChildReferences(systemSession).getChild(JcrLexicon.SYSTEM);
            if (systemRef == null) {
                throw new SystemFailureException(JcrI18n.unableToInitializeSystemWorkspace.text(new Object[]{this.name}));
            }
        } else {
            this.logger.debug("Found existing '{0}' workspace in repository '{1}'", new Object[]{this.systemWorkspaceName, this.name});
            if (initializer.initializeIndexStorage(systemSession, systemSession.mutable(systemNode.getKey()))) {
                this.logger.debug("Initialized index storage area in the '{0}' workspace of the repository '{1}'", new Object[]{this.systemWorkspaceName, this.name});
                systemSession.save();
            }
        }
        this.systemKey = systemRef.getKey();
        this.documentStore.setLocalSourceKey(this.sourceKey);
    }

    protected boolean waitUntil(Callable<Boolean> condition, long time, TimeUnit unit, I18n failureMsg) {
        long startTime = System.currentTimeMillis();
        long quitTime = startTime + TimeUnit.MILLISECONDS.convert(time, unit);
        Exception lastError = null;
        while (System.currentTimeMillis() < quitTime) {
            try {
                lastError = null;
                if (condition.call().booleanValue()) {
                    return true;
                }
            }
            catch (Exception e) {
                lastError = e;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                break;
            }
        }
        LOGGER.error((Throwable)lastError, (I18nResource)failureMsg, new Object[]{this.name, time});
        String msg = failureMsg.text(new Object[]{this.name, time});
        throw new SystemFailureException(msg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void rollbackRepositoryInfo() {
        try {
            SchematicEntry repositoryInfoEntry = this.documentStore.localStore().get(REPOSITORY_INFO_KEY);
            if (repositoryInfoEntry != null && this.isInitializingRepository()) {
                this.localStore().runInTransaction(() -> {
                    Document repoInfoDoc = repositoryInfoEntry.content();
                    if (!repoInfoDoc.containsField(REPOSITORY_INITIALIZED_AT_FIELD_NAME)) {
                        this.documentStore.localStore().remove(REPOSITORY_INFO_KEY);
                    }
                    return null;
                }, 0, REPOSITORY_INFO_KEY);
            }
            if (!this.isHoldingClusterLock) return;
        }
        catch (Throwable throwable) {
            if (!this.isHoldingClusterLock) throw throwable;
            this.startupLockingService.unlock(INITIALIZATION_LOCK);
            this.isHoldingClusterLock = false;
            LOGGER.debug("Repository '{0}' released clustered-wide lock after failing to start up ", new Object[]{this.name});
            throw throwable;
        }
        this.startupLockingService.unlock(INITIALIZATION_LOCK);
        this.isHoldingClusterLock = false;
        LOGGER.debug("Repository '{0}' released clustered-wide lock after failing to start up ", new Object[]{this.name});
    }

    public final ChangeBus changeBus() {
        return this.changeBus;
    }

    protected final RepositoryEnvironment repositoryEnvironment() {
        return this.repositoryEnvironment;
    }

    protected final String processKey() {
        return this.processKey;
    }

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    public final boolean isInitializingRepository() {
        return this.initializingRepository;
    }

    public final boolean isAccessControlEnabled() {
        return this.accessControlEnabled.get();
    }

    protected LocalDocumentStore localStore() {
        return this.documentStore.localStore();
    }

    public final void setAccessControlEnabled(boolean enabled) {
        if (this.accessControlEnabled.compareAndSet(!enabled, enabled)) {
            this.refreshRepositoryMetadata(true);
            String userId = this.context.getSecurityContext().getUserName();
            Map<String, String> userData = this.context.getData();
            DateTime timestamp = this.context.getValueFactories().getDateFactory().create();
            RecordingChanges changes = new RecordingChanges(this.context.getId(), this.context.getProcessId(), this.getKey(), null, this.repositoryEnvironment.journalId());
            changes.repositoryMetadataChanged();
            changes.freeze(userId, userData, timestamp);
            this.changeBus.notify(changes);
        }
    }

    protected final DocumentStore documentStore() {
        return this.documentStore;
    }

    protected final ExecutionContext context() {
        return this.context;
    }

    public RepositoryCache completeInitialization() {
        RepositoryCache repositoryCache;
        block4: {
            try {
                if (this.initializingRepository) {
                    LOGGER.debug("Marking repository '{0}' as fully initialized", new Object[]{this.name});
                    this.localStore().runInTransaction(() -> {
                        LocalDocumentStore store = this.documentStore().localStore();
                        EditableDocument repositoryInfo = store.edit(REPOSITORY_INFO_KEY, true);
                        if (repositoryInfo.get(REPOSITORY_INITIALIZED_AT_FIELD_NAME) == null) {
                            DateTime now = this.context().getValueFactories().getDateFactory().create();
                            repositoryInfo.setDate(REPOSITORY_INITIALIZED_AT_FIELD_NAME, now.toDate());
                        }
                        return null;
                    }, 0, REPOSITORY_INFO_KEY);
                    LOGGER.debug("Repository '{0}' is fully initialized", new Object[]{this.name});
                }
                repositoryCache = this;
                if (!this.isHoldingClusterLock) break block4;
            }
            catch (Throwable throwable) {
                if (this.isHoldingClusterLock) {
                    this.startupLockingService.unlock(INITIALIZATION_LOCK);
                    this.isHoldingClusterLock = false;
                    LOGGER.debug("Repository '{0}' released clustered-wide lock after successful startup", new Object[]{this.name});
                }
                throw throwable;
            }
            this.startupLockingService.unlock(INITIALIZATION_LOCK);
            this.isHoldingClusterLock = false;
            LOGGER.debug("Repository '{0}' released clustered-wide lock after successful startup", new Object[]{this.name});
        }
        return repositoryCache;
    }

    public RepositoryCache completeUpgrade(Upgrades.Context resources) {
        if (this.upgradingRepository) {
            try {
                this.localStore().runInTransaction(() -> {
                    LOGGER.debug("Upgrading repository '{0}'", new Object[]{this.name});
                    this.lastUpgradeId = this.upgrades.applyUpgradesSince(this.lastUpgradeId, resources);
                    LOGGER.debug("Recording upgrade completion in repository '{0}'", new Object[]{this.name});
                    LocalDocumentStore store = this.documentStore().localStore();
                    EditableDocument editor = store.edit(REPOSITORY_INFO_KEY, true);
                    DateTime now = this.context().getValueFactories().getDateFactory().create();
                    editor.setDate(REPOSITORY_UPGRADED_AT_FIELD_NAME, now.toDate());
                    editor.setNumber(REPOSITORY_UPGRADE_ID_FIELD_NAME, this.lastUpgradeId);
                    editor.remove(REPOSITORY_UPGRADER_FIELD_NAME);
                    return null;
                }, 1, REPOSITORY_INFO_KEY);
                LOGGER.debug("Repository '{0}' is fully upgraded", new Object[]{this.name});
            }
            catch (Throwable err) {
                this.logger.error(err, (I18nResource)JcrI18n.failureDuringUpgradeOperation, new Object[]{this.getName(), err});
                resources.getProblems().addError(err, JcrI18n.failureDuringUpgradeOperation, new Object[]{this.getName(), err});
            }
        }
        return this;
    }

    public void startShutdown() {
        this.workspaceCachesByName.values().stream().forEach(WorkspaceCache::signalClosing);
    }

    public void completeShutdown() {
        this.workspaceCachesByName.values().stream().forEach(WorkspaceCache::signalClosed);
        this.workspaceCachesByName.clear();
    }

    public NodeKey getRepositoryMetadataDocumentKey() {
        return this.systemMetadataKey;
    }

    public void setLargeStringLength(long sizeInBytes) {
        assert (sizeInBytes > -1L);
        this.minimumStringLengthForBinaryStorage.set(sizeInBytes);
        for (WorkspaceCache workspaceCache : this.workspaceCachesByName.values()) {
            assert (workspaceCache != null);
            workspaceCache.setMinimumStringLengthForBinaryStorage(this.minimumStringLengthForBinaryStorage.get());
        }
    }

    public long largeValueSizeInBytes() {
        return this.minimumStringLengthForBinaryStorage.get();
    }

    protected void refreshRepositoryMetadata(boolean update) {
        String systemMetadataKeyStr = this.systemMetadataKey.toString();
        boolean accessControlEnabled = this.accessControlEnabled.get();
        SchematicEntry entry = this.documentStore.get(systemMetadataKeyStr);
        if (!update && entry != null) {
            Document doc = entry.content();
            Property accessProp = this.translator.getProperty(doc, this.name("accessControl"));
            boolean enabled = false;
            if (accessProp != null) {
                enabled = this.context.getValueFactories().getBooleanFactory().create(accessProp.getFirstValue());
            }
            this.accessControlEnabled.set(enabled);
            Property prop = this.translator.getProperty(doc, this.name("workspaces"));
            HashSet<String> persistedWorkspaceNames = new HashSet<String>();
            StringFactory strings = this.context.getValueFactories().getStringFactory();
            boolean workspaceNotYetPersisted = false;
            for (Object value : prop) {
                String workspaceName = (String)strings.create(value);
                persistedWorkspaceNames.add(workspaceName);
            }
            for (String configuredWorkspaceName : this.workspaceNames) {
                if (persistedWorkspaceNames.contains(configuredWorkspaceName)) continue;
                workspaceNotYetPersisted = true;
                break;
            }
            this.workspaceNames.addAll(persistedWorkspaceNames);
            if (!workspaceNotYetPersisted) {
                return;
            }
        }
        try {
            this.localStore().runInTransaction(() -> {
                SchematicEntry systemEntry = this.documentStore().get(systemMetadataKeyStr);
                if (systemEntry == null) {
                    EditableDocument newDoc = Schematic.newDocument();
                    this.translator.setKey(newDoc, this.systemMetadataKey);
                    systemEntry = this.documentStore.storeIfAbsent(systemMetadataKeyStr, (Document)newDoc);
                    if (systemEntry == null) {
                        systemEntry = this.documentStore.get(systemMetadataKeyStr);
                    }
                }
                EditableDocument doc = this.documentStore().localStore().edit(systemMetadataKeyStr, true);
                PropertyFactory propFactory = this.context().getPropertyFactory();
                this.translator.setProperty(doc, propFactory.create(this.name("workspaces"), this.workspaceNames), null, null);
                this.translator.setProperty(doc, propFactory.create(this.name("accessControl"), accessControlEnabled), null, null);
                return null;
            }, 2, REPOSITORY_INFO_KEY);
        }
        catch (RuntimeException re) {
            LOGGER.error((I18nResource)JcrI18n.errorUpdatingRepositoryMetadata, new Object[]{this.name, re.getMessage()});
            throw re;
        }
    }

    public void runOneTimeSystemInitializationOperation(Callable<Void> initOperation) throws Exception {
        if (!this.isInitializingRepository()) {
            return;
        }
        SessionCache systemSession = this.createSession(this.context, this.systemWorkspaceName, false);
        MutableCachedNode systemNode = this.getSystemNode(systemSession);
        ChildReference repositoryReference = systemNode.getChildReferences(systemSession).getChild(ModeShapeLexicon.REPOSITORY);
        if (repositoryReference != null) {
            return;
        }
        initOperation.call();
        Property primaryType = this.context.getPropertyFactory().create(JcrLexicon.PRIMARY_TYPE, ModeShapeLexicon.REPOSITORY);
        systemNode.createChild(systemSession, systemNode.getKey().withId("mode:repository"), ModeShapeLexicon.REPOSITORY, primaryType, new Property[0]);
        systemSession.save();
    }

    private MutableCachedNode getSystemNode(SessionCache systemSession) {
        NodeKey systemRootKey = systemSession.getRootKey();
        CachedNode systemRoot = systemSession.getNode(systemRootKey);
        ChildReference systemRef = systemRoot.getChildReferences(systemSession).getChild(JcrLexicon.SYSTEM);
        return systemSession.mutable(systemRef.getKey());
    }

    public final String getKey() {
        return this.repoKey;
    }

    public final NodeKey getSystemKey() {
        return this.systemKey;
    }

    public final String getSystemWorkspaceKey() {
        return NodeKey.keyForWorkspaceName(this.getSystemWorkspaceName());
    }

    public final String getSystemWorkspaceName() {
        return this.systemWorkspaceName;
    }

    public final String getName() {
        return this.name;
    }

    public final Set<String> getWorkspaceNames() {
        return Collections.unmodifiableSet(this.workspaceNames);
    }

    WorkspaceCache workspace(String name) {
        boolean isSystemWorkspace = this.systemWorkspaceName.equals(name);
        if (!this.workspaceNames.contains(name) && !isSystemWorkspace) {
            throw new WorkspaceNotFoundException(name);
        }
        WorkspaceCache systemWorkspaceCache = isSystemWorkspace ? null : this.workspaceCachesByName.get(this.systemWorkspaceName);
        return this.workspaceCachesByName.computeIfAbsent(name, wsName -> this.initializeCacheForWorkspace((String)wsName, systemWorkspaceCache));
    }

    private WorkspaceCache initializeCacheForWorkspace(String name, WorkspaceCache systemWorkspaceCache) {
        String workspaceKey = NodeKey.keyForWorkspaceName(name);
        NodeKey rootKey = new NodeKey(this.sourceKey, workspaceKey, this.rootNodeId);
        return this.localStore().runInLocalTransaction(() -> {
            ConcurrentMap nodeCache = this.cacheForWorkspace().asMap();
            ExecutionContext context = this.context();
            this.logger.debug("Attempting to initialize a new ws cache for workspace '{0}' in repository '{1}' with root key '{2}'", new Object[]{name, this.getName(), rootKey});
            EditableDocument rootDoc = Schematic.newDocument();
            DocumentTranslator trans = new DocumentTranslator(context, this.documentStore, Long.MAX_VALUE);
            trans.setProperty(rootDoc, context.getPropertyFactory().create(JcrLexicon.PRIMARY_TYPE, ModeShapeLexicon.ROOT), null, null);
            String rootKeyString = rootKey.toString();
            trans.setProperty(rootDoc, context.getPropertyFactory().create(JcrLexicon.UUID, rootKeyString), null, null);
            WorkspaceCache result = new WorkspaceCache(context, this.getKey(), name, systemWorkspaceCache, this.documentStore, this.translator, rootKey, nodeCache, this.changeBus, this.repositoryEnvironment());
            if (this.documentStore.storeIfAbsent(rootKeyString, (Document)rootDoc) == null && !this.systemWorkspaceName.equals(name)) {
                this.logger.debug("Creating '{0}' workspace in repository '{1}' with root '{2}'", new Object[]{name, this.getName(), rootKey});
                rootDoc = this.documentStore.edit(rootKeyString, false);
                EditableDocument systemChildRefDoc = this.translator.childReferenceDocument(this.systemKey, JcrLexicon.SYSTEM);
                rootDoc.setArray("children", (Array)Schematic.newArray((Object[])new Object[]{systemChildRefDoc}));
                EditableDocument childInfo = rootDoc.getOrCreateDocument("childrenInfo");
                childInfo.setNumber("count", 1);
                EditableDocument systemDoc = this.documentStore.edit(this.systemKey.toString(), false);
                assert (systemDoc != null);
                String parent = systemDoc.getString("parent");
                EditableArray parents = systemDoc.getOrCreateArray("parent");
                if (parent != null) {
                    parents.add((Object)parent);
                }
                parents.add((Object)rootKeyString);
            }
            return result;
        }, 0, REPOSITORY_INFO_KEY);
    }

    protected Cache<NodeKey, CachedNode> cacheForWorkspace() {
        return Caffeine.newBuilder().maximumSize((long)this.workspaceCacheSize).executor(Runnable::run).build();
    }

    public final DocumentTranslator getDocumentTranslator() {
        return this.translator;
    }

    void removeWorkspaceCaches(String name) {
        assert (name != null);
        assert (!this.workspaceNames.contains(name));
        WorkspaceCache removed = this.workspaceCachesByName.remove(name);
        if (removed != null) {
            removed.signalDeleted();
            this.txWorkspaceCaches.rollbackActiveTransactionsForWorkspace(name);
        }
    }

    void refreshWorkspace(String name) {
        assert (name != null);
        this.workspaceCachesByName.remove(name);
    }

    Iterable<WorkspaceCache> workspaces() {
        return this.workspaceCachesByName.values();
    }

    public WorkspaceCache createWorkspace(String name) {
        if (!this.workspaceNames.contains(name)) {
            if (!this.configuration.isCreatingWorkspacesAllowed()) {
                throw new UnsupportedOperationException(JcrI18n.creatingWorkspacesIsNotAllowedInRepository.text(new Object[]{this.getName()}));
            }
            this.workspaceNames.add(name);
            this.refreshRepositoryMetadata(true);
            SessionCache session = this.createSession(this.context, name, false);
            MutableCachedNode root = session.mutable(session.getRootKey());
            ChildReference ref = root.getChildReferences(session).getChild(JcrLexicon.SYSTEM);
            if (ref == null) {
                root.linkChild(session, this.systemKey, JcrLexicon.SYSTEM);
                session.save();
            }
            String userId = this.context.getSecurityContext().getUserName();
            Map<String, String> userData = this.context.getData();
            DateTime timestamp = this.context.getValueFactories().getDateFactory().create();
            RecordingChanges changes = new RecordingChanges(this.context.getId(), this.context.getProcessId(), this.getKey(), null, this.repositoryEnvironment.journalId());
            changes.workspaceAdded(name);
            changes.freeze(userId, userData, timestamp);
            this.changeBus.notify(changes);
        }
        return this.workspace(name);
    }

    public boolean destroyWorkspace(String name, WritableSessionCache removeSession) {
        if (this.workspaceNames.contains(name)) {
            if (this.configuration.getPredefinedWorkspaceNames().contains(name)) {
                throw new UnsupportedOperationException(JcrI18n.unableToDestroyPredefinedWorkspaceInRepository.text(new Object[]{name, this.getName()}));
            }
            if (this.configuration.getDefaultWorkspaceName().equals(name)) {
                throw new UnsupportedOperationException(JcrI18n.unableToDestroyDefaultWorkspaceInRepository.text(new Object[]{name, this.getName()}));
            }
            if (this.systemWorkspaceName.equals(name)) {
                throw new UnsupportedOperationException(JcrI18n.unableToDestroySystemWorkspaceInRepository.text(new Object[]{name, this.getName()}));
            }
            if (!this.configuration.isCreatingWorkspacesAllowed()) {
                throw new UnsupportedOperationException(JcrI18n.creatingWorkspacesIsNotAllowedInRepository.text(new Object[]{this.getName()}));
            }
            this.localStore().runInTransaction(() -> {
                removeSession.mutable(removeSession.getRootKey()).removeChild(removeSession, this.getSystemKey());
                this.workspaceNames.remove(name);
                this.refreshRepositoryMetadata(true);
                removeSession.save();
                return null;
            }, 0, new String[0]);
            String userId = this.context.getSecurityContext().getUserName();
            Map<String, String> userData = this.context.getData();
            DateTime timestamp = this.context.getValueFactories().getDateFactory().create();
            RecordingChanges changes = new RecordingChanges(this.context.getId(), this.context.getProcessId(), this.getKey(), null, this.repositoryEnvironment.journalId());
            changes.workspaceRemoved(name);
            changes.freeze(userId, userData, timestamp);
            this.changeBus.notify(changes);
            return true;
        }
        return false;
    }

    public WorkspaceCache getWorkspaceCache(String workspaceName) {
        return this.workspace(workspaceName);
    }

    public WorkspaceCache createExternalWorkspace(String name, Connectors connectors) {
        String[] tokens = name.split(":");
        String sourceName = tokens[0];
        String workspaceName = tokens[1];
        this.workspaceNames.add(workspaceName);
        this.refreshRepositoryMetadata(true);
        ConcurrentMap nodeCache = this.cacheForWorkspace().asMap();
        ExecutionContext context = this.context();
        String sourceKey = NodeKey.keyForSourceName(sourceName);
        String workspaceKey = NodeKey.keyForWorkspaceName(workspaceName);
        Connector connector = connectors.getConnectorForSourceName(sourceName);
        if (connector == null) {
            throw new IllegalArgumentException(JcrI18n.connectorNotFound.text(new Object[]{sourceName}));
        }
        FederatedDocumentStore documentStore = new FederatedDocumentStore(connectors, this.documentStore().localStore());
        String rootId = connector.getRootDocumentId();
        NodeKey rootKey = new NodeKey(sourceKey, workspaceKey, rootId);
        WorkspaceCache systemWorkspaceCache = this.workspaceCachesByName.get(this.systemWorkspaceName);
        WorkspaceCache workspaceCache = new WorkspaceCache(context, this.getKey(), workspaceName, systemWorkspaceCache, documentStore, this.translator, rootKey, nodeCache, this.changeBus, this.repositoryEnvironment());
        this.workspaceCachesByName.put(workspaceName, workspaceCache);
        return this.workspace(workspaceName);
    }

    public SessionCache createSession(ExecutionContext context, String workspaceName, boolean readOnly) {
        WorkspaceCache workspaceCache = this.workspace(workspaceName);
        if (readOnly) {
            return new ReadOnlySessionCache(context, workspaceCache);
        }
        return new WritableSessionCache(context, workspaceCache, this.txWorkspaceCaches, this.repositoryEnvironment);
    }

    public LocalDocumentStore.DocumentOperationResults optimizeChildren(int targetCountPerBlock, int tolerance) {
        Stopwatch sw = new Stopwatch();
        this.logger.info((I18nResource)JcrI18n.beginChildrenOptimization, new Object[]{this.getName()});
        sw.start();
        DocumentOptimizer optimizer = new DocumentOptimizer(this.documentStore());
        try {
            LocalDocumentStore.DocumentOperationResults results = this.documentStore().localStore().performOnEachDocument((key, document) -> optimizer.optimizeChildrenBlocks(new NodeKey((String)key), (EditableDocument)document, targetCountPerBlock, tolerance));
            sw.stop();
            this.logger.info((I18nResource)JcrI18n.completeChildrenOptimization, new Object[]{this.getName(), sw.getTotalDuration().toSimpleString(), results});
            return results;
        }
        catch (Throwable e) {
            this.logger.info((I18nResource)JcrI18n.errorDuringChildrenOptimization, new Object[]{this.getName(), sw.getTotalDuration().toSimpleString(), e});
            return null;
        }
    }

    public String toString() {
        return this.name;
    }

    public static interface ContentInitializer {
        public void initializeSystemArea(SessionCache var1, MutableCachedNode var2);

        public boolean initializeIndexStorage(SessionCache var1, MutableCachedNode var2);
    }

    protected class ChangesToWorkspacesListener
    implements ChangeSetListener {
        protected ChangesToWorkspacesListener() {
        }

        @Override
        public void notify(ChangeSet changeSet) {
            if (changeSet == null || !RepositoryCache.this.getKey().equals(changeSet.getRepositoryKey())) {
                return;
            }
            if (changeSet.getWorkspaceName() == null) {
                HashSet<String> removedNames = new HashSet<String>();
                boolean changed = false;
                for (Change change : changeSet) {
                    if (change instanceof WorkspaceAdded) {
                        String addedName = ((WorkspaceAdded)change).getWorkspaceName();
                        if (RepositoryCache.this.getWorkspaceNames().contains(addedName)) continue;
                        changed = true;
                        continue;
                    }
                    if (change instanceof WorkspaceRemoved) {
                        String removedName = ((WorkspaceRemoved)change).getWorkspaceName();
                        removedNames.add(removedName);
                        if (!RepositoryCache.this.getWorkspaceNames().contains(removedName)) continue;
                        changed = true;
                        continue;
                    }
                    if (!(change instanceof RepositoryMetadataChanged)) continue;
                    changed = true;
                }
                if (changed) {
                    RepositoryCache.this.refreshRepositoryMetadata(false);
                    for (String removedName : removedNames) {
                        RepositoryCache.this.removeWorkspaceCaches(removedName);
                    }
                }
            }
        }
    }
}

