/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.spi.index.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.AbstractPropertyChange;
import org.modeshape.jcr.cache.change.ChangeSetAdapter;
import org.modeshape.jcr.cache.change.PropertyAdded;
import org.modeshape.jcr.cache.change.PropertyChanged;
import org.modeshape.jcr.cache.change.PropertyRemoved;
import org.modeshape.jcr.spi.index.provider.IndexChangeAdapter;
import org.modeshape.jcr.spi.index.provider.ProvidedIndex;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.binary.BinaryStoreException;

@Immutable
public class IndexChangeAdapters {
    public static IndexChangeAdapter forMultipleColumns(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, ProvidedIndex<?> index, Iterable<IndexChangeAdapter> adapters) {
        return new MultiColumnChangeAdapter(context, workspaceName, matcher, index, adapters);
    }

    public static IndexChangeAdapter forNodeDepth(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, ProvidedIndex<?> index) {
        return new NodeDepthChangeAdapter(context, matcher, workspaceName, index);
    }

    public static IndexChangeAdapter forNodeName(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, ProvidedIndex<?> index) {
        return new NodeNameChangeAdapter(context, matcher, workspaceName, index);
    }

    public static IndexChangeAdapter forNodeLocalName(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, ProvidedIndex<?> index) {
        return new NodeLocalNameChangeAdapter(context, matcher, workspaceName, index);
    }

    public static IndexChangeAdapter forNodePath(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, ProvidedIndex<?> index) {
        return new NodePathChangeAdapter(context, matcher, workspaceName, index);
    }

    public static IndexChangeAdapter forPrimaryType(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, ProvidedIndex<?> index) {
        return new PrimaryTypeChangeAdapter(context, matcher, workspaceName, index);
    }

    public static IndexChangeAdapter forMixinTypes(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, ProvidedIndex<?> index) {
        return new MixinTypesChangeAdapter(context, matcher, workspaceName, index);
    }

    public static <T> IndexChangeAdapter forProperty(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, Name propertyName, ValueFactory<T> factory, ProvidedIndex<?> index) {
        return new PropertyChangeAdapter<T>(context, matcher, workspaceName, propertyName, factory, index);
    }

    public static <T> IndexChangeAdapter forUniqueValuedProperty(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, Name propertyName, ValueFactory<T> factory, ProvidedIndex<?> index) {
        return new UniquePropertyChangeAdapter<T>(context, matcher, workspaceName, propertyName, factory, index);
    }

    public static IndexChangeAdapter forEnumeratedProperty(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, Name propertyName, ProvidedIndex<?> index) {
        return new EnumeratedPropertyChangeAdapter(context, matcher, workspaceName, propertyName, index);
    }

    public static IndexChangeAdapter forNodeTypes(String propertyName, ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, ProvidedIndex<?> index) {
        return new NodeTypesChangeAdapter(propertyName, context, matcher, workspaceName, index);
    }

    public static IndexChangeAdapter forTextProperty(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, Name propertyName, ValueFactory<String> factory, ProvidedIndex<?> index) {
        return new TextPropertyChangeAdapter(context, matcher, workspaceName, propertyName, factory, index);
    }

    private IndexChangeAdapters() {
    }

    protected static final class TextPropertyChangeAdapter
    extends PropertyChangeAdapter<String> {
        public TextPropertyChangeAdapter(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, Name propertyName, ValueFactory<String> valueFactory, ProvidedIndex<?> index) {
            super(context, matcher, workspaceName, propertyName, valueFactory, index);
        }

        @Override
        protected void addValues(NodeKey key, Property property) {
            StringBuilder builder = this.textFrom(property);
            if (builder.length() > 0) {
                this.index().add(TextPropertyChangeAdapter.nodeKey(key), this.propertyName(), builder.toString());
            }
        }

        @Override
        protected void removeValues(NodeKey key, Property property) {
            StringBuilder builder = this.textFrom(property);
            if (builder.length() > 0) {
                this.index().remove(TextPropertyChangeAdapter.nodeKey(key), this.propertyName(), builder.toString());
            }
        }

        protected StringBuilder textFrom(Property property) {
            StringBuilder builder = new StringBuilder();
            if (property.isEmpty()) {
                return builder;
            }
            if (!property.isBinary()) {
                String[] values = (String[])property.getValuesAsArray(this.valueFactory);
                for (int i = 0; i < values.length; ++i) {
                    builder.append(values[i]);
                    if (i >= values.length - 1) continue;
                    builder.append(" ");
                }
            } else {
                Iterator valuesIterator = property.iterator();
                while (valuesIterator.hasNext()) {
                    Object value = valuesIterator.next();
                    assert (value instanceof BinaryValue);
                    BinaryValue binaryValue = (BinaryValue)value;
                    try {
                        String extractedText = this.context.getBinaryStore().getText(binaryValue);
                        builder.append(extractedText);
                        if (!valuesIterator.hasNext()) continue;
                        builder.append(" ");
                    }
                    catch (BinaryStoreException e) {
                        this.logger.debug((Throwable)((Object)e), "Error trying to get extracted text for {0}", new Object[]{binaryValue});
                    }
                }
            }
            return builder;
        }
    }

    protected static final class NodeTypesChangeAdapter
    extends EnumeratedPropertyChangeAdapter {
        private final String property;

        public NodeTypesChangeAdapter(String property, ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, ProvidedIndex<?> index) {
            super(context, matcher, workspaceName, null, index);
            this.property = property;
            assert (this.property != null);
        }

        @Override
        protected void modifyProperties(NodeKey key, Name primaryType, Set<Name> mixinTypes, Map<Name, AbstractPropertyChange> propChanges) {
            ArrayList<Object> newValues = new ArrayList<Object>();
            ArrayList<Object> oldValues = new ArrayList<Object>();
            AbstractPropertyChange primaryTypeChange = propChanges.get(JcrLexicon.PRIMARY_TYPE);
            if (primaryTypeChange instanceof PropertyChanged) {
                PropertyChanged change = (PropertyChanged)primaryTypeChange;
                oldValues.add(change.getOldProperty().getFirstValue());
                newValues.add(change.getNewProperty().getFirstValue());
            } else if (primaryTypeChange instanceof PropertyAdded) {
                newValues.add(primaryTypeChange.getProperty().getFirstValue());
            } else if (primaryTypeChange instanceof PropertyRemoved) {
                oldValues.add(primaryTypeChange.getProperty().getFirstValue());
            }
            AbstractPropertyChange mixinsTypeChange = propChanges.get(JcrLexicon.MIXIN_TYPES);
            if (mixinsTypeChange instanceof PropertyChanged) {
                Property newProperty;
                PropertyChanged change = (PropertyChanged)mixinsTypeChange;
                Property oldProperty = change.getOldProperty();
                if (!oldProperty.isEmpty()) {
                    oldValues.addAll(Arrays.asList(oldProperty.getValuesAsArray()));
                }
                if (!(newProperty = change.getNewProperty()).isEmpty()) {
                    newValues.addAll(Arrays.asList(newProperty.getValuesAsArray()));
                }
            } else if (mixinsTypeChange instanceof PropertyAdded) {
                if (!mixinsTypeChange.getProperty().isEmpty()) {
                    newValues.addAll(Arrays.asList(mixinsTypeChange.getProperty().getValuesAsArray()));
                }
            } else if (mixinsTypeChange instanceof PropertyRemoved && !mixinsTypeChange.getProperty().isEmpty()) {
                oldValues.addAll(Arrays.asList(mixinsTypeChange.getProperty().getValuesAsArray()));
            }
            if (primaryTypeChange == null && mixinsTypeChange == null) {
                return;
            }
            if (primaryTypeChange == null) {
                newValues.add(primaryType);
            } else if (mixinsTypeChange == null && mixinTypes != null) {
                newValues.addAll(mixinTypes);
            }
            String nodeKey = NodeTypesChangeAdapter.nodeKey(key);
            if (!oldValues.isEmpty()) {
                this.index().remove(nodeKey);
            }
            assert (!newValues.isEmpty());
            this.index().add(nodeKey, this.property, this.valueFactory.create(newValues.toArray()));
        }

        @Override
        protected void removeNode(String workspaceName, NodeKey key, NodeKey parentKey, Path path, Name primaryType, Set<Name> mixinTypes) {
            this.index().remove(NodeTypesChangeAdapter.nodeKey(key));
        }

        @Override
        protected void reindexNode(String workspaceName, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties, boolean queryable) {
            String nodeKey = NodeTypesChangeAdapter.nodeKey(key);
            this.index().remove(nodeKey);
            if (!queryable) {
                return;
            }
            this.addTypeInformation(key, primaryType, mixinTypes);
        }

        private void addTypeInformation(NodeKey key, Name primaryType, Set<Name> mixinTypes) {
            ArrayList<Name> values = new ArrayList<Name>();
            values.add(primaryType);
            if (!mixinTypes.isEmpty()) {
                values.addAll(mixinTypes);
            }
            this.index().add(NodeTypesChangeAdapter.nodeKey(key), this.property, this.valueFactory.create(values.toArray()));
        }
    }

    protected static class EnumeratedPropertyChangeAdapter
    extends PropertyChangeAdapter<String> {
        public EnumeratedPropertyChangeAdapter(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, Name propertyName, ProvidedIndex<?> index) {
            super(context, matcher, workspaceName, propertyName, context.getValueFactories().getStringFactory(), index);
        }
    }

    protected static final class UniquePropertyChangeAdapter<T>
    extends AbstractPropertyChangeAdapter<T> {
        public UniquePropertyChangeAdapter(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, Name propertyName, ValueFactory<T> valueFactory, ProvidedIndex<?> index) {
            super(context, matcher, workspaceName, propertyName, valueFactory, index);
        }

        @Override
        protected void addValues(NodeKey key, Property property) {
            this.index().add(UniquePropertyChangeAdapter.nodeKey(key), this.propertyName(), this.convert(property.getFirstValue()));
        }

        @Override
        protected final void addValue(NodeKey key, Object value) {
            this.index().add(UniquePropertyChangeAdapter.nodeKey(key), this.propertyName(), this.convert(value));
        }

        @Override
        protected void removeValues(NodeKey key, Property property) {
            this.index().remove(UniquePropertyChangeAdapter.nodeKey(key), this.propertyName(), this.convert(property.getFirstValue()));
        }
    }

    protected static final class MixinTypesChangeAdapter
    extends PropertyChangeAdapter<Name> {
        public MixinTypesChangeAdapter(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, ProvidedIndex<?> index) {
            super(context, matcher, workspaceName, JcrLexicon.MIXIN_TYPES, context.getValueFactories().getNameFactory(), index);
        }
    }

    protected static final class PrimaryTypeChangeAdapter
    extends PropertyChangeAdapter<Name> {
        public PrimaryTypeChangeAdapter(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, ProvidedIndex<?> index) {
            super(context, matcher, workspaceName, JcrLexicon.PRIMARY_TYPE, context.getValueFactories().getNameFactory(), index);
        }
    }

    protected static class PropertyChangeAdapter<T>
    extends AbstractPropertyChangeAdapter<T> {
        public PropertyChangeAdapter(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, Name propertyName, ValueFactory<T> valueFactory, ProvidedIndex<?> index) {
            super(context, matcher, workspaceName, propertyName, valueFactory, index);
        }

        @Override
        protected void addValues(NodeKey key, Property property) {
            if (property.isEmpty()) {
                return;
            }
            String nodeKey = PropertyChangeAdapter.nodeKey(key);
            String propertyName = this.propertyName();
            if (property.isMultiple()) {
                this.index().add(nodeKey, propertyName, property.getValuesAsArray(this.valueFactory));
            } else {
                this.index().add(nodeKey, propertyName, this.convert(property.getFirstValue()));
            }
        }

        @Override
        protected void addValue(NodeKey key, Object value) {
            if (value == null) {
                return;
            }
            this.index().add(PropertyChangeAdapter.nodeKey(key), this.propertyName(), this.convert(value));
        }

        @Override
        protected void removeValues(NodeKey key, Property property) {
            if (property.isEmpty()) {
                return;
            }
            String nodeKey = PropertyChangeAdapter.nodeKey(key);
            String propertyName = this.propertyName();
            if (property.isMultiple()) {
                this.index().remove(nodeKey, propertyName, property.getValuesAsArray(this.valueFactory));
            } else {
                this.index().remove(nodeKey, propertyName, this.convert(property.getFirstValue()));
            }
        }
    }

    protected static abstract class AbstractPropertyChangeAdapter<T>
    extends IndexChangeAdapter {
        protected final Name propertyName;
        protected final ValueFactory<T> valueFactory;

        public AbstractPropertyChangeAdapter(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, Name propertyName, ValueFactory<T> valueFactory, ProvidedIndex<?> index) {
            super(context, workspaceName, matcher, index);
            this.propertyName = propertyName;
            this.valueFactory = valueFactory;
        }

        protected final T convert(Object value) {
            return this.valueFactory.create(value);
        }

        protected abstract void addValues(NodeKey var1, Property var2);

        protected abstract void addValue(NodeKey var1, Object var2);

        protected abstract void removeValues(NodeKey var1, Property var2);

        protected final String propertyName() {
            return this.propertyName.getString(this.context.getNamespaceRegistry());
        }

        @Override
        protected void addNode(String workspaceName, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties) {
        }

        @Override
        protected void reindexNode(String workspaceName, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties, boolean queryable) {
            if (properties != null) {
                assert (this.propertyName != null);
                Property prop = properties.getProperty(this.propertyName);
                if (prop != null) {
                    this.removeValues(key, prop);
                    if (queryable) {
                        this.addValues(key, prop);
                    }
                }
            }
        }

        @Override
        protected void modifyProperties(NodeKey key, Name primaryType, Set<Name> mixinTypes, Map<Name, AbstractPropertyChange> propChanges) {
            AbstractPropertyChange propChange = propChanges.get(this.propertyName);
            if (propChange instanceof PropertyChanged) {
                PropertyChanged change = (PropertyChanged)propChange;
                this.removeValues(key, change.getOldProperty());
                this.addValues(key, change.getNewProperty());
            } else if (propChange instanceof PropertyAdded) {
                PropertyAdded added = (PropertyAdded)propChange;
                this.addValues(key, added.getProperty());
            } else if (propChange instanceof PropertyRemoved) {
                this.removeValues(key, propChange.getProperty());
            }
        }

        @Override
        protected void removeNode(String workspaceName, NodeKey key, NodeKey parentKey, Path path, Name primaryType, Set<Name> mixinTypes) {
            this.index().remove(AbstractPropertyChangeAdapter.nodeKey(key));
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "(\"" + this.index.getName() + "\" : \"" + this.propertyName() + "\")";
        }
    }

    protected static final class NodePathChangeAdapter
    extends PathBasedChangeAdapter<Path> {
        public NodePathChangeAdapter(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, ProvidedIndex<?> index) {
            super(context, matcher, workspaceName, index, JcrLexicon.PATH);
        }

        @Override
        protected Path convert(Path path) {
            return path;
        }

        @Override
        protected Path convertRoot(Path path) {
            return path;
        }
    }

    protected static final class NodeLocalNameChangeAdapter
    extends PathBasedChangeAdapter<String> {
        public NodeLocalNameChangeAdapter(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, ProvidedIndex<?> index) {
            super(context, matcher, workspaceName, index, ModeShapeLexicon.LOCALNAME);
        }

        @Override
        protected String convert(Path path) {
            return path.getLastSegment().getName().getLocalName();
        }

        @Override
        protected String convertRoot(Path path) {
            return "";
        }

        @Override
        protected void reorderNode(String workspaceName, NodeKey key, Name primaryType, Set<Name> mixinTypes, NodeKey parent, Path newPath, Path oldPath, Path reorderedBeforePath, Map<NodeKey, Map<Path, Path>> snsPathChangesByNodeKey) {
        }
    }

    protected static final class NodeNameChangeAdapter
    extends PathBasedChangeAdapter<Name> {
        public NodeNameChangeAdapter(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, ProvidedIndex<?> index) {
            super(context, matcher, workspaceName, index, JcrLexicon.NAME);
        }

        @Override
        protected Name convert(Path path) {
            return path.getLastSegment().getName();
        }

        @Override
        protected Name convertRoot(Path path) {
            return Path.ROOT_NAME;
        }

        @Override
        protected void reorderNode(String workspaceName, NodeKey key, Name primaryType, Set<Name> mixinTypes, NodeKey parent, Path newPath, Path oldPath, Path reorderedBeforePath, Map<NodeKey, Map<Path, Path>> snsPathChangesByNodeKey) {
        }
    }

    protected static final class NodeDepthChangeAdapter
    extends PathBasedChangeAdapter<Long> {
        public NodeDepthChangeAdapter(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, ProvidedIndex<?> index) {
            super(context, matcher, workspaceName, index, ModeShapeLexicon.DEPTH);
        }

        @Override
        protected Long convert(Path path) {
            return path.size();
        }

        @Override
        protected Long convertRoot(Path path) {
            return this.convert(path);
        }
    }

    protected static abstract class PathBasedChangeAdapter<T>
    extends IndexChangeAdapter {
        protected final String propertyName;

        protected PathBasedChangeAdapter(ExecutionContext context, ChangeSetAdapter.NodeTypePredicate matcher, String workspaceName, ProvidedIndex<?> index, Name propertyName) {
            super(context, workspaceName, matcher, index);
            assert (propertyName != null);
            this.propertyName = propertyName.getString(context.getNamespaceRegistry());
        }

        protected T valueOf(Path path) {
            return path.isRoot() ? this.convertRoot(path) : this.convert(path);
        }

        protected abstract T convertRoot(Path var1);

        protected abstract T convert(Path var1);

        @Override
        protected void addNode(String workspaceName, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties) {
            this.index().add(PathBasedChangeAdapter.nodeKey(key), this.propertyName, this.valueOf(path));
        }

        @Override
        protected void reindexNode(String workspaceName, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties, boolean queryable) {
            String nodeKey = PathBasedChangeAdapter.nodeKey(key);
            this.index().remove(nodeKey, this.propertyName, this.valueOf(path));
            if (queryable) {
                this.index().add(PathBasedChangeAdapter.nodeKey(key), this.propertyName, this.valueOf(path));
            }
        }

        @Override
        protected void moveNode(String workspaceName, NodeKey key, Name primaryType, Set<Name> mixinTypes, NodeKey oldParent, NodeKey newParent, Path newPath, Path oldPath) {
            String nodeKey = PathBasedChangeAdapter.nodeKey(key);
            this.index().remove(nodeKey, this.propertyName, this.valueOf(oldPath));
            this.index().add(nodeKey, this.propertyName, this.valueOf(newPath));
        }

        @Override
        protected void removeNode(String workspaceName, NodeKey key, NodeKey parentKey, Path path, Name primaryType, Set<Name> mixinTypes) {
            this.index().remove(PathBasedChangeAdapter.nodeKey(key));
        }

        @Override
        protected void renameNode(String workspaceName, NodeKey key, Path newPath, Path.Segment oldSegment, Name primaryType, Set<Name> mixinTypes) {
            PathFactory pathFactory = this.context.getValueFactories().getPathFactory();
            Path oldPath = pathFactory.create(newPath.subpath(0, newPath.size()), oldSegment);
            String nodeKey = PathBasedChangeAdapter.nodeKey(key);
            this.index().remove(nodeKey, this.propertyName, this.valueOf(oldPath));
            this.index().add(nodeKey, this.propertyName, this.valueOf(newPath));
        }

        @Override
        protected void reorderNode(String workspaceName, NodeKey key, Name primaryType, Set<Name> mixinTypes, NodeKey parent, Path newPath, Path oldPath, Path reorderedBeforePath, Map<NodeKey, Map<Path, Path>> snsPathChangesByNodeKey) {
            if (newPath.getLastSegment().hasIndex() || oldPath.getLastSegment().hasIndex()) {
                String nodeKey = PathBasedChangeAdapter.nodeKey(key);
                this.index().remove(nodeKey, this.propertyName, this.valueOf(oldPath));
                this.index().add(nodeKey, this.propertyName, this.valueOf(newPath));
                snsPathChangesByNodeKey.forEach((snsKey, pathMap) -> {
                    String snsKeyString = PathBasedChangeAdapter.nodeKey(snsKey);
                    Map.Entry pathChangeEntry = pathMap.entrySet().iterator().next();
                    this.index().remove(snsKeyString, this.propertyName, this.valueOf((Path)pathChangeEntry.getKey()));
                    this.index().add(snsKeyString, this.propertyName, this.valueOf((Path)pathChangeEntry.getValue()));
                });
            }
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "(\"" + this.index.getName() + "\" : \"" + this.propertyName + "\")";
        }
    }

    protected static class MultiColumnChangeAdapter
    extends IndexChangeAdapter {
        private List<PathBasedChangeAdapter<?>> pathAdapters = new ArrayList();
        private List<AbstractPropertyChangeAdapter<?>> propertyAdapters = new ArrayList();

        protected MultiColumnChangeAdapter(ExecutionContext context, String workspaceName, ChangeSetAdapter.NodeTypePredicate predicate, ProvidedIndex<?> index, Iterable<IndexChangeAdapter> adapters) {
            super(context, workspaceName, predicate, index);
            for (IndexChangeAdapter adapter : adapters) {
                if (adapter instanceof PathBasedChangeAdapter) {
                    this.pathAdapters.add((PathBasedChangeAdapter)adapter);
                    continue;
                }
                if (!(adapter instanceof AbstractPropertyChangeAdapter)) continue;
                this.propertyAdapters.add((AbstractPropertyChangeAdapter)adapter);
            }
            assert (!this.pathAdapters.isEmpty() || !this.propertyAdapters.isEmpty());
        }

        @Override
        protected void modifyProperties(NodeKey key, Name primaryType, Set<Name> mixinTypes, Map<Name, AbstractPropertyChange> propChanges) {
            if (this.propertyAdapters.isEmpty()) {
                return;
            }
            for (AbstractPropertyChangeAdapter<?> propertyChangeAdapter : this.propertyAdapters) {
                propertyChangeAdapter.modifyProperties(key, primaryType, mixinTypes, propChanges);
            }
        }

        @Override
        protected void addNode(String workspaceName, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties) {
            if (this.pathAdapters.isEmpty()) {
                return;
            }
            for (PathBasedChangeAdapter<?> pathAdapter : this.pathAdapters) {
                pathAdapter.addNode(workspaceName, key, path, primaryType, mixinTypes, properties);
            }
        }

        @Override
        protected void reindexNode(String workspaceName, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties, boolean queryable) {
            String nodeKey = MultiColumnChangeAdapter.nodeKey(key);
            this.index().remove(nodeKey);
            if (!this.pathAdapters.isEmpty()) {
                for (PathBasedChangeAdapter<?> pathBasedChangeAdapter : this.pathAdapters) {
                    this.index().add(nodeKey, pathBasedChangeAdapter.propertyName, pathBasedChangeAdapter.valueOf(path));
                }
            }
            if (!this.propertyAdapters.isEmpty()) {
                for (AbstractPropertyChangeAdapter abstractPropertyChangeAdapter : this.propertyAdapters) {
                    Property property = properties.getProperty(abstractPropertyChangeAdapter.propertyName);
                    if (property == null) continue;
                    abstractPropertyChangeAdapter.addValues(key, property);
                }
            }
        }

        @Override
        protected void removeNode(String workspaceName, NodeKey key, NodeKey parentKey, Path path, Name primaryType, Set<Name> mixinTypes) {
            this.index().remove(MultiColumnChangeAdapter.nodeKey(key));
        }

        @Override
        protected void moveNode(String workspaceName, NodeKey key, Name primaryType, Set<Name> mixinTypes, NodeKey oldParent, NodeKey newParent, Path newPath, Path oldPath) {
            if (this.pathAdapters.isEmpty()) {
                return;
            }
            for (PathBasedChangeAdapter<?> pathAdapter : this.pathAdapters) {
                pathAdapter.moveNode(workspaceName, key, primaryType, mixinTypes, oldParent, newParent, newPath, oldPath);
            }
        }

        @Override
        protected void renameNode(String workspaceName, NodeKey key, Path newPath, Path.Segment oldSegment, Name primaryType, Set<Name> mixinTypes) {
            if (this.pathAdapters.isEmpty()) {
                return;
            }
            for (PathBasedChangeAdapter<?> pathAdapter : this.pathAdapters) {
                pathAdapter.renameNode(workspaceName, key, newPath, oldSegment, primaryType, mixinTypes);
            }
        }

        @Override
        protected void reorderNode(String workspaceName, NodeKey key, Name primaryType, Set<Name> mixinTypes, NodeKey parent, Path newPath, Path oldPath, Path reorderedBeforePath, Map<NodeKey, Map<Path, Path>> snsPathChangesByNodeKey) {
            if (this.pathAdapters.isEmpty()) {
                return;
            }
            for (PathBasedChangeAdapter<?> pathAdapter : this.pathAdapters) {
                pathAdapter.reorderNode(workspaceName, key, primaryType, mixinTypes, parent, newPath, oldPath, reorderedBeforePath, snsPathChangesByNodeKey);
            }
        }
    }
}

