/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.util;

import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import org.modeshape.jdbc.util.I18n;
import org.modeshape.jdbc.util.StringUtil;
import org.slf4j.LoggerFactory;

public final class Logger {
    private static final AtomicReference<Locale> LOGGING_LOCALE = new AtomicReference<Object>(null);
    private final org.slf4j.Logger delegate;

    public static Locale getLoggingLocale() {
        return LOGGING_LOCALE.get();
    }

    public static Locale setLoggingLocale(Locale locale) {
        return LOGGING_LOCALE.getAndSet(locale != null ? locale : Locale.getDefault());
    }

    public static Logger getLogger(Class<?> clazz) {
        return new Logger(LoggerFactory.getLogger(clazz));
    }

    public static Logger getLogger(String name) {
        return new Logger(LoggerFactory.getLogger((String)name));
    }

    private Logger(org.slf4j.Logger delegate) {
        this.delegate = delegate;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public void log(Level level, I18n message, Object ... params) {
        if (message == null) {
            return;
        }
        switch (level) {
            case DEBUG: {
                this.debug(message.text(LOGGING_LOCALE.get(), params), new Object[0]);
                break;
            }
            case ERROR: {
                this.error(message, params);
                break;
            }
            case INFO: {
                this.info(message, params);
                break;
            }
            case TRACE: {
                this.trace(message.text(LOGGING_LOCALE.get(), params), new Object[0]);
                break;
            }
            case WARNING: {
                this.warn(message, params);
                break;
            }
        }
    }

    public void log(Level level, Throwable t, I18n message, Object ... params) {
        if (message == null) {
            return;
        }
        switch (level) {
            case DEBUG: {
                this.debug(t, message.text(LOGGING_LOCALE.get(), params), new Object[0]);
                break;
            }
            case ERROR: {
                this.error(t, message, params);
                break;
            }
            case INFO: {
                this.info(t, message, params);
                break;
            }
            case TRACE: {
                this.trace(t, message.text(LOGGING_LOCALE.get(), params), new Object[0]);
                break;
            }
            case WARNING: {
                this.warn(t, message, params);
                break;
            }
        }
    }

    public void debug(String message, Object ... params) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (message == null) {
            return;
        }
        this.delegate.debug(StringUtil.createString(message, params));
    }

    public void debug(Throwable t, String message, Object ... params) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (t == null) {
            this.debug(message, params);
            return;
        }
        if (message == null) {
            this.delegate.debug(null, t);
            return;
        }
        this.delegate.debug(StringUtil.createString(message, params), t);
    }

    public void error(I18n message, Object ... params) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (message == null) {
            return;
        }
        this.delegate.error(message.text(LOGGING_LOCALE.get(), params));
    }

    public void error(Throwable t, I18n message, Object ... params) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (t == null) {
            this.error(message, params);
            return;
        }
        if (message == null) {
            this.delegate.error(null, t);
            return;
        }
        this.delegate.error(message.text(LOGGING_LOCALE.get(), params), t);
    }

    public void info(I18n message, Object ... params) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (message == null) {
            return;
        }
        this.delegate.info(message.text(LOGGING_LOCALE.get(), params));
    }

    public void info(Throwable t, I18n message, Object ... params) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (t == null) {
            this.info(message, params);
            return;
        }
        if (message == null) {
            this.delegate.info(null, t);
            return;
        }
        this.delegate.info(message.text(LOGGING_LOCALE.get(), params), t);
    }

    public void trace(String message, Object ... params) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (message == null) {
            return;
        }
        this.delegate.trace(StringUtil.createString(message, params));
    }

    public void trace(Throwable t, String message, Object ... params) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (t == null) {
            this.trace(message, params);
            return;
        }
        if (message == null) {
            this.delegate.trace(null, t);
            return;
        }
        this.delegate.trace(StringUtil.createString(message, params), t);
    }

    public void warn(I18n message, Object ... params) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (message == null) {
            return;
        }
        this.delegate.warn(message.text(LOGGING_LOCALE.get(), params));
    }

    public void warn(Throwable t, I18n message, Object ... params) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (t == null) {
            this.warn(message, params);
            return;
        }
        if (message == null) {
            this.delegate.warn(null, t);
            return;
        }
        this.delegate.warn(message.text(LOGGING_LOCALE.get(), params), t);
    }

    protected boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    protected boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    protected boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public Level getLevel() {
        if (this.isTraceEnabled()) {
            return Level.TRACE;
        }
        if (this.isDebugEnabled()) {
            return Level.DEBUG;
        }
        if (this.isInfoEnabled()) {
            return Level.INFO;
        }
        if (this.isWarnEnabled()) {
            return Level.WARNING;
        }
        if (this.isErrorEnabled()) {
            return Level.ERROR;
        }
        return Level.OFF;
    }

    public static enum Level {
        OFF,
        ERROR,
        WARNING,
        INFO,
        DEBUG,
        TRACE;

    }
}

