/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryResult;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.Path;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jdbc.DriverInfo;
import org.modeshape.jdbc.JcrConnection;
import org.modeshape.jdbc.JcrMetaData;
import org.modeshape.jdbc.JdbcLocalI18n;
import org.modeshape.jdbc.TestUtil;
import org.modeshape.jdbc.delegate.ConnectionInfo;
import org.modeshape.jdbc.delegate.RepositoryDelegate;
import org.modeshape.jdbc.util.ResultsComparator;
import org.modeshape.repository.ModeShapeConfiguration;

public class JcrMetaDataTest
extends ResultsComparator {
    private static JcrEngine engine;
    private static Repository repository;
    private static Session session;
    private static boolean print;
    private JcrMetaData metadata;
    @Mock
    private JcrConnection connection;
    @Mock
    private RepositoryDelegate delegate;
    @Mock
    private ConnectionInfo connInfo;
    @Mock
    private QueryResult queryResult;
    private DriverInfo driverInfo;
    private static final int NO_LIMIT = 0;

    @BeforeClass
    public static void beforeAll() throws Exception {
        JcrConfiguration configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)configuration.repositorySource("source").usingClass(InMemoryRepositorySource.class)).setDescription("The content store");
        configuration.repository("repo").setSource("source").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(JcrMetaDataTest.resourceUrl("cars.cnd")).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "readonly,readwrite,admin").setOption(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "modeshape-jcr");
        engine = configuration.build();
        engine.start();
        repository = engine.getRepository("repo");
        session = repository.login();
        JcrMetaDataTest.assertImport("cars-system-view-with-uuids.xml", "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void afterAll() {
        try {
            if (session != null) {
                session.logout();
            }
        }
        finally {
            session = null;
            try {
                engine.shutdown();
            }
            finally {
                engine = null;
            }
        }
    }

    @Before
    public void beforeEach() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.driverInfo = new DriverInfo(JdbcLocalI18n.driverName.text(new Object[0]), JdbcLocalI18n.driverVendor.text(new Object[0]), JdbcLocalI18n.driverVendorUrl.text(new Object[0]), JdbcLocalI18n.driverVersion.text(new Object[0]));
        print = false;
        Mockito.when((Object)this.connection.getRepositoryDelegate()).thenReturn((Object)this.delegate);
        HashSet<String> names = new HashSet<String>();
        names.add("repo");
        Mockito.when((Object)this.connection.getCatalog()).thenReturn((Object)"repo");
        Mockito.when((Object)this.connection.driverInfo()).thenReturn((Object)this.driverInfo);
        this.metadata = new JcrMetaData(this.connection);
        Mockito.when((Object)this.delegate.getConnectionInfo()).thenReturn((Object)this.connInfo);
        Mockito.when((Object)this.delegate.execute(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.queryResult);
        Mockito.when((Object)this.connInfo.getRepositoryName()).thenReturn((Object)"repoName");
        Mockito.when((Object)this.queryResult.getColumnNames()).thenReturn((Object)TestUtil.COLUMN_NAMES);
        this.compareColumns = false;
    }

    @Test
    public void shouldHaveSession() {
        Assert.assertThat((Object)session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldHaveMetaData() {
        Assert.assertThat((Object)this.metadata, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void testMethodsWithoutParams() throws Exception {
        Class<?> dbmdClass = this.metadata.getClass();
        Method[] methods = dbmdClass.getDeclaredMethods();
        Map<Object, Object> expectedMap = new HashMap();
        ArrayList<String> failedMessages = new ArrayList<String>();
        expectedMap = this.getExpected();
        for (int i = 0; i < methods.length; ++i) {
            if (!expectedMap.containsKey(methods[i].getName())) continue;
            Object actualValue = null;
            Object expectedValue = null;
            Object expectedReturn = expectedMap.get(methods[i].getName());
            Object[] params = null;
            if (expectedReturn instanceof List) {
                List returned = (List)expectedReturn;
                params = (Object[])returned.get(1);
                expectedValue = returned.get(0);
                actualValue = methods[i].invoke((Object)this.metadata, params);
            } else {
                expectedValue = expectedReturn;
                actualValue = methods[i].invoke((Object)this.metadata, new Object[0]);
            }
            if (expectedValue == null || actualValue == null) {
                if (expectedValue == null && actualValue != null) {
                    failedMessages.add(" Expected doesn't match with actual for method - " + methods[i].getName() + " expected: <" + expectedValue + "> but was: < " + actualValue + "> ");
                    continue;
                }
                if (expectedValue == null || actualValue != null) continue;
                failedMessages.add(" Expected doesn't match with actual for method - " + methods[i].getName() + " expected: <" + expectedValue + "> but was: < " + actualValue + "> ");
                continue;
            }
            if (expectedValue.equals(actualValue)) continue;
            failedMessages.add(" Expected doesn't match with actual for method - " + methods[i].getName() + " expected: <" + expectedValue + "> but was: < " + actualValue + "> ");
        }
        Assert.assertThat((Object)((Object)failedMessages).toString().trim(), (Matcher)Is.is((Object)"[]"));
    }

    @Test
    public void testMethodsWithExceptions() throws Exception {
        Class<?> metadataClass = this.metadata.getClass();
        Method[] methods = metadataClass.getDeclaredMethods();
        HashMap expectedMap = new HashMap();
        for (int i = 0; i < methods.length; ++i) {
            if (!expectedMap.containsKey(methods[i].getName())) continue;
            methods[i].invoke((Object)this.metadata, new Object[0]);
        }
    }

    protected static URL resourceUrl(String name) {
        return JcrMetaDataTest.class.getClassLoader().getResource(name);
    }

    protected static InputStream resourceStream(String name) {
        return JcrMetaDataTest.class.getClassLoader().getResourceAsStream(name);
    }

    protected static Node assertImport(String resourceName, String pathToParent) throws RepositoryException, IOException {
        InputStream istream = JcrMetaDataTest.resourceStream(resourceName);
        return JcrMetaDataTest.assertImport(istream, pathToParent);
    }

    protected static Node assertImport(File resource, String pathToParent) throws RepositoryException, IOException {
        FileInputStream istream = new FileInputStream(resource);
        return JcrMetaDataTest.assertImport(istream, pathToParent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Node assertImport(InputStream istream, String pathToParent) throws RepositoryException, IOException {
        Path parentPath = JcrMetaDataTest.path(pathToParent);
        Assert.assertThat((Object)parentPath.isAbsolute(), (Matcher)Is.is((Object)true));
        Node node = session.getRootNode();
        boolean found = true;
        for (Path.Segment segment : parentPath) {
            String name = JcrMetaDataTest.asString(segment);
            if (found) {
                try {
                    node = node.getNode(name);
                    found = true;
                }
                catch (PathNotFoundException e) {
                    found = false;
                }
            }
            if (found) continue;
            node = node.addNode(name, "nt:unstructured");
        }
        if (!found) {
            session.save();
        }
        JcrMetaDataTest.assertNode(pathToParent);
        Assert.assertThat((Object)istream, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        try {
            session.getWorkspace().importXML(pathToParent, istream, 0);
        }
        finally {
            istream.close();
        }
        session.save();
        return node;
    }

    protected static Path path(String path) {
        return (Path)engine.getExecutionContext().getValueFactories().getPathFactory().create(path);
    }

    protected static String relativePath(String path) {
        return !path.startsWith("/") ? path : path.substring(1);
    }

    protected static String asString(Object value) {
        return (String)engine.getExecutionContext().getValueFactories().getStringFactory().create(value);
    }

    protected static void assertNode(String path) throws RepositoryException {
        String relativePath = JcrMetaDataTest.relativePath(path);
        Node root = session.getRootNode();
        if (relativePath.trim().length() == 0) {
            Assert.assertThat((Object)root, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            return;
        }
        if (print && !root.hasNode(relativePath)) {
            Node parent = root;
            int depth = 0;
            for (Path.Segment segment : JcrMetaDataTest.path(path)) {
                if (!parent.hasNode(JcrMetaDataTest.asString(segment))) {
                    System.out.println("Unable to find '" + path + "'; lowest node is '" + parent.getPath() + "'");
                    break;
                }
                parent = parent.getNode(JcrMetaDataTest.asString(segment));
                ++depth;
            }
        }
        Assert.assertThat((Object)root.hasNode(relativePath), (Matcher)Is.is((Object)true));
    }

    private Map<String, Object> getExpected() {
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("allProceduresAreCallable", Boolean.FALSE);
        expected.put("allTablesAreSelectable", Boolean.FALSE);
        expected.put("doesMaxRowSizeIncludeBlobs", Boolean.FALSE);
        expected.put("isCatalogAtStart", Boolean.TRUE);
        expected.put("isReadOnly", Boolean.TRUE);
        expected.put("locatorsUpdateCopy", Boolean.FALSE);
        expected.put("nullPlusNonNullIsNull", Boolean.FALSE);
        expected.put("nullsAreSortedAtEnd", Boolean.FALSE);
        expected.put("nullsAreSortedAtStart", Boolean.FALSE);
        expected.put("nullsAreSortedHigh", Boolean.FALSE);
        expected.put("nullsAreSortedLow", Boolean.TRUE);
        expected.put("storesLowerCaseIdentifiers", Boolean.FALSE);
        expected.put("storesLowerCaseQuotedIdentifiers", Boolean.FALSE);
        expected.put("storesMixedCaseIdentifiers", Boolean.FALSE);
        expected.put("storesMixedCaseQuotedIdentifiers", Boolean.FALSE);
        expected.put("storesUpperCaseIdentifiers", Boolean.FALSE);
        expected.put("storesUpperCaseQuotedIdentifiers", Boolean.FALSE);
        expected.put("supportsAlterTableWithAddColumn", Boolean.FALSE);
        expected.put("supportsAlterTableWithDropColumn", Boolean.FALSE);
        expected.put("supportsANSI92EntryLevelSQL", Boolean.FALSE);
        expected.put("supportsANSI92FullSQL", Boolean.FALSE);
        expected.put("supportsANSI92IntermediateSQL", Boolean.FALSE);
        expected.put("supportsBatchUpdates", Boolean.FALSE);
        expected.put("supportsCatalogsInDataManipulation", Boolean.FALSE);
        expected.put("supportsCatalogsInIndexDefinitions", Boolean.FALSE);
        expected.put("supportsCatalogsInPrivilegeDefinitions", Boolean.FALSE);
        expected.put("supportsCatalogsInProcedureCalls", Boolean.FALSE);
        expected.put("supportsCatalogsInTableDefinitions", Boolean.FALSE);
        expected.put("supportsColumnAliasing", Boolean.FALSE);
        expected.put("supportsCorrelatedSubqueries", Boolean.FALSE);
        expected.put("supportsCoreSQLGrammar", Boolean.FALSE);
        expected.put("supportsDataDefinitionAndDataManipulationTransactions", Boolean.FALSE);
        expected.put("supportsDataManipulationTransactionsOnly", Boolean.FALSE);
        expected.put("supportsDifferentTableCorrelationNames", Boolean.FALSE);
        expected.put("supportsExpressionsInOrderBy", Boolean.FALSE);
        expected.put("supportsExtendedSQLGrammar", Boolean.FALSE);
        expected.put("supportsFullOuterJoins", Boolean.FALSE);
        expected.put("supportsGetGeneratedKeys", Boolean.FALSE);
        expected.put("supportsGroupBy", Boolean.FALSE);
        expected.put("supportsGroupByBeyondSelect", Boolean.FALSE);
        expected.put("supportsGroupByUnrelated", Boolean.FALSE);
        expected.put("supportsIntegrityEnhancementFacility", Boolean.FALSE);
        expected.put("supportsLikeEscapeClause", Boolean.FALSE);
        expected.put("supportsLimitedOuterJoins", Boolean.FALSE);
        expected.put("supportsMinimumSQLGrammar", Boolean.FALSE);
        expected.put("supportsMixedCaseIdentifiers", Boolean.FALSE);
        expected.put("supportsMixedCaseQuotedIdentifiers", Boolean.FALSE);
        expected.put("supportsOpenCursorsAcrossCommit", Boolean.FALSE);
        expected.put("supportsMultipleResultSets", Boolean.FALSE);
        expected.put("supportsMultipleOpenResults", Boolean.FALSE);
        expected.put("supportsMultipleTransactions", Boolean.FALSE);
        expected.put("supportsNamedParameters", Boolean.FALSE);
        expected.put("supportsNonNullableColumns", Boolean.FALSE);
        expected.put("supportsOpenCursorsAcrossRollback", Boolean.FALSE);
        expected.put("supportsOpenStatementsAcrossCommit", Boolean.FALSE);
        expected.put("supportsOpenStatementsAcrossRollback", Boolean.FALSE);
        expected.put("supportsOrderByUnrelated", Boolean.FALSE);
        expected.put("supportsOuterJoins", Boolean.TRUE);
        expected.put("supportsPositionedDelete", Boolean.FALSE);
        expected.put("supportsPositionedUpdate", Boolean.FALSE);
        expected.put("supportsSavepoints", Boolean.FALSE);
        expected.put("supportsSchemasInDataManipulation", Boolean.FALSE);
        expected.put("supportsSchemasInIndexDefinitions", Boolean.FALSE);
        expected.put("supportsSchemasInPrivilegeDefinitions", Boolean.FALSE);
        expected.put("supportsSchemasInProcedureCalls", Boolean.FALSE);
        expected.put("supportsSchemasInTableDefinitions", Boolean.FALSE);
        expected.put("supportsSelectForUpdate", Boolean.FALSE);
        expected.put("supportsStatementPooling", Boolean.FALSE);
        expected.put("supportsStoredProcedures", Boolean.FALSE);
        expected.put("supportsSubqueriesInComparisons", Boolean.FALSE);
        expected.put("supportsSubqueriesInExists", Boolean.FALSE);
        expected.put("supportsSubqueriesInIns", Boolean.FALSE);
        expected.put("supportsSubqueriesInQuantifieds", Boolean.FALSE);
        expected.put("supportsTableCorrelationNames", Boolean.TRUE);
        expected.put("supportsTransactions", Boolean.FALSE);
        expected.put("supportsUnion", Boolean.FALSE);
        expected.put("supportsUnionAll", Boolean.FALSE);
        expected.put("usesLocalFilePerTable", Boolean.FALSE);
        expected.put("usesLocalFiles", Boolean.FALSE);
        expected.put("usesLocalFilePerTable", Boolean.FALSE);
        expected.put("getJDBCMajorVersion", new Integer(2));
        expected.put("getJDBCMinorVersion", new Integer(0));
        expected.put("getDefaultTransactionIsolation", 0);
        expected.put("getDriverMajorVersion", TestUtil.majorVersion());
        expected.put("getDriverMinorVersion", TestUtil.minorVersion());
        expected.put("getMaxBinaryLiteralLength", new Integer(0));
        expected.put("getMaxCatalogNameLength", new Integer(0));
        expected.put("getMaxCharLiteralLength", new Integer(0));
        expected.put("getMaxColumnNameLength", new Integer(0));
        expected.put("getMaxColumnsInGroupBy", new Integer(0));
        expected.put("getMaxColumnsInIndex", new Integer(0));
        expected.put("getMaxColumnsInOrderBy", new Integer(0));
        expected.put("getMaxColumnsInSelect", new Integer(0));
        expected.put("getMaxColumnsInTable", new Integer(0));
        expected.put("getMaxConnections", new Integer(0));
        expected.put("getMaxCursorNameLength", new Integer(0));
        expected.put("getMaxIndexLength", new Integer(0));
        expected.put("getMaxProcedureNameLength", new Integer(0));
        expected.put("getMaxRowSize", new Integer(0));
        expected.put("getMaxStatementLength", new Integer(0));
        expected.put("getMaxStatements", new Integer(0));
        expected.put("getMaxTableNameLength", new Integer(0));
        expected.put("getMaxTablesInSelect", new Integer(0));
        expected.put("getMaxUserNameLength", new Integer(0));
        expected.put("getSQLStateType", new Integer(0));
        expected.put("getCatalogSeparator", null);
        expected.put("getCatalogTerm", "Repository");
        expected.put("getDriverName", JdbcLocalI18n.driverName.text(new Object[0]));
        expected.put("getDriverVersion", JdbcLocalI18n.driverVersion.text(new Object[0]));
        expected.put("getIdentifierQuoteString", "\"");
        return expected;
    }

    static {
        print = false;
    }
}

