/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.jcr.Node;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.MultiUseAbstractTest;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jdbc.ConnectionResultsComparator;

public abstract class AbstractJdbcDriverTest
extends MultiUseAbstractTest {
    protected Driver driver;
    protected Connection connection;
    protected DatabaseMetaData dbmd;
    protected ConnectionResultsComparator resultsComparator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void beforeAll() throws Exception {
        RepositoryConfiguration config = new RepositoryConfiguration("cars");
        AbstractJdbcDriverTest.startRepository((RepositoryConfiguration)config);
        AbstractJdbcDriverTest.registerNodeTypes((String)"cars.cnd");
        AbstractJdbcDriverTest.importContent((String)"/", (String)"cars-system-view.xml", (int)3);
        JcrSession session = repository.login();
        try {
            Node other = session.getRootNode().addNode("Other", "nt:unstructured");
            other.addNode("NodeA", "nt:unstructured").setProperty("something", "value3 quick brown fox");
            other.addNode("NodeA", "nt:unstructured").setProperty("something", "value2 quick brown cat");
            other.addNode("NodeA", "nt:unstructured").setProperty("something", "value1 quick black dog");
            session.getRootNode().addNode("NodeB", "nt:unstructured").setProperty("myUrl", "http://www.acme.com/foo/bar");
            session.save();
        }
        finally {
            session.logout();
        }
    }

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.resultsComparator = new ConnectionResultsComparator();
        Properties properties = this.createConnectionProperties(repository);
        String url = this.createConnectionUrl(repository);
        this.driver = this.createDriver(repository);
        this.connect(url, properties);
        this.dbmd = this.connection.getMetaData();
        this.resultsComparator.compareColumns = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        try {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                finally {
                    this.connection = null;
                    this.dbmd = null;
                    this.driver = null;
                }
            }
            super.afterEach();
        }
        finally {
            DriverManager.deregisterDriver(this.driver);
        }
    }

    protected Properties createConnectionProperties(JcrRepository repository) throws Exception {
        return new Properties();
    }

    protected abstract String createConnectionUrl(JcrRepository var1) throws Exception;

    protected abstract Driver createDriver(JcrRepository var1) throws Exception;

    protected Connection connect(String url) throws Exception {
        return this.connect(url, null);
    }

    protected Connection connect(String url, Properties properties) throws Exception {
        if (properties == null) {
            properties = new Properties();
        }
        Connection newConnection = this.driver.connect(url, properties);
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = newConnection;
        return this.connection;
    }

    @Test
    public void shouldStartUp() {
        Assert.assertThat((Object)session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.connection, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    public void executeQuery(String sql, String[] expected, int expectedRowCount) throws SQLException {
        this.executeQuery(sql, expected, expectedRowCount, "JCR-SQL2");
    }

    public void executeQuery(String sql, String[] expected, int expectedRowCount, String language) throws SQLException {
        ConnectionResultsComparator.executeTest(this.connection, sql, expected, expectedRowCount, language);
    }

    public void assertResultsSetEquals(ResultSet resultSet, String expected) {
        this.resultsComparator.assertResultsSetEquals(resultSet, expected);
    }

    public void assertResultsSetEquals(ResultSet resultSet, String[] expected) {
        this.resultsComparator.assertResultsSetEquals(resultSet, expected);
    }

    public void assertRowCount(int expected) {
        this.resultsComparator.assertRowCount(expected);
    }
}

