/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jdbc.delegate.LocalRepositoryDelegate;
import org.modeshape.jdbc.delegate.RepositoryDelegate;
import org.modeshape.jdbc.delegate.RepositoryDelegateFactoryTest;

public class LocalRepositoryDelegateTest
extends RepositoryDelegateFactoryTest {
    private static final String REPOSITORY_NAME = "repositoryName";
    private static final String USER_NAME = "jsmith";
    private static final String PASSWORD = "secret";
    private static final String WORKSPACE = "MyWorkspace";
    private static final String JNDINAME = "jcr/local";
    private static final String VALID_JNDI_URL = "jdbc:jcr:jndi:jcr/local";
    private static final String INSUFFICIENT_JNDI_URL = "jdbc:jcr:jndi:/";
    private static final String VALID_JNDI_URL_WITH_PARMS = "jdbc:jcr:jndi:jcr/local?workspace=MyWorkspace&user=jsmith&password=secret&repositoryName=repositoryName";
    private RepositoryDelegate delegate;

    @Test
    public void testNoContextOverride() throws SQLException {
        this.delegate = this.factory().createRepositoryDelegate(VALID_JNDI_URL_WITH_PARMS, new Properties(), null);
    }

    @Test
    public void shouldCreateLocalRepositoryDelegate() throws SQLException {
        RepositoryDelegate delegate = this.factory().createRepositoryDelegate(VALID_JNDI_URL_WITH_PARMS, new Properties(), null);
        Assert.assertThat((Object)delegate, (Matcher)IsInstanceOf.instanceOf(LocalRepositoryDelegate.class));
    }

    @Test
    public void shouldAcceptValidURL() {
        Assert.assertThat((Object)this.factory().acceptUrl(VALID_JNDI_URL_WITH_PARMS), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.factory().acceptUrl(VALID_JNDI_URL), (Matcher)Is.is((Object)true));
    }

    @Test
    public void connectionInfoShouldBeValid() throws SQLException {
        this.delegate = this.factory().createRepositoryDelegate(VALID_JNDI_URL_WITH_PARMS, new Properties(), null);
        Assert.assertNotNull((Object)this.delegate.getConnectionInfo());
        Assert.assertThat((Object)this.delegate.getConnectionInfo().getUsername(), (Matcher)Is.is((Object)USER_NAME));
        Assert.assertThat((Object)this.delegate.getConnectionInfo().getPassword(), (Matcher)Is.is((Object)new String(PASSWORD).toCharArray()));
        Assert.assertThat((Object)this.delegate.getConnectionInfo().getWorkspaceName(), (Matcher)Is.is((Object)WORKSPACE));
        Assert.assertThat((Object)this.delegate.getConnectionInfo().getRepositoryName(), (Matcher)Is.is((Object)REPOSITORY_NAME));
        Assert.assertThat((Object)this.delegate.getConnectionInfo().getEffectiveUrl(), (Matcher)Is.is((Object)"jdbc:jcr:jndi:jcr/local?user=jsmith&workspace=MyWorkspace&password=******&repositoryName=repositoryName"));
        DriverPropertyInfo[] infos = this.delegate.getConnectionInfo().getPropertyInfos();
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)((LocalRepositoryDelegate.JNDIConnectionInfo)this.delegate.getConnectionInfo()).getRepositoryPath(), (Matcher)Is.is((Object)JNDINAME));
    }

    @Test
    public void connectionPropertyInfoShouldIndicateMissingData() throws SQLException {
        this.delegate = this.factory().createRepositoryDelegate(INSUFFICIENT_JNDI_URL, new Properties(), null);
        Assert.assertNotNull((Object)this.delegate.getConnectionInfo());
        DriverPropertyInfo[] infos = this.delegate.getConnectionInfo().getPropertyInfos();
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)4));
    }

    @Test
    public void shouldReturnEmptyPropertyInfosWhenSuppliedValidUrlAndAllPropertiesWithRepositoriesInJndi() throws SQLException {
        Properties validProperties = new Properties();
        validProperties.put("workspace", WORKSPACE);
        validProperties.put("user", USER_NAME);
        validProperties.put("password", PASSWORD);
        validProperties.put(REPOSITORY_NAME, REPOSITORY_NAME);
        this.delegate = this.factory().createRepositoryDelegate(VALID_JNDI_URL, validProperties, null);
        DriverPropertyInfo[] infos = this.delegate.getConnectionInfo().getPropertyInfos();
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)0));
    }
}

