/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import javax.jcr.Repository;
import javax.jcr.Session;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jdbc.DriverInfo;
import org.modeshape.jdbc.JcrConnection;
import org.modeshape.jdbc.JcrStatement;
import org.modeshape.jdbc.delegate.ConnectionInfo;
import org.modeshape.jdbc.delegate.RepositoryDelegate;

public class JcrConnectionTest {
    private static final DriverInfo DRIVER_INFO = new DriverInfo("DriverName", "DriverVendor", "http://www.driverUrl.com", "1.0");
    private static final String REPOSITORY_NAME = "repositoryName";
    private Connection conn;
    @Mock
    private ConnectionInfo connInfo;
    @Mock
    private Repository repository;
    @Mock
    private Session session;
    @Mock
    private RepositoryDelegate jcrDelegate;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.conn = new JcrConnection(this.jcrDelegate, DRIVER_INFO);
        Mockito.when((Object)this.connInfo.getWorkspaceName()).thenReturn((Object)"workspaceName");
        Mockito.when((Object)this.connInfo.getRepositoryName()).thenReturn((Object)REPOSITORY_NAME);
        Mockito.when((Object)this.jcrDelegate.isValid(Matchers.anyInt())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.jcrDelegate.getConnectionInfo()).thenReturn((Object)this.connInfo);
        Mockito.when((Object)this.repository.login(Matchers.anyString())).thenReturn((Object)this.session);
        Mockito.when((Object)this.repository.getDescriptor(Matchers.anyString())).thenReturn((Object)"modeshape");
        Mockito.when((Object)this.session.getRepository()).thenReturn((Object)this.repository);
    }

    @After
    public void afterEach() throws Exception {
        try {
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void shouldCallClearWarnings() throws SQLException {
        this.conn.clearWarnings();
    }

    @Test
    public void shouldCallClose() throws SQLException {
        this.conn.close();
    }

    @Test
    public void shouldCallCommit() throws SQLException {
        this.conn.commit();
    }

    @Test
    public void shouldCallGetCatalog() throws SQLException {
        Assert.assertThat((Object)this.conn.getCatalog(), (Matcher)Is.is((Object)REPOSITORY_NAME));
    }

    @Test
    public void shouldCallCreateStatement() throws SQLException {
        Statement stmt = this.conn.createStatement();
        Assert.assertThat((Object)stmt, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)stmt, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(JcrStatement.class)));
    }

    @Test
    public void shouldCallGetAutoCommit() throws SQLException {
        Assert.assertThat((Object)this.conn.getAutoCommit(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCallGetClientInfo() throws SQLException {
        Assert.assertThat((Object)this.conn.getClientInfo(), (Matcher)Is.is((Object)new Properties()));
    }

    @Test
    public void shouldCallGetClientInfoByName() throws SQLException {
        this.conn.setClientInfo("prop1", "prop1Value");
        this.matchClientInfoByName("prop1", "prop1Value");
    }

    private void matchClientInfoByName(String name, String match) throws SQLException {
        Assert.assertThat((Object)this.conn.getClientInfo(name), (Matcher)Is.is((Object)match));
    }

    @Test
    public void shouldCallGetMetaData() throws SQLException {
        Assert.assertNotNull((Object)this.conn.getMetaData());
    }

    @Test
    public void shouldCallGetTransactionIsolation() throws SQLException {
        Assert.assertThat((Object)this.conn.getTransactionIsolation(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void shouldCallGetTypeMap() throws SQLException {
        Assert.assertEquals(this.conn.getTypeMap(), new HashMap());
    }

    @Test
    public void ShouldCallGetWarnings() throws SQLException {
        Assert.assertNull((Object)this.conn.getWarnings());
    }

    @Test
    public void shouldCallIsClosed() throws SQLException {
        Assert.assertThat((Object)this.conn.isClosed(), (Matcher)Is.is((Object)false));
        this.conn.close();
        Assert.assertThat((Object)this.conn.isClosed(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCallIsReadOnly() throws SQLException {
        Assert.assertThat((Object)this.conn.isReadOnly(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCallIsValid() throws SQLException {
        Assert.assertThat((Object)this.conn.isValid(0), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.conn.isValid(120), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.conn.isValid(1200), (Matcher)Is.is((Object)true));
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionWhenIsValidArgIsLessThanZero() throws SQLException {
        this.conn.isValid(-1);
    }

    @Test
    public void shouldCallNativeSQL() throws SQLException {
        this.conn.nativeSQL("sql");
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallPrepareStatementAutoGenKeys() throws SQLException {
        this.conn.prepareStatement("sql", 1);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallPrepareStatementColumnIndexes() throws SQLException {
        this.conn.prepareStatement("sql", new int[0]);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallPrepareStatementColumnNames() throws SQLException {
        this.conn.prepareStatement("sql", new String[0]);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingPrepareStatement() throws SQLException {
        this.conn.prepareStatement("sql");
    }

    @Test
    public void shouldCallRollback() throws SQLException {
        this.conn.rollback();
    }

    @Test
    public void shouldCallSetAutoCommit() throws SQLException {
        this.conn.setAutoCommit(false);
        Assert.assertThat((Object)this.conn.getAutoCommit(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldCallSetClientInfoProperties() throws SQLException {
        Properties props = new Properties();
        props.setProperty("prop1", "prop1Value1");
        props.setProperty("prop2", "prop1Value2");
        this.conn.setClientInfo(props);
        Assert.assertThat((Object)this.conn.getClientInfo(), (Matcher)Is.is((Object)props));
    }

    @Test
    public void shouldCallSetClientInfoPropertyValue() throws SQLException {
        this.conn.setClientInfo("propertyname", "propvalue");
        this.matchClientInfoByName("propertyname", "propvalue");
    }

    @Test
    public void shouldCallSetReadOnly() throws SQLException {
        this.conn.setReadOnly(true);
        Assert.assertThat((Object)this.conn.isReadOnly(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCallIsWrapperFor() throws SQLException {
        Assert.assertThat((Object)this.conn.isWrapperFor(JcrConnection.class), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCallUnwrap() throws SQLException {
        Assert.assertThat((Object)this.conn.unwrap(JcrConnection.class), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(JcrConnection.class)));
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingSavepoint() throws SQLException {
        this.conn.rollback(null);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingSetSavepoint() throws SQLException {
        this.conn.setSavepoint();
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingSetSavepointPassingArg() throws SQLException {
        this.conn.setSavepoint(null);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetHoldability() throws SQLException {
        this.conn.getHoldability();
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingSetHoldability() throws SQLException {
        this.conn.setHoldability(1);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingCreateStatement3Parms() throws SQLException {
        this.conn.createStatement(1, 1, 1);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingCreateStatement2Parms() throws SQLException {
        this.conn.createStatement(1, 1);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingPrepareCall3Parms() throws SQLException {
        this.conn.prepareCall("sql", 1, 1, 1);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingPrepareCall2Parms() throws SQLException {
        this.conn.prepareCall("sql", 1, 1);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingPrepareCall() throws SQLException {
        this.conn.prepareCall("sql");
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingPrepareStatementWith3Parms() throws SQLException {
        this.conn.prepareStatement("sql", 1, 1);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingPrepareStatementWith4Parms() throws SQLException {
        this.conn.prepareStatement("sql", 1, 1, this.conn.getHoldability());
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingCreateArrayOf() throws SQLException {
        this.conn.createArrayOf("typename", new Object[0]);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingCreateBlob() throws SQLException {
        this.conn.createBlob();
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingCreateClob() throws SQLException {
        this.conn.createClob();
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingCreateNClob() throws SQLException {
        this.conn.createNClob();
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallinCreateSQLXML() throws SQLException {
        this.conn.createSQLXML();
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingCreateStruct() throws SQLException {
        this.conn.createStruct("typeName", new Object[0]);
    }

    @Test
    public void featureNotSupportedCallingSetTransactionIsolation() throws SQLException {
        this.conn.setTransactionIsolation(1);
    }

    @Test
    public void featureNotSupportedCallingSetCatalog() throws SQLException {
        this.conn.setCatalog("catalog");
    }
}

