/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.modeshape.jdbc.QueryResultRow;

class QueryResultRowIterator
implements RowIterator {
    private final Iterator<Object[]> tuples;
    protected final String query;
    private long position = 0L;
    private long numRows;
    private Row nextRow;
    private Node[] nodes;

    protected QueryResultRowIterator(Node[] nodes, String query, Iterator<Object[]> tuples, long numRows) {
        this.tuples = tuples;
        this.query = query;
        this.numRows = numRows;
        this.nodes = nodes;
    }

    public boolean hasSelector(String selectorName) {
        return false;
    }

    public Row nextRow() {
        if (this.nextRow == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        assert (this.nextRow != null);
        Row result = this.nextRow;
        this.nextRow = null;
        ++this.position;
        return result;
    }

    public long getPosition() {
        return this.position;
    }

    public long getSize() {
        return this.numRows;
    }

    public void skip(long skipNum) {
        for (long i = 0L; i != skipNum; ++i) {
            this.tuples.next();
        }
        this.position += skipNum;
    }

    public boolean hasNext() {
        if (this.nextRow != null) {
            return true;
        }
        while (this.tuples.hasNext()) {
            Object[] tuple = this.tuples.next();
            try {
                this.nextRow = this.getNextRow(tuple);
                if (this.nextRow != null) {
                    return true;
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            --this.numRows;
        }
        return false;
    }

    private Row getNextRow(Object[] tuple) throws RepositoryException {
        return new QueryResultRow(this, this.nodes, tuple);
    }

    public Object next() {
        return this.nextRow();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

