/*
 * ModeShape (http://www.modeshape.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.modeshape.jdbc.delegate;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;
import java.sql.SQLException;
import java.util.Properties;
import org.junit.Test;

/**
 * 
 */
public class RepositoryDelegateFactoryTest {

    private static final String INVALID_URL = "jdbc:metamatrix:jndi://";

    protected RepositoryDelegateFactory factory() {
        return LocalRepositoryDelegate.FACTORY;
    }

    @Test( expected = SQLException.class )
    public void shouldNotSupportCreatingInvalidURL() throws SQLException {
        factory().createRepositoryDelegate(INVALID_URL, new Properties(), null);
    }

    @Test
    public void shouldNotAcceptInvalidURL() {
        assertThat(factory().acceptUrl(INVALID_URL), is(false));
    }

}
