/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.ar.ArabicLetterTokenizer;
import org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import org.apache.lucene.analysis.ar.ArabicStemFilter;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArabicAnalyzer
extends Analyzer {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private final Set<?> stoptable;
    public static final String STOPWORDS_COMMENT = "#";
    private final Version matchVersion;

    public static Set<String> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public ArabicAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public ArabicAnalyzer(Version matchVersion, Set<?> stopwords) {
        this.stoptable = CharArraySet.unmodifiableSet(CharArraySet.copy(stopwords));
        this.matchVersion = matchVersion;
    }

    public ArabicAnalyzer(Version matchVersion, String ... stopwords) {
        this(matchVersion, StopFilter.makeStopSet(stopwords));
    }

    public ArabicAnalyzer(Version matchVersion, Hashtable<?, ?> stopwords) {
        this(matchVersion, stopwords.keySet());
    }

    public ArabicAnalyzer(Version matchVersion, File stopwords) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet(stopwords, STOPWORDS_COMMENT));
    }

    @Override
    public final TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new ArabicLetterTokenizer(reader);
        result = new LowerCaseFilter(result);
        result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault(this.matchVersion), result, this.stoptable);
        result = new ArabicNormalizationFilter(result);
        result = new ArabicStemFilter(result);
        return result;
    }

    @Override
    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new ArabicLetterTokenizer(reader);
            streams.result = new LowerCaseFilter(streams.source);
            streams.result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault(this.matchVersion), streams.result, this.stoptable);
            streams.result = new ArabicNormalizationFilter(streams.result);
            streams.result = new ArabicStemFilter(streams.result);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultSetHolder {
        static final Set<String> DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Set<String> loadDefaultStopWordSet() throws IOException {
            InputStream stream = ArabicAnalyzer.class.getResourceAsStream(ArabicAnalyzer.DEFAULT_STOPWORD_FILE);
            try {
                InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
                Set<String> set = Collections.unmodifiableSet(WordlistLoader.getWordSet(reader, ArabicAnalyzer.STOPWORDS_COMMENT));
                return set;
            }
            finally {
                stream.close();
            }
        }

        static {
            try {
                DEFAULT_STOP_SET = DefaultSetHolder.loadDefaultStopWordSet();
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

