/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.sinks;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.lucene.analysis.TeeSinkTokenFilter;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.AttributeSource;

public class DateRecognizerSinkFilter
extends TeeSinkTokenFilter.SinkFilter {
    public static final String DATE_TYPE = "date";
    protected DateFormat dateFormat;
    protected TermAttribute termAtt;

    public DateRecognizerSinkFilter() {
        this(SimpleDateFormat.getDateInstance());
    }

    public DateRecognizerSinkFilter(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public boolean accept(AttributeSource source) {
        if (this.termAtt == null) {
            this.termAtt = source.addAttribute(TermAttribute.class);
        }
        try {
            Date date = this.dateFormat.parse(this.termAtt.term());
            if (date != null) {
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }
}

