/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.snowball;

import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

public class SnowballAnalyzer
extends Analyzer {
    private String name;
    private Set<?> stopSet;
    private final Version matchVersion;

    public SnowballAnalyzer(Version matchVersion, String name) {
        this.name = name;
        this.setOverridesTokenStreamMethod(SnowballAnalyzer.class);
        this.matchVersion = matchVersion;
    }

    public SnowballAnalyzer(Version matchVersion, String name, String[] stopWords) {
        this(matchVersion, name);
        this.stopSet = StopFilter.makeStopSet(stopWords);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new StandardTokenizer(this.matchVersion, reader);
        result = new StandardFilter(result);
        result = new LowerCaseFilter(result);
        if (this.stopSet != null) {
            result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault(this.matchVersion), result, this.stopSet);
        }
        result = new SnowballFilter(result, this.name);
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        if (this.overridesTokenStreamMethod) {
            return this.tokenStream(fieldName, reader);
        }
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new StandardTokenizer(this.matchVersion, reader);
            streams.result = new StandardFilter(streams.source);
            streams.result = new LowerCaseFilter(streams.result);
            if (this.stopSet != null) {
                streams.result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault(this.matchVersion), streams.result, this.stopSet);
            }
            streams.result = new SnowballFilter(streams.result, this.name);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

