/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.cnd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.cnd.CndI18n;
import org.modeshape.cnd.CndTokenizer;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.text.TokenStream;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.IoUtil;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.io.Destination;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFormatException;

@NotThreadSafe
public class CndImporter {
    protected final List<String> VALID_PROPERTY_TYPES = Collections.unmodifiableList(Arrays.asList("STRING", "BINARY", "LONG", "DOUBLE", "BOOLEAN", "DATE", "NAME", "PATH", "REFERENCE", "WEAKREFERENCE", "DECIMAL", "URI", "UNDEFINED", "*", "?"));
    protected final List<String> VALID_ON_PARENT_VERSION = Collections.unmodifiableList(Arrays.asList("COPY", "VERSION", "INITIALIZE", "COMPUTE", "IGNORE", "ABORT"));
    protected final Set<String> VALID_QUERY_OPERATORS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("=", "<>", "<", "<=", ">", ">=", "LIKE")));
    protected final Destination destination;
    protected final Path outputPath;
    protected final PropertyFactory propertyFactory;
    protected final PathFactory pathFactory;
    protected final NameFactory nameFactory;
    protected final ValueFactories valueFactories;
    protected final boolean jcr170;

    public CndImporter(Destination destination, Path parentPath, boolean compatibleWithPreJcr2) {
        CheckArg.isNotNull(destination, "destination");
        CheckArg.isNotNull(parentPath, "parentPath");
        this.destination = destination;
        this.outputPath = parentPath;
        ExecutionContext context = destination.getExecutionContext();
        this.valueFactories = context.getValueFactories();
        this.propertyFactory = context.getPropertyFactory();
        this.pathFactory = this.valueFactories.getPathFactory();
        this.nameFactory = this.valueFactories.getNameFactory();
        this.jcr170 = compatibleWithPreJcr2;
    }

    public CndImporter(Destination destination, Path parentPath) {
        this(destination, parentPath, true);
    }

    public void importFrom(InputStream stream, Problems problems, String resourceName) throws IOException {
        this.importFrom(IoUtil.read(stream), problems, resourceName);
    }

    public void importFrom(File file, Problems problems) throws IOException {
        this.importFrom(IoUtil.read(file), problems, file.getCanonicalPath());
    }

    public void importFrom(String content, Problems problems, String resourceName) {
        try {
            this.parse(content);
            this.destination.submit();
        }
        catch (RuntimeException e) {
            problems.addError((Throwable)e, CndI18n.errorImportingCndContent, resourceName, e.getMessage());
        }
    }

    protected void parse(String content) {
        CndTokenizer tokenizer = new CndTokenizer(false, false);
        TokenStream tokens = new TokenStream(content, tokenizer, false);
        tokens.start();
        while (tokens.hasNext()) {
            if (tokens.matches("<", "any value", "=", "any value", ">")) {
                this.parseNamespaceMapping(tokens);
                continue;
            }
            if (tokens.matches("[", "any value", "]")) {
                this.parseNodeTypeDefinition(tokens, this.outputPath);
                continue;
            }
            Position position = tokens.previousPosition();
            throw new ParsingException(position, CndI18n.expectedNamespaceOrNodeDefinition.text(tokens.consume(), position.getLine(), position.getColumn()));
        }
    }

    protected void parseNamespaceMapping(TokenStream tokens) {
        tokens.consume('<');
        String prefix = this.removeQuotes(tokens.consume());
        tokens.consume('=');
        String uri = this.removeQuotes(tokens.consume());
        tokens.consume('>');
        this.destination.getExecutionContext().getNamespaceRegistry().register(prefix, uri);
    }

    protected void parseNodeTypeDefinition(TokenStream tokens, Path path) {
        Name name = this.parseNodeTypeName(tokens);
        Path nodeTypePath = this.pathFactory.create(path, name);
        ArrayList<Property> properties = new ArrayList<Property>();
        properties.add(this.propertyFactory.create(JcrLexicon.NODE_TYPE_NAME, name));
        List<Name> supertypes = this.parseSupertypes(tokens);
        properties.add(this.propertyFactory.create(JcrLexicon.SUPERTYPES, supertypes));
        this.parseNodeTypeOptions(tokens, properties);
        this.destination.create(nodeTypePath, properties);
        this.parsePropertyOrChildNodeDefinitions(tokens, nodeTypePath);
    }

    protected Name parseNodeTypeName(TokenStream tokens) {
        tokens.consume('[');
        Name name = this.parseName(tokens);
        tokens.consume(']');
        return name;
    }

    protected List<Name> parseSupertypes(TokenStream tokens) {
        if (tokens.canConsume('>')) {
            return this.parseNameList(tokens);
        }
        return Collections.emptyList();
    }

    protected List<String> parseStringList(TokenStream tokens) {
        ArrayList<String> strings = new ArrayList<String>();
        if (tokens.canConsume('?')) {
            strings.add("?");
        } else {
            do {
                strings.add(this.removeQuotes(tokens.consume()));
            } while (tokens.canConsume(','));
        }
        return strings;
    }

    protected List<Name> parseNameList(TokenStream tokens) {
        ArrayList<Name> names = new ArrayList<Name>();
        if (!tokens.canConsume('?')) {
            do {
                names.add(this.parseName(tokens));
            } while (tokens.canConsume(','));
        }
        return names;
    }

    protected void parseNodeTypeOptions(TokenStream tokens, List<Property> properties) {
        boolean isOrderable = false;
        boolean isMixin = false;
        boolean isAbstract = false;
        boolean isQueryable = true;
        Name primaryItem = null;
        String onParentVersion = "COPY";
        while (true) {
            if (tokens.canConsumeAnyOf("ORDERABLE", "ORD", "O")) {
                tokens.canConsume('?');
                isOrderable = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("MIXIN", "MIX", "M")) {
                tokens.canConsume('?');
                isMixin = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("ABSTRACT", "ABS", "A")) {
                tokens.canConsume('?');
                isAbstract = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("NOQUERY", "NOQ")) {
                tokens.canConsume('?');
                isQueryable = false;
                continue;
            }
            if (tokens.canConsumeAnyOf("QUERY", "Q")) {
                tokens.canConsume('?');
                isQueryable = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("PRIMARYITEM", "!")) {
                primaryItem = this.parseName(tokens);
                tokens.canConsume('?');
                continue;
            }
            if (tokens.matchesAnyOf(this.VALID_ON_PARENT_VERSION)) {
                onParentVersion = tokens.consume();
                tokens.canConsume('?');
                continue;
            }
            if (!tokens.matches("OPV")) break;
            onParentVersion = tokens.consume();
            tokens.canConsume('?');
        }
        properties.add(this.propertyFactory.create(JcrLexicon.HAS_ORDERABLE_CHILD_NODES, isOrderable));
        properties.add(this.propertyFactory.create(JcrLexicon.IS_MIXIN, isMixin));
        properties.add(this.propertyFactory.create(JcrLexicon.IS_ABSTRACT, isAbstract));
        properties.add(this.propertyFactory.create(JcrLexicon.IS_QUERYABLE, isQueryable));
        properties.add(this.propertyFactory.create(JcrLexicon.ON_PARENT_VERSION, onParentVersion.toUpperCase()));
        if (primaryItem != null) {
            properties.add(this.propertyFactory.create(JcrLexicon.PRIMARY_ITEM_NAME, primaryItem));
        }
    }

    protected void parsePropertyOrChildNodeDefinitions(TokenStream tokens, Path nodeTypePath) {
        while (true) {
            if (tokens.matches('-')) {
                this.parsePropertyDefinition(tokens, nodeTypePath);
                continue;
            }
            if (!tokens.matches('+')) break;
            this.parseChildNodeDefinition(tokens, nodeTypePath);
        }
    }

    protected void parsePropertyDefinition(TokenStream tokens, Path nodeTypePath) {
        tokens.consume('-');
        Name name = this.parseName(tokens);
        Path path = this.pathFactory.create(nodeTypePath, JcrLexicon.PROPERTY_DEFINITION);
        ArrayList<Property> properties = new ArrayList<Property>();
        properties.add(this.propertyFactory.create(JcrLexicon.NAME, name));
        this.parsePropertyType(tokens, properties, PropertyType.STRING.getName());
        this.parseDefaultValues(tokens, properties);
        this.parsePropertyAttributes(tokens, properties, name, path);
        this.parseValueConstraints(tokens, properties);
        this.destination.create(path, properties);
    }

    protected void parsePropertyType(TokenStream tokens, List<Property> properties, String defaultPropertyType) {
        if (tokens.canConsume('(')) {
            String propertyType = defaultPropertyType;
            if (tokens.matchesAnyOf(this.VALID_PROPERTY_TYPES) && "*".equals(propertyType = tokens.consume())) {
                propertyType = "UNDEFINED";
            }
            tokens.consume(')');
            properties.add(this.propertyFactory.create(JcrLexicon.REQUIRED_TYPE, propertyType.toUpperCase()));
        }
    }

    protected void parseDefaultValues(TokenStream tokens, List<Property> properties) {
        List<String> defaultValues;
        if (tokens.canConsume('=') && !(defaultValues = this.parseStringList(tokens)).isEmpty()) {
            properties.add(this.propertyFactory.create(JcrLexicon.DEFAULT_VALUES, defaultValues));
        }
    }

    protected void parseValueConstraints(TokenStream tokens, List<Property> properties) {
        List<String> defaultValues;
        if (tokens.canConsume('<') && !(defaultValues = this.parseStringList(tokens)).isEmpty()) {
            properties.add(this.propertyFactory.create(JcrLexicon.VALUE_CONSTRAINTS, defaultValues));
        }
    }

    protected void parsePropertyAttributes(TokenStream tokens, List<Property> properties, Name propDefnName, Path propDefnPath) {
        boolean autoCreated = false;
        boolean mandatory = false;
        boolean isProtected = false;
        boolean multiple = false;
        boolean isFullTextSearchable = true;
        boolean isQueryOrderable = true;
        String onParentVersion = "COPY";
        while (true) {
            if (tokens.canConsumeAnyOf("AUTOCREATED", "AUT", "A")) {
                tokens.canConsume('?');
                autoCreated = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("MANDATORY", "MAN", "M")) {
                tokens.canConsume('?');
                mandatory = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("PROTECTED", "PRO", "P")) {
                tokens.canConsume('?');
                isProtected = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("MULTIPLE", "MUL", "*")) {
                tokens.canConsume('?');
                multiple = true;
                continue;
            }
            if (tokens.matchesAnyOf(this.VALID_ON_PARENT_VERSION)) {
                onParentVersion = tokens.consume();
                tokens.canConsume('?');
                continue;
            }
            if (tokens.matches("OPV")) {
                onParentVersion = tokens.consume();
                tokens.canConsume('?');
                continue;
            }
            if (tokens.canConsumeAnyOf("NOFULLTEXT", "NOF")) {
                tokens.canConsume('?');
                isFullTextSearchable = false;
                continue;
            }
            if (tokens.canConsumeAnyOf("NOQUERYORDER", "NQORD")) {
                tokens.canConsume('?');
                isQueryOrderable = false;
                continue;
            }
            if (tokens.canConsumeAnyOf("QUERYOPS", "QOP")) {
                this.parseQueryOperators(tokens, properties);
                continue;
            }
            if (!tokens.canConsumeAnyOf("PRIMARY", "PRI", "!")) break;
            if (!this.jcr170) {
                Position pos = tokens.previousPosition();
                int line = pos.getLine();
                int column = pos.getColumn();
                throw new ParsingException(tokens.previousPosition(), CndI18n.primaryKeywordNotValidInJcr2CndFormat.text(line, column));
            }
            Property primaryItem = this.propertyFactory.create(JcrLexicon.PRIMARY_ITEM_NAME, propDefnName);
            this.destination.setProperties(propDefnPath.getParent(), primaryItem);
        }
        properties.add(this.propertyFactory.create(JcrLexicon.AUTO_CREATED, autoCreated));
        properties.add(this.propertyFactory.create(JcrLexicon.MANDATORY, mandatory));
        properties.add(this.propertyFactory.create(JcrLexicon.PROTECTED, isProtected));
        properties.add(this.propertyFactory.create(JcrLexicon.ON_PARENT_VERSION, onParentVersion.toUpperCase()));
        properties.add(this.propertyFactory.create(JcrLexicon.MULTIPLE, multiple));
        properties.add(this.propertyFactory.create(JcrLexicon.IS_FULL_TEXT_SEARCHABLE, isFullTextSearchable));
        properties.add(this.propertyFactory.create(JcrLexicon.IS_QUERY_ORDERABLE, isQueryOrderable));
    }

    protected void parseQueryOperators(TokenStream tokens, List<Property> properties) {
        if (tokens.canConsume('?')) {
            return;
        }
        ArrayList<String> operators = new ArrayList<String>();
        String operatorList = this.removeQuotes(tokens.consume());
        for (String operatorValue : operatorList.split(",")) {
            String operator = operatorValue.trim();
            if (!this.VALID_QUERY_OPERATORS.contains(operator)) {
                throw new ParsingException(tokens.previousPosition(), CndI18n.expectedValidQueryOperator.text(operator));
            }
            operators.add(operator);
        }
        if (operators.isEmpty()) {
            operators.addAll(this.VALID_QUERY_OPERATORS);
        }
        properties.add(this.propertyFactory.create(JcrLexicon.QUERY_OPERATORS, operators));
    }

    protected void parseChildNodeDefinition(TokenStream tokens, Path nodeTypePath) {
        tokens.consume('+');
        Name name = this.parseName(tokens);
        Path path = this.pathFactory.create(nodeTypePath, JcrLexicon.CHILD_NODE_DEFINITION);
        ArrayList<Property> properties = new ArrayList<Property>();
        properties.add(this.propertyFactory.create(JcrLexicon.NAME, name));
        this.parseRequiredPrimaryTypes(tokens, properties);
        this.parseDefaultType(tokens, properties);
        this.parseNodeAttributes(tokens, properties, name, path);
        this.destination.create(path, properties);
    }

    protected void parseRequiredPrimaryTypes(TokenStream tokens, List<Property> properties) {
        if (tokens.canConsume('(')) {
            List<Name> requiredTypes = this.parseNameList(tokens);
            if (requiredTypes.isEmpty()) {
                requiredTypes.add(JcrNtLexicon.BASE);
            }
            properties.add(this.propertyFactory.create(JcrLexicon.REQUIRED_PRIMARY_TYPES, requiredTypes));
            tokens.consume(')');
        }
    }

    protected void parseDefaultType(TokenStream tokens, List<Property> properties) {
        if (tokens.canConsume('=') && !tokens.canConsume('?')) {
            Name defaultType = this.parseName(tokens);
            properties.add(this.propertyFactory.create(JcrLexicon.DEFAULT_PRIMARY_TYPE, defaultType));
        }
    }

    protected void parseNodeAttributes(TokenStream tokens, List<Property> properties, Name childNodeDefnName, Path childNodeDefnPath) {
        boolean autoCreated = false;
        boolean mandatory = false;
        boolean isProtected = false;
        boolean sns = false;
        String onParentVersion = "COPY";
        while (true) {
            if (tokens.canConsumeAnyOf("AUTOCREATED", "AUT", "A")) {
                tokens.canConsume('?');
                autoCreated = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("MANDATORY", "MAN", "M")) {
                tokens.canConsume('?');
                mandatory = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("PROTECTED", "PRO", "P")) {
                tokens.canConsume('?');
                isProtected = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("SNS", "*")) {
                tokens.canConsume('?');
                sns = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("MULTIPLE", "MUL", "*")) {
                if (!this.jcr170) {
                    Position pos = tokens.previousPosition();
                    int line = pos.getLine();
                    int column = pos.getColumn();
                    throw new ParsingException(tokens.previousPosition(), CndI18n.multipleKeywordNotValidInJcr2CndFormat.text(line, column));
                }
                tokens.canConsume('?');
                sns = true;
                continue;
            }
            if (tokens.matchesAnyOf(this.VALID_ON_PARENT_VERSION)) {
                onParentVersion = tokens.consume();
                tokens.canConsume('?');
                continue;
            }
            if (tokens.matches("OPV")) {
                onParentVersion = tokens.consume();
                tokens.canConsume('?');
                continue;
            }
            if (!tokens.canConsumeAnyOf("PRIMARYITEM", "PRIMARY", "PRI", "!")) break;
            Property primaryItem = this.propertyFactory.create(JcrLexicon.PRIMARY_ITEM_NAME, childNodeDefnName);
            this.destination.setProperties(childNodeDefnPath.getParent(), primaryItem);
        }
        properties.add(this.propertyFactory.create(JcrLexicon.AUTO_CREATED, autoCreated));
        properties.add(this.propertyFactory.create(JcrLexicon.MANDATORY, mandatory));
        properties.add(this.propertyFactory.create(JcrLexicon.PROTECTED, isProtected));
        properties.add(this.propertyFactory.create(JcrLexicon.ON_PARENT_VERSION, onParentVersion.toUpperCase()));
        properties.add(this.propertyFactory.create(JcrLexicon.SAME_NAME_SIBLINGS, sns));
    }

    protected Name parseName(TokenStream tokens) {
        String value = tokens.consume();
        try {
            return (Name)this.nameFactory.create(this.removeQuotes(value));
        }
        catch (ValueFormatException e) {
            throw new ParsingException(tokens.previousPosition(), CndI18n.expectedValidNameLiteral.text(value));
        }
    }

    protected final String removeQuotes(String text) {
        return text.replaceFirst("^['\"]+", "").replaceAll("['\"]+$", "");
    }
}

