/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import java.util.List;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;

@Immutable
class LocationWithPath
extends Location {
    private static final long serialVersionUID = 1L;
    private final Path path;
    private final int hashCode;

    LocationWithPath(Path path) {
        assert (path != null);
        this.path = path;
        this.hashCode = HashCode.compute(path);
    }

    @Override
    public final Path getPath() {
        return this.path;
    }

    @Override
    public final boolean hasPath() {
        return true;
    }

    @Override
    public List<Property> getIdProperties() {
        return null;
    }

    @Override
    public boolean hasIdProperties() {
        return false;
    }

    @Override
    public UUID getUuid() {
        return null;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder, TextEncoder delimiterEncoder) {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        sb.append(this.path.getString(namespaceRegistry, encoder, delimiterEncoder));
        sb.append(" }");
        return sb.toString();
    }

    @Override
    public Location with(Property newIdProperty) {
        if (newIdProperty == null || newIdProperty.isEmpty()) {
            return this;
        }
        return LocationWithPath.create(this.path, newIdProperty);
    }

    @Override
    public Location with(Path newPath) {
        if (newPath == null || this.path.equals(newPath)) {
            return this;
        }
        return LocationWithPath.create(newPath);
    }

    @Override
    public Location with(UUID uuid) {
        if (uuid == null) {
            return this;
        }
        return LocationWithPath.create(this.path, uuid);
    }
}

