/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.modeshape.graph.connector.base.Node;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;

public class PathNode
implements Node,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private UUID uuid;
    private Path parent;
    private Path.Segment name;
    private Map<Name, Property> properties;
    private List<Path.Segment> children;
    private int version = 1;
    protected transient Changes changes;

    public PathNode(UUID uuid, Path parent, Path.Segment name, Map<Name, Property> properties, List<Path.Segment> children) {
        this.uuid = uuid;
        this.parent = parent;
        this.name = name;
        this.properties = properties != null ? properties : Collections.emptyMap();
        List<Path.Segment> list = this.children = children != null ? children : Collections.emptyList();
        assert (this.properties != null);
        assert (this.children != null);
        assert (this.name == null ? this.parent == null : this.parent != null);
    }

    protected PathNode(UUID uuid, Path parent, Path.Segment name, Map<Name, Property> properties, List<Path.Segment> children, int version) {
        this.uuid = uuid;
        this.parent = parent;
        this.name = name;
        this.properties = properties != null ? properties : Collections.emptyMap();
        this.children = children != null ? children : Collections.emptyList();
        this.version = version;
        assert (this.properties != null);
        assert (this.children != null);
        assert (this.name == null ? this.parent == null : this.parent != null);
    }

    public PathNode(UUID uuid, Path parent, Path.Segment name, Iterable<Property> properties, List<Path.Segment> children) {
        this.uuid = uuid;
        this.parent = parent;
        this.name = name;
        if (properties != null) {
            HashMap<Name, Property> props = new HashMap<Name, Property>();
            for (Property prop : properties) {
                props.put(prop.getName(), prop);
            }
            this.properties = props.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(props);
        } else {
            this.properties = Collections.emptyMap();
        }
        List<Path.Segment> list = this.children = children != null ? children : Collections.emptyList();
        assert (this.properties != null);
        assert (this.children != null);
        assert (this.name == null ? this.parent == null : this.parent != null);
    }

    public PathNode(UUID uuid) {
        this.uuid = uuid;
        this.parent = null;
        this.name = null;
        this.properties = Collections.emptyMap();
        this.children = Collections.emptyList();
        assert (this.uuid != null);
        assert (this.properties != null);
        assert (this.children != null);
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public Path.Segment getName() {
        return this.changes != null ? this.changes.getName() : this.name;
    }

    public Path getParent() {
        return this.changes != null ? this.changes.getParent() : this.parent;
    }

    @Override
    public Map<Name, Property> getProperties() {
        return this.changes != null ? this.changes.getProperties(false) : this.properties;
    }

    @Override
    public Property getProperty(Name name) {
        return this.getProperties().get(name);
    }

    public List<Path.Segment> getChildren() {
        return this.changes != null ? this.changes.getChildren(false) : this.children;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : ((Object)this.children).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathNode other = (PathNode)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.parent == null) {
            sb.append("/");
        } else {
            sb.append(this.getParent()).append("/").append(this.getName());
        }
        sb.append(" (");
        sb.append(this.getUuid()).append(")");
        return sb.toString();
    }

    public PathNode clone() {
        return new PathNode(this.uuid, this.parent, this.name, new HashMap<Name, Property>(this.properties), new ArrayList<Path.Segment>(this.children));
    }

    protected boolean hasChanges() {
        return this.changes != null;
    }

    protected Changes newChanges() {
        return new Changes();
    }

    public PathNode freeze() {
        if (!this.hasChanges()) {
            return this;
        }
        return new PathNode(this.uuid, this.changes.getParent(), this.changes.getName(), this.changes.getUnmodifiableProperties(), this.changes.getUnmodifiableChildren(), this.version + 1);
    }

    public PathNode withParent(Path parent) {
        if (this.changes == null) {
            PathNode copy = this.clone();
            copy.changes = this.newChanges();
            copy.changes.setParent(parent);
            return copy;
        }
        this.changes.setParent(parent);
        return this;
    }

    public PathNode withName(Path.Segment name) {
        if (this.changes == null) {
            PathNode copy = this.clone();
            copy.changes = this.newChanges();
            copy.changes.setName(name);
            return copy;
        }
        this.changes.setName(name);
        return this;
    }

    public PathNode withChild(Path.Segment child) {
        assert (child != null);
        if (this.getChildren().indexOf(child) != -1) {
            return this;
        }
        if (this.changes == null) {
            PathNode copy = this.clone();
            LinkedList<Path.Segment> children = new LinkedList<Path.Segment>(this.getChildren());
            assert (!children.contains(child));
            children.add(child);
            copy.changes = this.newChanges();
            copy.changes.setChildren(children);
            return copy;
        }
        this.changes.getChildren(true).add(child);
        return this;
    }

    public PathNode withChild(int index, Path.Segment child) {
        assert (child != null);
        assert (index >= 0);
        int existingIndex = this.getChildren().indexOf(child);
        if (existingIndex == index) {
            return this;
        }
        if (this.changes == null) {
            PathNode copy = this.clone();
            LinkedList<Path.Segment> children = new LinkedList<Path.Segment>(this.getChildren());
            if (existingIndex >= 0) {
                children.remove(existingIndex);
                if (existingIndex < index) {
                    --index;
                }
            }
            children.add(index, child);
            copy.changes = this.newChanges();
            copy.changes.setChildren(children);
            return copy;
        }
        List<Path.Segment> children = this.changes.getChildren(true);
        if (existingIndex >= 0) {
            children.remove(existingIndex);
            if (existingIndex < index) {
                --index;
            }
        }
        children.add(index, child);
        return this;
    }

    public PathNode withoutChild(Path.Segment child) {
        assert (child != null);
        if (this.changes == null) {
            PathNode copy = this.clone();
            LinkedList<Path.Segment> children = new LinkedList<Path.Segment>(this.getChildren());
            children.remove(child);
            copy.changes = this.newChanges();
            copy.changes.setChildren(children);
            return copy;
        }
        this.changes.getChildren(true).remove(child);
        return this;
    }

    public PathNode withoutChildren() {
        if (this.getChildren().isEmpty()) {
            return this;
        }
        if (this.changes == null) {
            PathNode copy = this.clone();
            copy.changes = this.newChanges();
            copy.changes.setChildren(new LinkedList<Path.Segment>());
            return copy;
        }
        this.changes.getChildren(true).clear();
        return this;
    }

    public PathNode withProperties(Iterable<Property> propertiesToSet, Iterable<Name> propertiesToRemove, boolean removeAllExisting) {
        if (propertiesToSet == null && propertiesToRemove == null && !removeAllExisting) {
            return this;
        }
        Map<Name, Property> newProperties = null;
        PathNode result = this;
        if (this.changes == null) {
            PathNode copy = this.clone();
            copy.changes = this.newChanges();
            copy.changes.setProperties(new HashMap<Name, Property>(this.properties));
            newProperties = copy.changes.getProperties(true);
            result = copy;
        } else {
            newProperties = this.changes.getProperties(true);
        }
        if (removeAllExisting) {
            newProperties.clear();
        } else if (propertiesToRemove != null) {
            for (Name name : propertiesToRemove) {
                newProperties.remove(name);
            }
        } else if (propertiesToSet == null) {
            return this;
        }
        if (propertiesToSet != null) {
            for (Property property : propertiesToSet) {
                newProperties.put(property.getName(), property);
            }
        }
        return result;
    }

    public PathNode withProperty(Property property) {
        if (property == null) {
            return this;
        }
        if (this.changes == null) {
            PathNode copy = this.clone();
            copy.changes = this.newChanges();
            HashMap<Name, Property> newProps = new HashMap<Name, Property>(this.properties);
            newProps.put(property.getName(), property);
            copy.changes.setProperties(newProps);
            return copy;
        }
        this.changes.getProperties(true).put(property.getName(), property);
        return this;
    }

    public PathNode withoutProperty(Name propertyName) {
        if (propertyName == null || !this.getProperties().containsKey(propertyName)) {
            return this;
        }
        if (this.changes == null) {
            PathNode copy = this.clone();
            copy.changes = this.newChanges();
            copy.changes.setProperties(new HashMap<Name, Property>(this.properties));
            return copy;
        }
        this.changes.getProperties(true).remove(propertyName);
        return this;
    }

    public PathNode withoutProperties() {
        if (this.getProperties().isEmpty()) {
            return this;
        }
        if (this.changes == null) {
            PathNode copy = this.clone();
            copy.changes = this.newChanges();
            copy.changes.setProperties(new HashMap<Name, Property>());
            return copy;
        }
        this.changes.getProperties(true).clear();
        return this;
    }

    protected class Changes {
        private Path parent;
        private Path.Segment name;
        private Map<Name, Property> properties;
        private List<Path.Segment> children;

        protected Changes() {
        }

        public Path getParent() {
            return this.parent != null ? this.parent : PathNode.this.parent;
        }

        public void setParent(Path parent) {
            this.parent = parent;
        }

        public Path.Segment getName() {
            return this.name != null ? this.name : PathNode.this.name;
        }

        public void setName(Path.Segment name) {
            this.name = name;
        }

        public Map<Name, Property> getProperties(boolean createIfMissing) {
            if (this.properties == null) {
                if (createIfMissing) {
                    this.properties = new HashMap<Name, Property>(PathNode.this.properties);
                    return this.properties;
                }
                return PathNode.this.properties;
            }
            return this.properties;
        }

        public Map<Name, Property> getUnmodifiableProperties() {
            return this.properties != null ? Collections.unmodifiableMap(this.properties) : PathNode.this.properties;
        }

        public void setProperties(Map<Name, Property> properties) {
            this.properties = properties;
        }

        public List<Path.Segment> getChildren(boolean createIfMissing) {
            if (this.children == null) {
                if (createIfMissing) {
                    this.children = new LinkedList<Path.Segment>();
                    return this.children;
                }
                return PathNode.this.children;
            }
            return this.children;
        }

        public List<Path.Segment> getUnmodifiableChildren() {
            return this.children != null ? Collections.unmodifiableList(this.children) : PathNode.this.children;
        }

        public void setChildren(List<Path.Segment> children) {
            this.children = children;
        }
    }
}

