/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.connector.base.Node;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.connector.base.Transaction;
import org.modeshape.graph.connector.base.Workspace;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.CloneBranchRequest;
import org.modeshape.graph.request.CloneWorkspaceRequest;
import org.modeshape.graph.request.CopyBranchRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.DeleteBranchRequest;
import org.modeshape.graph.request.DestroyWorkspaceRequest;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.InvalidRequestException;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.request.LockBranchRequest;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.UnlockBranchRequest;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.VerifyWorkspaceRequest;
import org.modeshape.graph.request.processor.RequestProcessor;

public class Processor<NodeType extends Node, WorkspaceType extends Workspace>
extends RequestProcessor {
    private final PathFactory pathFactory;
    private final PropertyFactory propertyFactory;
    private final Repository<NodeType, WorkspaceType> repository;
    private final boolean updatesAllowed;
    private final Transaction<NodeType, WorkspaceType> txn;

    public Processor(Transaction<NodeType, WorkspaceType> txn, Repository<NodeType, WorkspaceType> repository, Observer observer, boolean updatesAllowed) {
        super(repository.getSourceName(), txn.getContext(), observer);
        this.txn = txn;
        this.repository = repository;
        this.pathFactory = txn.getContext().getValueFactories().getPathFactory();
        this.propertyFactory = txn.getContext().getPropertyFactory();
        this.updatesAllowed = updatesAllowed;
    }

    @Override
    public void process(ReadNodeRequest request) {
        WorkspaceType workspace = this.getWorkspace(request, request.inWorkspace());
        NodeType node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            assert (request.hasError());
            return;
        }
        Location actualLocation = this.getActualLocation(workspace, request.at(), node);
        assert (actualLocation != null);
        Path path = actualLocation.getPath();
        List<NodeType> children = this.txn.getChildren(workspace, node);
        for (Node child : children) {
            Path.Segment childName = child.getName();
            Path childPath = this.pathFactory.create(path, childName);
            Location childLocation = null;
            childLocation = child.getUuid() != null ? Location.create(childPath, child.getUuid()) : Location.create(childPath);
            request.addChild(childLocation);
        }
        request.addProperty(this.propertyFactory.create(ModeShapeLexicon.UUID, node.getUuid()));
        request.addProperties(node.getProperties().values());
        request.setActualLocationOfNode(actualLocation);
        this.setCacheableInfo(request);
    }

    @Override
    public void process(ReadAllChildrenRequest request) {
        WorkspaceType workspace = this.getWorkspace(request, request.inWorkspace());
        NodeType node = this.getTargetNode(workspace, request, request.of());
        if (node == null) {
            assert (request.hasError());
            return;
        }
        Location actualLocation = this.getActualLocation(workspace, request.of(), node);
        assert (actualLocation != null);
        Path path = actualLocation.getPath();
        List<NodeType> children = this.txn.getChildren(workspace, node);
        for (Node child : children) {
            Path.Segment childName = child.getName();
            Path childPath = this.pathFactory.create(path, childName);
            Location childLocation = null;
            childLocation = child.getUuid() != null ? Location.create(childPath, child.getUuid()) : Location.create(childPath);
            request.addChild(childLocation);
        }
        request.setActualLocationOfNode(actualLocation);
        this.setCacheableInfo(request);
    }

    @Override
    public void process(LockBranchRequest request) {
        WorkspaceType workspace = this.getWorkspace(request, request.inWorkspace());
        NodeType node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            return;
        }
        this.txn.lockNode(workspace, node, request.lockScope(), request.lockTimeoutInMillis());
        Location actualLocation = this.getActualLocation(workspace, request.at(), node);
        request.setActualLocation(actualLocation);
        this.recordChange(request);
    }

    @Override
    public void process(UnlockBranchRequest request) {
        WorkspaceType workspace = this.getWorkspace(request, request.inWorkspace());
        NodeType node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            return;
        }
        this.txn.unlockNode(workspace, node);
        Location actualLocation = this.getActualLocation(workspace, request.at(), node);
        request.setActualLocation(actualLocation);
        this.recordChange(request);
    }

    @Override
    public void process(ReadAllPropertiesRequest request) {
        WorkspaceType workspace = this.getWorkspace(request, request.inWorkspace());
        NodeType node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            assert (request.hasError());
            return;
        }
        Location actualLocation = this.getActualLocation(workspace, request.at(), node);
        request.addProperty(this.propertyFactory.create(ModeShapeLexicon.UUID, node.getUuid()));
        request.addProperties(node.getProperties().values());
        assert (actualLocation != null);
        request.setActualLocationOfNode(actualLocation);
        this.setCacheableInfo(request);
    }

    @Override
    public void process(CloneBranchRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        WorkspaceType workspace = this.getWorkspace(request, request.fromWorkspace());
        WorkspaceType newWorkspace = this.getWorkspace(request, request.intoWorkspace());
        if (workspace == null || newWorkspace == null) {
            return;
        }
        NodeType node = this.getTargetNode(workspace, request, request.from());
        if (node == null) {
            return;
        }
        Path newParentPath = request.into().getPath();
        NodeType newParent = this.txn.getNode(newWorkspace, request.into());
        HashSet<Location> removedExistingNodes = new HashSet<Location>();
        NodeType newNode = this.txn.cloneNode(workspace, node, newWorkspace, newParent, request.desiredName(), request.desiredSegment(), request.removeExisting(), removedExistingNodes);
        Path newPath = this.getExecutionContext().getValueFactories().getPathFactory().create(newParentPath, newNode.getName());
        Location oldLocation = this.getActualLocation(workspace, request.from(), node);
        Location newLocation = Location.create(newPath, newNode.getUuid());
        request.setActualLocations(oldLocation, newLocation);
        request.setRemovedNodes(Collections.unmodifiableSet(removedExistingNodes));
        this.recordChange(request);
    }

    @Override
    public void process(CopyBranchRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        WorkspaceType workspace = this.getWorkspace(request, request.fromWorkspace());
        WorkspaceType newWorkspace = this.getWorkspace(request, request.intoWorkspace());
        if (workspace == null || newWorkspace == null) {
            return;
        }
        NodeType node = this.getTargetNode(workspace, request, request.from());
        if (node == null) {
            return;
        }
        Path newParentPath = request.into().getPath();
        Name desiredName = request.desiredName();
        NodeType newParent = this.getTargetNode(newWorkspace, request, request.into());
        if (newParent == null) {
            return;
        }
        NodeType newNode = this.txn.copyNode(workspace, node, newWorkspace, newParent, desiredName, true);
        Path newPath = this.getExecutionContext().getValueFactories().getPathFactory().create(newParentPath, newNode.getName());
        Location oldLocation = this.getActualLocation(workspace, request.from(), node);
        Location newLocation = Location.create(newPath, newNode.getUuid());
        request.setActualLocations(oldLocation, newLocation);
        this.recordChange(request);
    }

    @Override
    public void process(CreateNodeRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        WorkspaceType workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        NodeType parentNode = this.txn.getNode(workspace, request.under());
        UUID uuid = null;
        ArrayList<Property> propsToStore = new ArrayList<Property>(request.properties().size());
        for (Property property : request.properties()) {
            if (property.getName().equals(ModeShapeLexicon.UUID) || property.getName().equals(JcrLexicon.UUID)) {
                uuid = (UUID)this.getExecutionContext().getValueFactories().getUuidFactory().create(property.getValues().next());
                continue;
            }
            if (property.size() <= 0) continue;
            propsToStore.add(property);
        }
        Object node = null;
        switch (request.conflictBehavior()) {
            case APPEND: {
                node = this.txn.addChild(workspace, parentNode, request.named(), -1, uuid, propsToStore);
                break;
            }
            case DO_NOT_REPLACE: {
                node = this.txn.getFirstChild(workspace, parentNode, request.named());
                if (node != null) break;
                node = this.txn.addChild(workspace, parentNode, request.named(), -1, uuid, propsToStore);
                break;
            }
            case REPLACE: {
                node = this.txn.getFirstChild(workspace, parentNode, request.named());
                if (node != null) {
                    List<Object> children = this.txn.getChildren(workspace, node);
                    for (Node node2 : children) {
                        this.txn.removeNode(workspace, node2);
                    }
                    this.txn.setProperties(workspace, node, propsToStore, null, true);
                    break;
                }
                node = this.txn.addChild(workspace, parentNode, request.named(), -1, uuid, propsToStore);
                break;
            }
            case UPDATE: {
                node = this.txn.getFirstChild(workspace, parentNode, request.named());
                if (node != null) break;
                node = this.txn.addChild(workspace, parentNode, request.named(), -1, uuid, propsToStore);
            }
        }
        assert (node != null);
        Path path = this.txn.pathFor(workspace, node);
        Location actualLocation = this.getActualLocation(workspace, Location.create(path), node);
        request.setActualLocationOfNode(actualLocation);
        this.recordChange(request);
    }

    @Override
    public void process(DeleteBranchRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        WorkspaceType workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        NodeType node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            return;
        }
        Location actualLocation = this.txn.removeNode(workspace, node);
        request.setActualLocationOfNode(actualLocation);
        this.recordChange(request);
    }

    @Override
    public void process(MoveBranchRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        WorkspaceType workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        Object beforeNode = request.before() != null ? (Object)this.getTargetNode(workspace, request, request.before()) : null;
        NodeType node = this.getTargetNode(workspace, request, request.from());
        if (node == null) {
            return;
        }
        if (request.hasError()) {
            return;
        }
        Object newParent = null;
        Location newLocation = null;
        if (request.into() != null) {
            newParent = this.txn.getNode(workspace, request.into());
            newLocation = this.txn.addChild(workspace, newParent, node, null, request.desiredName());
        } else {
            assert (beforeNode != null);
            newParent = this.txn.getParent(workspace, beforeNode);
            if (newParent == null) {
                request.setError(new PathNotFoundException(request.into(), this.pathFactory.createRootPath(), GraphI18n.nodeDoesNotExist.text("parent of root")));
                return;
            }
            newLocation = this.txn.addChild(workspace, newParent, node, beforeNode, request.desiredName());
        }
        assert (newParent != null);
        Location oldLocation = this.getActualLocation(workspace, request.from(), node);
        request.setActualLocations(oldLocation, newLocation);
        this.recordChange(request);
    }

    @Override
    public void process(UpdatePropertiesRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        WorkspaceType workspace = this.getWorkspace(request, request.inWorkspace());
        NodeType node = this.getTargetNode(workspace, request, request.on());
        if (node == null) {
            return;
        }
        LinkedList<Property> propertiesToSet = null;
        HashSet<Name> propertiesToRemove = null;
        for (Map.Entry<Name, Property> propertyEntry : request.properties().entrySet()) {
            Property property = propertyEntry.getValue();
            if (property == null) {
                if (propertiesToRemove == null) {
                    propertiesToRemove = new HashSet<Name>();
                }
                propertiesToRemove.add(propertyEntry.getKey());
                continue;
            }
            Name propName = property.getName();
            if (propName.equals(ModeShapeLexicon.UUID)) continue;
            if (node.getProperties().get(propName) == null) {
                request.setNewProperty(propName);
            }
            if (propertiesToSet == null) {
                propertiesToSet = new LinkedList<Property>();
            }
            propertiesToSet.add(property);
        }
        this.txn.setProperties(workspace, node, propertiesToSet, propertiesToRemove, request.removeOtherProperties());
        Location actualLocation = this.getActualLocation(workspace, request.on(), node);
        request.setActualLocationOfNode(actualLocation);
        this.recordChange(request);
    }

    @Override
    public void process(CreateWorkspaceRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        String clonedWorkspaceName = null;
        WorkspaceType workspace = this.repository.createWorkspace(this.txn, request.desiredNameOfNewWorkspace(), request.conflictBehavior(), clonedWorkspaceName);
        if (workspace == null) {
            String msg = GraphI18n.workspaceAlreadyExistsInRepository.text(request.desiredNameOfNewWorkspace(), this.repository.getSourceName());
            request.setError(new InvalidWorkspaceException(msg));
        } else {
            NodeType root = this.txn.getRootNode(workspace);
            request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), root.getUuid()));
            request.setActualWorkspaceName(workspace.getName());
            this.recordChange(request);
        }
    }

    @Override
    public void process(DestroyWorkspaceRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        WorkspaceType workspace = this.repository.getWorkspace(this.txn, request.workspaceName());
        if (workspace != null) {
            NodeType root = this.txn.getRootNode(workspace);
            try {
                this.txn.destroyWorkspace(workspace);
                request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), root.getUuid()));
                this.recordChange(request);
            }
            catch (RuntimeException e) {
                request.setError(e);
            }
        } else {
            String msg = GraphI18n.workspaceDoesNotExistInRepository.text(request.workspaceName(), this.repository.getSourceName());
            request.setError(new InvalidWorkspaceException(msg));
        }
    }

    @Override
    public void process(GetWorkspacesRequest request) {
        Set<String> names = this.txn.getWorkspaceNames();
        request.setAvailableWorkspaceNames(new HashSet<String>(names));
        this.setCacheableInfo(request);
    }

    @Override
    public void process(VerifyWorkspaceRequest request) {
        WorkspaceType original = this.getWorkspace(request, request.workspaceName());
        if (original != null) {
            Path path = this.getExecutionContext().getValueFactories().getPathFactory().createRootPath();
            NodeType root = this.txn.getRootNode(original);
            request.setActualRootLocation(Location.create(path, root.getUuid()));
            request.setActualWorkspaceName(original.getName());
        }
    }

    @Override
    public void process(CloneWorkspaceRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        String targetWorkspaceName = request.desiredNameOfTargetWorkspace();
        String nameOfWorkspaceToBeCloned = request.nameOfWorkspaceToBeCloned();
        WorkspaceType original = this.repository.getWorkspace(this.txn, nameOfWorkspaceToBeCloned);
        WorkspaceType target = this.repository.getWorkspace(this.txn, targetWorkspaceName);
        if (target != null) {
            String msg = GraphI18n.workspaceAlreadyExistsInRepository.text(targetWorkspaceName, this.repository.getSourceName());
            request.setError(new InvalidWorkspaceException(msg));
            return;
        }
        if (original == null) {
            switch (request.cloneConflictBehavior()) {
                case DO_NOT_CLONE: {
                    String msg = GraphI18n.workspaceDoesNotExistInRepository.text(nameOfWorkspaceToBeCloned, this.repository.getSourceName());
                    request.setError(new InvalidWorkspaceException(msg));
                    return;
                }
                case SKIP_CLONE: {
                    nameOfWorkspaceToBeCloned = null;
                }
            }
        }
        assert (original != null);
        target = this.repository.createWorkspace(this.txn, targetWorkspaceName, request.targetConflictBehavior(), nameOfWorkspaceToBeCloned);
        assert (target != null);
        NodeType root = this.txn.getRootNode(target);
        request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), root.getUuid()));
        request.setActualWorkspaceName(target.getName());
        this.recordChange(request);
    }

    @Override
    public void process(AccessQueryRequest request) {
        WorkspaceType workspace = this.getWorkspace(request, request.workspace());
        if (workspace == null) {
            return;
        }
        QueryResults results = this.txn.query(workspace, request);
        if (results != null) {
            request.setResults(results.getTuples(), results.getStatistics());
        } else {
            super.processUnknownRequest(request);
        }
    }

    @Override
    public void process(FullTextSearchRequest request) {
        WorkspaceType workspace = this.getWorkspace(request, request.workspace());
        if (workspace == null) {
            return;
        }
        QueryResults results = this.txn.search(workspace, request);
        if (results != null) {
            request.setResults(results.getColumns(), results.getTuples(), results.getStatistics());
        } else {
            super.processUnknownRequest(request);
        }
    }

    protected Location getActualLocation(WorkspaceType workspace, Location location, NodeType node) {
        Path path = this.txn.pathFor(workspace, node);
        if (location.hasIdProperties()) {
            return location.with(path);
        }
        return Location.create(path, node.getUuid());
    }

    protected WorkspaceType getWorkspace(Request request, String workspaceName) {
        WorkspaceType workspace = this.repository.getWorkspace(this.txn, workspaceName);
        if (workspace == null) {
            String msg = GraphI18n.workspaceDoesNotExistInRepository.text(workspaceName, this.repository.getSourceName());
            request.setError(new InvalidWorkspaceException(msg));
        }
        return workspace;
    }

    protected boolean updatesAllowed(Request request) {
        if (!this.updatesAllowed) {
            request.setError(new InvalidRequestException(GraphI18n.sourceIsReadOnly.text(this.getSourceName())));
        }
        return !request.hasError();
    }

    protected NodeType getTargetNode(WorkspaceType workspace, Request request, Location location) {
        if (workspace != null) {
            try {
                return this.txn.getNode(workspace, location);
            }
            catch (PathNotFoundException e) {
                request.setError(e);
            }
            catch (RuntimeException e) {
                request.setError(e);
            }
        }
        return null;
    }
}

