/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.LockFailedException;
import org.modeshape.graph.connector.UuidAlreadyExistsException;
import org.modeshape.graph.connector.base.Node;
import org.modeshape.graph.connector.base.Workspace;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.request.LockBranchRequest;

@NotThreadSafe
public interface Transaction<NodeType extends Node, WorkspaceType extends Workspace> {
    public ExecutionContext getContext();

    public Set<String> getWorkspaceNames();

    public WorkspaceType getWorkspace(String var1, WorkspaceType var2) throws InvalidWorkspaceException;

    public boolean destroyWorkspace(WorkspaceType var1) throws InvalidWorkspaceException;

    public NodeType getRootNode(WorkspaceType var1);

    public NodeType getNode(WorkspaceType var1, Location var2);

    public Path pathFor(WorkspaceType var1, NodeType var2);

    public NodeType getParent(WorkspaceType var1, NodeType var2);

    public NodeType getChild(WorkspaceType var1, NodeType var2, Path.Segment var3);

    public NodeType getFirstChild(WorkspaceType var1, NodeType var2, Name var3);

    public List<NodeType> getChildren(WorkspaceType var1, NodeType var2);

    public void removeAllChildren(WorkspaceType var1, NodeType var2);

    public NodeType addChild(WorkspaceType var1, NodeType var2, Name var3, int var4, UUID var5, Iterable<Property> var6);

    public Location addChild(WorkspaceType var1, NodeType var2, NodeType var3, NodeType var4, Name var5);

    public Location removeNode(WorkspaceType var1, NodeType var2);

    public NodeType setProperties(WorkspaceType var1, NodeType var2, Iterable<Property> var3, Iterable<Name> var4, boolean var5);

    public NodeType removeProperty(WorkspaceType var1, NodeType var2, Name var3);

    public NodeType cloneNode(WorkspaceType var1, NodeType var2, WorkspaceType var3, NodeType var4, Name var5, Path.Segment var6, boolean var7, Set<Location> var8) throws UuidAlreadyExistsException;

    public NodeType copyNode(WorkspaceType var1, NodeType var2, WorkspaceType var3, NodeType var4, Name var5, boolean var6);

    public QueryResults query(WorkspaceType var1, AccessQueryRequest var2);

    public QueryResults search(WorkspaceType var1, FullTextSearchRequest var2);

    public void lockNode(WorkspaceType var1, NodeType var2, LockBranchRequest.LockScope var3, long var4) throws LockFailedException;

    public void unlockNode(WorkspaceType var1, NodeType var2);

    public void commit();

    public void rollback();
}

