/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.observe;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.Location;
import org.modeshape.graph.observe.ChangeObserver;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.CloneBranchRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.DeleteChildrenRequest;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.RemovePropertyRequest;
import org.modeshape.graph.request.RenameNodeRequest;
import org.modeshape.graph.request.SetPropertyRequest;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.UpdateValuesRequest;

@ThreadSafe
public abstract class NetChangeObserver
extends ChangeObserver {
    protected NetChangeObserver() {
    }

    @Override
    public void notify(Changes changes) {
        ChangeContext changeContext = new ChangeContext();
        block18: for (ChangeRequest change : changes.getChangeRequests()) {
            Location location = change.changedLocation();
            assert (location.getPath() != null);
            String workspace = change.changedWorkspace();
            NetChangeDetails details = null;
            switch (change.getType()) {
                case CREATE_NODE: {
                    CreateNodeRequest create = (CreateNodeRequest)change;
                    details = changeContext.detailsFor(workspace, location);
                    details.addEventType(ChangeType.NODE_ADDED);
                    for (Property property : create) {
                        details.addProperty(property);
                    }
                    continue block18;
                }
                case UPDATE_PROPERTIES: {
                    UpdatePropertiesRequest update = (UpdatePropertiesRequest)change;
                    details = changeContext.detailsFor(workspace, location);
                    for (Map.Entry<Name, Property> entry : update.properties().entrySet()) {
                        Name propName = entry.getKey();
                        Property property = entry.getValue();
                        if (property != null) {
                            if (update.isNewProperty(propName)) {
                                details.addProperty(property);
                                continue;
                            }
                            details.changeProperty(property);
                            continue;
                        }
                        details.removeProperty(propName);
                    }
                    continue block18;
                }
                case SET_PROPERTY: {
                    SetPropertyRequest set = (SetPropertyRequest)change;
                    details = changeContext.detailsFor(workspace, location);
                    if (set.isNewProperty()) {
                        details.addProperty(set.property());
                        break;
                    }
                    details.changeProperty(set.property());
                    break;
                }
                case REMOVE_PROPERTY: {
                    RemovePropertyRequest remove = (RemovePropertyRequest)change;
                    details = changeContext.detailsFor(workspace, location);
                    details.removeProperty(remove.propertyName());
                    break;
                }
                case DELETE_BRANCH: {
                    details = changeContext.detailsFor(workspace, location);
                    if (details.getEventTypes().contains((Object)ChangeType.NODE_ADDED)) {
                        changeContext.delete(workspace, location);
                        break;
                    }
                    details.addEventType(ChangeType.NODE_REMOVED);
                    break;
                }
                case DELETE_CHILDREN: {
                    DeleteChildrenRequest delete = (DeleteChildrenRequest)change;
                    for (Location deletedChild : delete.getActualChildrenDeleted()) {
                        NetChangeDetails childDetails = changeContext.detailsFor(workspace, deletedChild);
                        if (childDetails.getEventTypes().contains((Object)ChangeType.NODE_ADDED)) {
                            changeContext.delete(workspace, deletedChild);
                            continue;
                        }
                        childDetails.addEventType(ChangeType.NODE_REMOVED);
                    }
                    continue block18;
                }
                case LOCK_BRANCH: {
                    details = changeContext.detailsFor(workspace, location);
                    details.setLockAction(LockAction.LOCKED);
                    break;
                }
                case UNLOCK_BRANCH: {
                    details = changeContext.detailsFor(workspace, location);
                    details.setLockAction(LockAction.UNLOCKED);
                    break;
                }
                case COPY_BRANCH: {
                    details = changeContext.detailsFor(workspace, location);
                    details.addEventType(ChangeType.NODE_ADDED);
                    break;
                }
                case CLONE_BRANCH: {
                    CloneBranchRequest cloneRequest = (CloneBranchRequest)change;
                    for (Location removed : cloneRequest.getRemovedNodes()) {
                        NetChangeDetails removedDetails = changeContext.detailsFor(workspace, removed);
                        removedDetails.addEventType(ChangeType.NODE_REMOVED);
                    }
                    details = changeContext.detailsFor(workspace, location);
                    details.addEventType(ChangeType.NODE_ADDED);
                    break;
                }
                case MOVE_BRANCH: {
                    MoveBranchRequest move = (MoveBranchRequest)change;
                    Location original = move.getActualLocationBefore();
                    Location before = move.before();
                    boolean isReorder = move.desiredName() == null;
                    changeContext.move(workspace, original, location, before, isReorder);
                    break;
                }
                case RENAME_NODE: {
                    Location original = ((RenameNodeRequest)change).getActualLocationBefore();
                    changeContext.move(workspace, original, location, null, false);
                    break;
                }
                case UPDATE_VALUES: {
                    UpdateValuesRequest updateValuesRequest = (UpdateValuesRequest)change;
                    details = changeContext.detailsFor(workspace, location);
                    if (!updateValuesRequest.addedValues().isEmpty() || !updateValuesRequest.removedValues().isEmpty()) {
                        assert (updateValuesRequest.getActualProperty() != null);
                        if (updateValuesRequest.isNewProperty()) {
                            details.addEventType(ChangeType.PROPERTY_ADDED);
                            details.addProperty(updateValuesRequest.getActualProperty());
                            break;
                        }
                        details.addEventType(ChangeType.PROPERTY_CHANGED);
                        details.changeProperty(updateValuesRequest.getActualProperty());
                        break;
                    }
                    if (!details.getEventTypes().isEmpty()) break;
                    changeContext.delete(workspace, location);
                    break;
                }
                case CREATE_WORKSPACE: {
                    details = changeContext.detailsFor(workspace, location);
                    details.addEventType(ChangeType.NODE_ADDED);
                    break;
                }
                case DESTROY_WORKSPACE: {
                    details = changeContext.detailsFor(workspace, location);
                    details.addEventType(ChangeType.NODE_REMOVED);
                    break;
                }
                case CLONE_WORKSPACE: {
                    details = changeContext.detailsFor(workspace, location);
                    details.addEventType(ChangeType.NODE_ADDED);
                    break;
                }
            }
        }
        List<NetChange> netChanges = changeContext.getNetChanges();
        this.notify(new NetChanges(changes, netChanges));
    }

    protected abstract void notify(NetChanges var1);

    @NotThreadSafe
    private static class NetChangeDetails {
        private final Set<Property> modifiedProperties = new HashSet<Property>();
        private final Set<Property> addedProperties = new HashSet<Property>();
        private final Set<Name> removedProperties = new HashSet<Name>();
        private EnumSet<ChangeType> eventTypes = EnumSet.noneOf(ChangeType.class);
        private Location movedFrom;
        private Location movedBefore;
        private boolean reorder;
        private NetChangeDetails nextChanges;

        protected NetChangeDetails() {
        }

        public void setLockAction(LockAction lockAction) {
            switch (lockAction) {
                case LOCKED: {
                    this.eventTypes.add(ChangeType.NODE_LOCKED);
                    this.eventTypes.remove((Object)ChangeType.NODE_UNLOCKED);
                    break;
                }
                case UNLOCKED: {
                    if (this.eventTypes.remove((Object)ChangeType.NODE_LOCKED)) break;
                    this.eventTypes.add(ChangeType.NODE_UNLOCKED);
                }
            }
        }

        public void setNextChanges(NetChangeDetails details) {
            this.nextChanges = details;
        }

        public NetChangeDetails next() {
            return this.nextChanges;
        }

        public NetChangeDetails latest() {
            return this.nextChanges != null ? this.nextChanges.latest() : this;
        }

        public void movedFrom(Location originalLocation) {
            this.eventTypes.add(ChangeType.NODE_MOVED);
            this.movedFrom = originalLocation;
        }

        public void movedBefore(Location before, boolean isReorder) {
            this.eventTypes.add(ChangeType.NODE_MOVED);
            this.movedBefore = before;
            this.reorder = isReorder;
        }

        public void addEventType(ChangeType eventType) {
            this.eventTypes.add(eventType);
        }

        public void addProperty(Property property) {
            this.addedProperties.add(property);
            this.eventTypes.add(ChangeType.PROPERTY_ADDED);
        }

        public void changeProperty(Property property) {
            if (!this.addedProperties.contains(property)) {
                this.modifiedProperties.add(property);
                this.eventTypes.add(ChangeType.PROPERTY_CHANGED);
            }
        }

        public void removeProperty(Name propertyName) {
            boolean handled = false;
            for (Property property : this.addedProperties) {
                if (!property.getName().equals(propertyName)) continue;
                handled = true;
                this.addedProperties.remove(property);
                if (!this.addedProperties.isEmpty()) break;
                this.eventTypes.remove((Object)ChangeType.PROPERTY_ADDED);
                break;
            }
            if (!handled) {
                for (Property property : this.modifiedProperties) {
                    if (!property.getName().equals(propertyName)) continue;
                    this.modifiedProperties.remove(property);
                    if (!this.modifiedProperties.isEmpty()) break;
                    this.eventTypes.remove((Object)ChangeType.PROPERTY_CHANGED);
                    break;
                }
                this.removedProperties.add(propertyName);
                this.eventTypes.add(ChangeType.PROPERTY_REMOVED);
            }
        }

        public EnumSet<ChangeType> getEventTypes() {
            return this.eventTypes;
        }

        public Set<Property> getAddedProperties() {
            return this.addedProperties;
        }

        public Set<Property> getModifiedProperties() {
            return this.modifiedProperties;
        }

        public Set<Name> getRemovedProperties() {
            return this.removedProperties;
        }

        public Location getMovedFrom() {
            return this.movedFrom;
        }

        public Location getMovedBefore() {
            return this.movedBefore;
        }

        public boolean isReorder() {
            return this.reorder;
        }
    }

    private static enum LockAction {
        LOCKED,
        UNLOCKED;

    }

    @Immutable
    public static final class NetChange {
        private final String workspaceName;
        private final Location location;
        private final EnumSet<ChangeType> eventTypes;
        private final Set<Property> addedProperties;
        private final Set<Property> modifiedProperties;
        private final Set<Property> addedOrModifiedProperties;
        private final Set<Name> removedProperties;
        private final int hc;
        private final Location movedFrom;
        private final Location movedBefore;
        private final boolean isReorder;

        public NetChange(String workspaceName, Location location, EnumSet<ChangeType> eventTypes, Set<Property> addedProperties, Set<Property> modifiedProperties, Set<Name> removedProperties, Location movedFrom, Location movedBefore, boolean isReorder) {
            assert (workspaceName != null);
            assert (location != null);
            this.workspaceName = workspaceName;
            this.location = location;
            this.hc = HashCode.compute(this.workspaceName, this.location);
            this.eventTypes = eventTypes;
            Set<Property> addedOrModified = null;
            if (addedProperties == null) {
                addedProperties = Collections.emptySet();
                addedOrModified = modifiedProperties;
            } else {
                addedOrModified = addedProperties;
            }
            if (modifiedProperties == null) {
                if (addedOrModified == null) {
                    addedOrModified = Collections.emptySet();
                }
                modifiedProperties = Collections.emptySet();
            } else if (addedOrModified == null) {
                addedOrModified = modifiedProperties;
            } else {
                addedOrModified = new HashSet<Property>(modifiedProperties);
                addedOrModified.addAll(addedProperties);
            }
            if (removedProperties == null) {
                removedProperties = Collections.emptySet();
            }
            this.addedProperties = Collections.unmodifiableSet(addedProperties);
            this.modifiedProperties = Collections.unmodifiableSet(modifiedProperties);
            this.removedProperties = Collections.unmodifiableSet(removedProperties);
            this.addedOrModifiedProperties = Collections.unmodifiableSet(addedOrModified);
            this.movedFrom = movedFrom;
            this.movedBefore = movedBefore;
            this.isReorder = isReorder;
        }

        public Location getLocation() {
            return this.location;
        }

        public Location getOriginalLocation() {
            return this.movedFrom;
        }

        public Location getMovedBefore() {
            return this.movedBefore;
        }

        public boolean isReorder() {
            return this.isReorder;
        }

        public Path getPath() {
            return this.location.getPath();
        }

        public String getRepositoryWorkspaceName() {
            return this.workspaceName;
        }

        public Set<Property> getAddedProperties() {
            return this.addedProperties;
        }

        public Set<Property> getModifiedProperties() {
            return this.modifiedProperties;
        }

        public Set<Property> getAddedOrModifiedProperties() {
            return this.addedOrModifiedProperties;
        }

        public Set<Name> getRemovedProperties() {
            return this.removedProperties;
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean includesAllOf(ChangeType ... jcrEventTypes) {
            for (ChangeType jcrEventType : jcrEventTypes) {
                if (this.eventTypes.contains((Object)jcrEventType)) continue;
                return false;
            }
            return true;
        }

        public boolean includes(ChangeType ... jcrEventTypes) {
            for (ChangeType jcrEventType : jcrEventTypes) {
                if (!this.eventTypes.contains((Object)jcrEventType)) continue;
                return true;
            }
            return false;
        }

        public boolean isSameNode(NetChange that) {
            if (that == this) {
                return true;
            }
            if (this.hc != that.hc) {
                return false;
            }
            if (!this.workspaceName.equals(that.workspaceName)) {
                return false;
            }
            return this.location.isSame(that.location);
        }

        public boolean isPropertyModified(String property) {
            return this.modifiedProperties.contains(property);
        }

        public boolean isPropertyRemoved(String property) {
            return this.removedProperties.contains(property);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof NetChange) {
                NetChange that = (NetChange)obj;
                if (!this.isSameNode(that)) {
                    return false;
                }
                return this.eventTypes == that.eventTypes;
            }
            return false;
        }

        public String toString() {
            return this.workspaceName + "=>" + this.location;
        }
    }

    @Immutable
    public static final class NetChanges
    extends Changes {
        private static final long serialVersionUID = 1L;
        private final List<NetChange> netChanges;

        public NetChanges(Changes changes, List<NetChange> netChanges) {
            super(changes);
            assert (netChanges != null);
            assert (!netChanges.isEmpty());
            this.netChanges = Collections.unmodifiableList(netChanges);
        }

        public List<NetChange> getNetChanges() {
            return this.netChanges;
        }

        @Override
        public String toString() {
            if (this.processId.length() != 0) {
                return this.getTimestamp() + " @" + this.getUserName() + " [" + this.getSourceName() + "] - " + this.netChanges.size() + " changes";
            }
            return this.getTimestamp() + " @" + this.getUserName() + " #" + this.getProcessId() + " [" + this.getSourceName() + "] - " + this.netChanges.size() + " changes";
        }
    }

    public static enum ChangeType {
        NODE_ADDED,
        NODE_MOVED,
        NODE_REMOVED,
        PROPERTY_ADDED,
        PROPERTY_REMOVED,
        PROPERTY_CHANGED,
        NODE_LOCKED,
        NODE_UNLOCKED;

    }

    protected class ChangeContext {
        private final Map<String, Map<Location, NetChangeDetails>> detailsByLocationByWorkspace = new HashMap<String, Map<Location, NetChangeDetails>>();

        protected ChangeContext() {
        }

        public void delete(String workspace, Location location) {
            Map<Location, NetChangeDetails> detailsByLocation = this.detailsByLocationByWorkspace.get(workspace);
            assert (detailsByLocation != null);
            detailsByLocation.remove(location);
        }

        public NetChangeDetails detailsFor(String workspace, Location location) {
            Map<Location, NetChangeDetails> detailsByLocation = this.detailsByLocationByWorkspace.get(workspace);
            NetChangeDetails details = null;
            if (detailsByLocation == null) {
                detailsByLocation = new TreeMap<Location, NetChangeDetails>();
                this.detailsByLocationByWorkspace.put(workspace, detailsByLocation);
                details = new NetChangeDetails();
                detailsByLocation.put(location, details);
            } else {
                details = detailsByLocation.get(location);
                if (details == null) {
                    details = new NetChangeDetails();
                    detailsByLocation.put(location, details);
                } else {
                    details = details.latest();
                }
            }
            return details;
        }

        public void move(String workspace, Location fromLocation, Location toLocation, Location before, boolean isReorder) {
            if (fromLocation.equals(toLocation) && before == null) {
                return;
            }
            Map<Location, NetChangeDetails> detailsByLocation = this.detailsByLocationByWorkspace.get(workspace);
            if (detailsByLocation == null) {
                detailsByLocation = new TreeMap<Location, NetChangeDetails>();
                this.detailsByLocationByWorkspace.put(workspace, detailsByLocation);
            }
            NetChangeDetails existingBefore = detailsByLocation.get(toLocation);
            NetChangeDetails from = detailsByLocation.remove(fromLocation);
            NetChangeDetails after = from != null ? from : new NetChangeDetails();
            after.movedFrom(fromLocation);
            if (isReorder) {
                after.movedBefore(before, isReorder);
            }
            if (existingBefore != null) {
                existingBefore.setNextChanges(after);
            } else {
                detailsByLocation.put(toLocation, after);
            }
        }

        public List<NetChange> getNetChanges() {
            LinkedList<NetChange> netChanges = new LinkedList<NetChange>();
            for (Map.Entry<String, Map<Location, NetChangeDetails>> byWorkspaceEntry : this.detailsByLocationByWorkspace.entrySet()) {
                String workspaceName = byWorkspaceEntry.getKey();
                for (Map.Entry<Location, NetChangeDetails> entry : byWorkspaceEntry.getValue().entrySet()) {
                    Location location = entry.getKey();
                    for (NetChangeDetails details = entry.getValue(); details != null; details = details.next()) {
                        netChanges.add(new NetChange(workspaceName, location, details.getEventTypes(), details.getAddedProperties(), details.getModifiedProperties(), details.getRemovedProperties(), details.getMovedFrom(), details.getMovedBefore(), details.isReorder()));
                    }
                }
            }
            return netChanges;
        }
    }
}

