/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.IoException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.AbstractValueFactory;
import org.modeshape.graph.property.basic.StringReference;
import org.modeshape.graph.property.basic.UuidReference;

@Immutable
public class ReferenceValueFactory
extends AbstractValueFactory<Reference> {
    public ReferenceValueFactory(TextDecoder decoder, ValueFactory<String> stringValueFactory) {
        super(PropertyType.REFERENCE, decoder, stringValueFactory);
    }

    @Override
    public Reference create(String value) {
        if (value == null) {
            return null;
        }
        try {
            UUID uuid = UUID.fromString(value);
            return new UuidReference(uuid);
        }
        catch (IllegalArgumentException err) {
            return new StringReference(value);
        }
    }

    @Override
    public Reference create(String value, TextDecoder decoder) {
        return this.create(this.getDecoder(decoder).decode(value));
    }

    @Override
    public Reference create(int value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Integer.class.getSimpleName(), value));
    }

    @Override
    public Reference create(long value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Long.class.getSimpleName(), value));
    }

    @Override
    public Reference create(boolean value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Boolean.class.getSimpleName(), value));
    }

    @Override
    public Reference create(float value) {
        throw new ValueFormatException((Object)Float.valueOf(value), this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Float.class.getSimpleName(), Float.valueOf(value)));
    }

    @Override
    public Reference create(double value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Double.class.getSimpleName(), value));
    }

    @Override
    public Reference create(BigDecimal value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), BigDecimal.class.getSimpleName(), value));
    }

    @Override
    public Reference create(Calendar value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Calendar.class.getSimpleName(), value));
    }

    @Override
    public Reference create(Date value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Date.class.getSimpleName(), value));
    }

    @Override
    public Reference create(DateTime value) throws ValueFormatException {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), DateTime.class.getSimpleName(), value));
    }

    @Override
    public Reference create(Name value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Name.class.getSimpleName(), value));
    }

    @Override
    public Reference create(Path value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Path.class.getSimpleName(), value));
    }

    @Override
    public Reference create(Path.Segment value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Path.Segment.class.getSimpleName(), value));
    }

    @Override
    public Reference create(Reference value) {
        return value;
    }

    @Override
    public Reference create(UUID value) {
        if (value == null) {
            return null;
        }
        return new UuidReference(value);
    }

    @Override
    public Reference create(URI value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Date.class.getSimpleName(), value));
    }

    @Override
    public Reference create(byte[] value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Reference create(Binary value) throws ValueFormatException, IoException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Reference create(InputStream stream, long approximateLength) throws IoException {
        return this.create(this.getStringValueFactory().create(stream, approximateLength));
    }

    @Override
    public Reference create(Reader reader, long approximateLength) throws IoException {
        return this.create(this.getStringValueFactory().create(reader, approximateLength));
    }

    protected Reference[] createEmptyArray(int length) {
        return new Reference[length];
    }
}

