/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.CacheableRequest;
import org.modeshape.graph.request.RequestType;

public class ReadAllPropertiesRequest
extends CacheableRequest
implements Iterable<Property> {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN_NUMBER_OF_CHILDREN = -1;
    private final Location at;
    private final String workspaceName;
    private final Map<Name, Property> properties = new HashMap<Name, Property>();
    private int numberOfChildren = -1;
    private Location actualLocation;

    public ReadAllPropertiesRequest(Location at, String workspaceName) {
        CheckArg.isNotNull(at, "at");
        CheckArg.isNotNull(workspaceName, "workspaceName");
        this.workspaceName = workspaceName;
        this.at = at;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public Location at() {
        return this.at;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public Map<Name, Property> getPropertiesByName() {
        return this.properties;
    }

    public Collection<Property> getProperties() {
        return this.properties.values();
    }

    @Override
    public Iterator<Property> iterator() {
        return this.getProperties().iterator();
    }

    public Property addProperty(Property property) {
        this.checkNotFrozen();
        return this.properties.put(property.getName(), property);
    }

    public void addProperties(Property ... properties) {
        this.checkNotFrozen();
        for (Property property : properties) {
            this.properties.put(property.getName(), property);
        }
    }

    public void addProperties(Iterable<Property> properties) {
        this.checkNotFrozen();
        for (Property property : properties) {
            this.properties.put(property.getName(), property);
        }
    }

    public int getNumberOfChildren() {
        return this.numberOfChildren;
    }

    public void setNumberOfChildren(int numberOfChildren) {
        this.checkNotFrozen();
        CheckArg.isNonNegative(numberOfChildren, "numberOfChildren");
        this.numberOfChildren = numberOfChildren;
    }

    public void setActualLocationOfNode(Location actual) {
        this.checkNotFrozen();
        CheckArg.isNotNull(actual, "actual");
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(actual));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualLocation = null;
    }

    public int hashCode() {
        return HashCode.compute(this.at, this.workspaceName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            ReadAllPropertiesRequest that = (ReadAllPropertiesRequest)obj;
            if (!this.at().isSame(that.at())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public String toString() {
        return "read properties of " + this.at() + " in the \"" + this.workspaceName + "\" workspace";
    }

    @Override
    public RequestType getType() {
        return RequestType.READ_ALL_PROPERTIES;
    }
}

