/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.LinkedList;
import java.util.List;
import org.modeshape.common.text.Inflector;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.CacheableRequest;
import org.modeshape.graph.request.RequestType;

public class ReadBlockOfChildrenRequest
extends CacheableRequest {
    public static final int INDEX_NOT_USED = -1;
    private static final long serialVersionUID = 1L;
    private final Location of;
    private final String workspaceName;
    private final List<Location> children = new LinkedList<Location>();
    private final int startingAtIndex;
    private final int count;
    private Location actualLocation;

    public ReadBlockOfChildrenRequest(Location of, String workspaceName, int startingIndex, int count) {
        CheckArg.isNotNull(of, "of");
        CheckArg.isNonNegative(startingIndex, "startingIndex");
        CheckArg.isPositive(count, "count");
        CheckArg.isNotNull(workspaceName, "workspaceName");
        this.workspaceName = workspaceName;
        this.of = of;
        this.startingAtIndex = startingIndex;
        this.count = count;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public Location of() {
        return this.of;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public int count() {
        return this.count;
    }

    public int startingAtIndex() {
        return this.startingAtIndex;
    }

    public int endingBefore() {
        return this.startingAtIndex + this.count;
    }

    public List<Location> getChildren() {
        return this.children;
    }

    public void addChildren(Iterable<Location> children) {
        this.checkNotFrozen();
        CheckArg.isNotNull(children, "children");
        for (Location child : children) {
            if (child == null) continue;
            this.children.add(child);
        }
    }

    public void addChild(Location child) {
        this.checkNotFrozen();
        CheckArg.isNotNull(child, "child");
        this.children.add(child);
    }

    public void addChild(Path pathToChild, Property firstIdProperty, Property ... remainingIdProperties) {
        this.checkNotFrozen();
        Location child = Location.create(pathToChild, firstIdProperty, remainingIdProperties);
        this.children.add(child);
    }

    public void addChild(Path pathToChild, Property idProperty) {
        this.checkNotFrozen();
        Location child = Location.create(pathToChild, idProperty);
        this.children.add(child);
    }

    public void setActualLocationOfNode(Location actual) {
        this.checkNotFrozen();
        CheckArg.isNotNull(actual, "actual");
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(actual));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualLocation = null;
        this.children.clear();
    }

    public int hashCode() {
        return HashCode.compute(this.of, this.workspaceName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            ReadBlockOfChildrenRequest that = (ReadBlockOfChildrenRequest)obj;
            if (!this.of().isSame(that.of())) {
                return false;
            }
            if (this.startingAtIndex() != that.startingAtIndex()) {
                return false;
            }
            if (this.count() != that.count()) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public String toString() {
        Inflector inflector = Inflector.getInstance();
        if (this.count() == 1) {
            return "read " + inflector.ordinalize(this.startingAtIndex()) + " thru " + inflector.ordinalize(this.endingBefore() - 1) + " children of " + this.of() + " in the \"" + this.workspaceName + "\" workspace";
        }
        return "read " + inflector.ordinalize(this.startingAtIndex()) + " child of " + this.of() + " in the \"" + this.workspaceName + "\" workspace";
    }

    @Override
    public RequestType getType() {
        return RequestType.READ_BLOCK_OF_CHILDREN;
    }
}

