/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import org.modeshape.jcr.SelfClosingInputStream;
import org.modeshape.jcr.api.Binary;

class JcrBinary
implements javax.jcr.Binary,
Binary {
    private final org.modeshape.graph.property.Binary binary;

    JcrBinary(org.modeshape.graph.property.Binary binary) {
        this.binary = binary;
        assert (this.binary != null);
    }

    org.modeshape.graph.property.Binary binary() {
        return this.binary;
    }

    @Override
    public void dispose() {
        this.binary.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        try {
            this.binary.acquire();
            long l = this.binary.getSize();
            return l;
        }
        finally {
            this.binary.release();
        }
    }

    @Override
    public InputStream getStream() {
        return new SelfClosingInputStream(this.binary);
    }

    @Override
    public int read(byte[] b, long position) throws IOException {
        if (this.getSize() <= position) {
            return -1;
        }
        InputStream stream = null;
        IOException error = null;
        try {
            long skipped;
            stream = this.getStream();
            for (long skip = position; skip > 0L; skip -= skipped) {
                skipped = stream.skip(skip);
                if (skipped > 0L) continue;
                int n = -1;
                return n;
            }
            int n = stream.read(b);
            return n;
        }
        catch (IOException e) {
            error = e;
            throw e;
        }
        finally {
            block19: {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (RuntimeException t) {
                        if (error == null) {
                            throw t;
                        }
                    }
                    catch (IOException t) {
                        if (error != null) break block19;
                        throw t;
                    }
                }
            }
        }
    }
}

