/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.AbstractJcrNode;

@Immutable
final class JcrChildNodeIterator
implements NodeIterator {
    private final Iterator<AbstractJcrNode> iterator;
    private int ndx;
    private int size;

    JcrChildNodeIterator(Iterable<AbstractJcrNode> children, int size) {
        assert (children != null);
        this.iterator = children.iterator();
        this.size = size;
    }

    @Override
    public long getPosition() {
        return this.ndx;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        return this.nextNode();
    }

    @Override
    public Node nextNode() {
        AbstractJcrNode child = this.iterator.next();
        ++this.ndx;
        return child;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void skip(long count) {
        CheckArg.isNonNegative(count, "count");
        while (--count >= 0L) {
            this.nextNode();
        }
    }
}

