/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeType;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.jcr.JcrNodeType;

@Immutable
class JcrItemDefinition
implements ItemDefinition {
    protected final ExecutionContext context;
    protected final JcrNodeType declaringNodeType;
    protected final Name name;
    private final int onParentVersion;
    private final boolean autoCreated;
    private final boolean mandatory;
    private final boolean protectedItem;

    JcrItemDefinition(ExecutionContext context, JcrNodeType declaringNodeType, Name name, int onParentVersion, boolean autoCreated, boolean mandatory, boolean protectedItem) {
        this.context = context;
        this.declaringNodeType = declaringNodeType;
        this.name = name != null ? name : (Name)context.getValueFactories().getNameFactory().create("*");
        this.onParentVersion = onParentVersion;
        this.autoCreated = autoCreated;
        this.mandatory = mandatory;
        this.protectedItem = protectedItem;
    }

    final Name getInternalName() {
        return this.name;
    }

    public boolean isResidual() {
        return this.name.getLocalName().equals("*");
    }

    @Override
    public NodeType getDeclaringNodeType() {
        return this.declaringNodeType;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return "*";
        }
        return this.name.getString(this.context.getNamespaceRegistry());
    }

    @Override
    public int getOnParentVersion() {
        return this.onParentVersion;
    }

    @Override
    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public boolean isProtected() {
        return this.protectedItem;
    }
}

