/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.graph.Location;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.SessionCache;

@NotThreadSafe
class JcrNode
extends AbstractJcrNode {
    JcrNode(SessionCache cache, GraphSession.NodeId nodeId, Location location) {
        super(cache, nodeId, location);
    }

    @Override
    final boolean isRoot() {
        return false;
    }

    @Override
    public int getIndex() throws RepositoryException {
        return this.segment().getIndex();
    }

    @Override
    public String getName() throws RepositoryException {
        return this.segment().getName().getString(this.namespaces());
    }

    @Override
    public AbstractJcrNode getParent() throws ItemNotFoundException, RepositoryException {
        this.checkSession();
        return this.parentNodeInfo().getPayload().getJcrNode();
    }

    @Override
    public String getPath() throws RepositoryException {
        return this.path().getString(this.namespaces());
    }

    @Override
    protected void doRemove() throws RepositoryException, LockException {
        Lock parentLock;
        AbstractJcrNode parentNode = this.getParent();
        if (parentNode.isLocked() && (parentLock = this.lockManager().getLock(this)) != null && !parentLock.isLockOwningSession()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(this.location));
        }
        if (!parentNode.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(parentNode.getPath()));
        }
        JcrNodeDefinition nodeDefn = this.cache.nodeTypes().getNodeDefinition(this.nodeInfo().getPayload().getDefinitionId());
        if (nodeDefn.isProtected()) {
            throw new ConstraintViolationException(JcrI18n.cannotRemoveItemWithProtectedDefinition.text(this.getPath()));
        }
        this.session().recordRemoval(this.locationToDestroy());
        this.doDestroy();
    }

    protected Location locationToDestroy() {
        return this.location;
    }

    protected void doDestroy() throws AccessDeniedException, RepositoryException {
        this.editor().destroy();
    }
}

