/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.AbstractJcrNode;

class JcrNodeIterator
implements NodeIterator {
    private final long size;
    private final AbstractJcrNode firstNode;
    private final NodeIterator nextNodes;
    private boolean visitedFirst = false;

    protected JcrNodeIterator(AbstractJcrNode firstNode, NodeIterator nextNodes) {
        assert (firstNode != null);
        assert (nextNodes != null);
        this.firstNode = firstNode;
        this.nextNodes = nextNodes;
        this.size = 1L + nextNodes.getSize();
    }

    @Override
    public Node nextNode() {
        if (!this.visitedFirst) {
            this.visitedFirst = true;
            return this.firstNode;
        }
        return this.nextNodes.nextNode();
    }

    @Override
    public long getPosition() {
        return this.visitedFirst ? this.nextNodes.getPosition() + 1L : 0L;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void skip(long skipNum) {
        CheckArg.isNonNegative(skipNum, "skipNum");
        if (skipNum == 0L) {
            return;
        }
        if (this.visitedFirst) {
            this.nextNodes.skip(skipNum);
        }
        this.visitedFirst = true;
        this.nextNodes.skip(skipNum - 1L);
    }

    @Override
    public boolean hasNext() {
        return this.visitedFirst ? this.nextNodes.hasNext() : true;
    }

    public Object next() {
        return this.nextNode();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

