/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.UUID;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrBinary;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.SelfClosingInputStream;
import org.modeshape.jcr.SessionCache;

@NotThreadSafe
final class JcrSingleValueProperty
extends AbstractJcrProperty {
    JcrSingleValueProperty(SessionCache cache, AbstractJcrNode node, Name name) {
        super(cache, node, name);
    }

    @Override
    public boolean isMultiple() {
        return false;
    }

    @Override
    public boolean getBoolean() throws RepositoryException {
        this.checkSession();
        try {
            return this.context().getValueFactories().getBooleanFactory().create(this.property().getFirstValue());
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), e);
        }
    }

    @Override
    public Calendar getDate() throws RepositoryException {
        this.checkSession();
        try {
            return ((DateTime)this.context().getValueFactories().getDateFactory().create(this.property().getFirstValue())).toCalendar();
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), e);
        }
    }

    @Override
    public double getDouble() throws RepositoryException {
        this.checkSession();
        try {
            return this.context().getValueFactories().getDoubleFactory().create(this.property().getFirstValue());
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), e);
        }
    }

    @Override
    public BigDecimal getDecimal() throws javax.jcr.ValueFormatException, RepositoryException {
        this.checkSession();
        try {
            return this.context().getValueFactories().getDecimalFactory().create(this.property().getFirstValue());
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), e);
        }
    }

    @Override
    public long getLength() throws RepositoryException {
        this.checkSession();
        return this.createValue(this.property().getFirstValue()).getLength();
    }

    @Override
    public long[] getLengths() throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForSingleValuedProperty.text(new Object[0]));
    }

    @Override
    public long getLong() throws RepositoryException {
        this.checkSession();
        try {
            return this.context().getValueFactories().getLongFactory().create(this.property().getFirstValue());
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), e);
        }
    }

    @Override
    public final Node getNode() throws ItemNotFoundException, javax.jcr.ValueFormatException, RepositoryException {
        this.checkSession();
        ValueFactories factories = this.context().getValueFactories();
        Object value = this.property().getFirstValue();
        try {
            UUID uuid = (UUID)factories.getUuidFactory().create(value);
            return this.session().getNodeByIdentifier(uuid.toString());
        }
        catch (ValueFormatException e) {
            try {
                Path path = (Path)factories.getPathFactory().create(value);
                return path.isAbsolute() ? this.session().getNode(path) : this.getParent().getNode(path);
            }
            catch (ValueFormatException e2) {
                throw new javax.jcr.ValueFormatException(e2.getMessage(), e2);
            }
        }
    }

    @Override
    public Property getProperty() throws ItemNotFoundException, javax.jcr.ValueFormatException, RepositoryException {
        this.checkSession();
        Path path = null;
        try {
            path = (Path)this.context().getValueFactories().getPathFactory().create(this.property().getFirstValue());
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), e);
        }
        AbstractJcrNode referencedNode = null;
        Path nodePath = path.getParent();
        referencedNode = path.isAbsolute() ? this.cache.findJcrNode(Location.create(nodePath)) : this.cache.findJcrNode(this.node.internalId(), this.node.path(), nodePath);
        Name propertyName = path.getLastSegment().getName();
        if (!referencedNode.hasProperty(propertyName)) {
            String readablePath = path.getString(this.namespaces());
            String workspaceName = this.session().workspace().getName();
            String msg = null;
            msg = path.isAbsolute() ? JcrI18n.pathNotFound.text(readablePath, workspaceName) : JcrI18n.pathNotFoundRelativeTo.text(readablePath, this.node.getPath(), workspaceName);
            throw new PathNotFoundException(msg);
        }
        return referencedNode.getProperty(propertyName);
    }

    @Override
    public InputStream getStream() throws RepositoryException {
        this.checkSession();
        try {
            Binary binary = (Binary)this.context().getValueFactories().getBinaryFactory().create(this.property().getFirstValue());
            return new SelfClosingInputStream(binary);
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), e);
        }
    }

    @Override
    public javax.jcr.Binary getBinary() throws javax.jcr.ValueFormatException, RepositoryException {
        this.checkSession();
        try {
            Binary binary = (Binary)this.context().getValueFactories().getBinaryFactory().create(this.property().getFirstValue());
            return new JcrBinary(binary);
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), e);
        }
    }

    @Override
    public String getString() throws RepositoryException {
        this.checkSession();
        try {
            return this.context().getValueFactories().getStringFactory().create(this.property().getFirstValue());
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), e);
        }
    }

    @Override
    public Value getValue() throws RepositoryException {
        this.checkSession();
        return this.createValue(this.property().getFirstValue());
    }

    @Override
    public void setValue(Value value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkSession();
        this.checkForLock();
        JcrValue jcrValue = null;
        if (value instanceof JcrValue) {
            jcrValue = (JcrValue)value;
            jcrValue.asType(this.getType());
            this.editor().setProperty(this.name(), jcrValue);
            return;
        }
        if (value == null) {
            this.editor().removeProperty(this.name());
            return;
        }
        switch (value.getType()) {
            case 1: {
                this.setValue(value.getString());
                break;
            }
            case 2: {
                this.setValue(value.getBinary());
                break;
            }
            case 6: {
                this.setValue(value.getBoolean());
                break;
            }
            case 5: {
                this.setValue(value.getDate());
                break;
            }
            case 4: {
                this.setValue(value.getDouble());
                break;
            }
            case 12: {
                this.setValue(value.getDecimal());
                break;
            }
            case 3: {
                this.setValue(value.getLong());
                break;
            }
            case 7: {
                this.setValue(value.getString());
                break;
            }
            case 8: {
                this.setValue(value.getString());
                break;
            }
            case 9: {
                this.setValue(value.getString());
                break;
            }
            default: {
                throw new RepositoryException(JcrI18n.invalidPropertyType.text(value.getType()));
            }
        }
    }

    protected void setValue(JcrValue jcrValue) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        assert (jcrValue != null);
        this.checkSession();
        this.checkForLock();
        this.editor().setProperty(this.name(), jcrValue);
    }

    @Override
    public void setValue(String value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            this.remove();
            return;
        }
        this.setValue(this.createValue(value, 1).asType(this.getType()));
    }

    @Override
    public void setValue(InputStream value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            this.remove();
            return;
        }
        this.setValue(this.createValue(this.context().getValueFactories().getBinaryFactory().create(value), 2).asType(this.getType()));
    }

    @Override
    public void setValue(long value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.createValue(new Long(value), 3).asType(this.getType()));
    }

    @Override
    public void setValue(double value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.createValue(new Double(value), 4).asType(this.getType()));
    }

    @Override
    public void setValue(Calendar value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            this.remove();
            return;
        }
        this.setValue(this.createValue(this.context().getValueFactories().getDateFactory().create(value), 5).asType(this.getType()));
    }

    @Override
    public void setValue(boolean value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.createValue(new Boolean(value), 6).asType(this.getType()));
    }

    @Override
    public void setValue(Node value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            this.remove();
            return;
        }
        if (!value.isNodeType(JcrMixLexicon.REFERENCEABLE.getString(this.context().getNamespaceRegistry()))) {
            throw new javax.jcr.ValueFormatException(JcrI18n.nodeNotReferenceable.text(new Object[0]));
        }
        String uuid = value.getIdentifier();
        this.setValue(this.createValue(uuid, 9).asType(this.getType()));
    }

    @Override
    public void setValue(javax.jcr.Binary value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            this.remove();
            return;
        }
        Binary binary = null;
        binary = value instanceof JcrBinary ? ((JcrBinary)value).binary() : (Binary)this.session().getExecutionContext().getValueFactories().getBinaryFactory().create(this.getStream(), value.getSize());
        this.setValue(this.createValue(binary, 2).asType(this.getType()));
    }

    @Override
    public void setValue(BigDecimal value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            this.remove();
            return;
        }
        this.setValue(this.createValue(value, 12).asType(this.getType()));
    }

    @Override
    public Value[] getValues() throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForSingleValuedProperty.text(new Object[0]));
    }

    @Override
    public void setValue(Value[] values) throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForSingleValuedProperty.text(new Object[0]));
    }

    @Override
    public void setValue(String[] values) throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForSingleValuedProperty.text(new Object[0]));
    }
}

