/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.modeshape.common.util.CheckArg;

public class JcrTools {
    public int removeAllChildren(Node node) throws RepositoryException {
        CheckArg.isNotNull(node, "node");
        int childrenRemoved = 0;
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            child.remove();
            ++childrenRemoved;
        }
        return childrenRemoved;
    }

    public Node getNode(Node node, String relativePath, boolean required) throws RepositoryException {
        Node result;
        block2: {
            CheckArg.isNotNull(node, "node");
            CheckArg.isNotNull(relativePath, "relativePath");
            result = null;
            try {
                result = node.getNode(relativePath);
            }
            catch (PathNotFoundException e) {
                if (!required) break block2;
                throw e;
            }
        }
        return result;
    }

    public String getReadable(Node node) {
        if (node == null) {
            return "";
        }
        try {
            return node.getPath();
        }
        catch (RepositoryException err) {
            return node.toString();
        }
    }

    public Node findOrCreateNode(Session session, String path) throws RepositoryException {
        return this.findOrCreateNode(session, path, null, null);
    }

    public Node findOrCreateNode(Session session, String path, String nodeType) throws RepositoryException {
        return this.findOrCreateNode(session, path, nodeType, nodeType);
    }

    public Node findOrCreateNode(Session session, String path, String defaultNodeType, String finalNodeType) throws RepositoryException {
        CheckArg.isNotNull(session, "session");
        Node root = session.getRootNode();
        return this.findOrCreateNode(root, path, defaultNodeType, finalNodeType);
    }

    public Node findOrCreateNode(Node parentNode, String path, String defaultNodeType, String finalNodeType) throws RepositoryException {
        CheckArg.isNotNull(parentNode, "parentNode");
        CheckArg.isNotNull(path, "path");
        String relPath = path.replaceAll("^/+", "").replaceAll("/+$", "");
        try {
            return parentNode.getNode(relPath);
        }
        catch (PathNotFoundException e) {
            String[] pathSegments = relPath.split("/");
            Node node = parentNode;
            int len = pathSegments.length;
            for (int i = 0; i != len; ++i) {
                String pathSegment = pathSegments[i];
                if ((pathSegment = pathSegment.trim()).length() == 0) continue;
                if (node.hasNode(pathSegment)) {
                    node = node.getNode(pathSegment);
                    continue;
                }
                String pathSegmentWithNoIndex = pathSegment.replaceAll("(\\[\\d+\\])+$", "");
                String nodeType = defaultNodeType;
                if (i == len - 1 && finalNodeType != null) {
                    nodeType = finalNodeType;
                }
                node = nodeType != null ? node.addNode(pathSegmentWithNoIndex, nodeType) : node.addNode(pathSegmentWithNoIndex);
            }
            return node;
        }
    }

    public Node findOrCreateChild(Node parent, String name) throws RepositoryException {
        return this.findOrCreateChild(parent, name, null);
    }

    public Node findOrCreateChild(Node parent, String name, String nodeType) throws RepositoryException {
        return this.findOrCreateNode(parent, name, nodeType, nodeType);
    }
}

