/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.util.IoUtil;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.BinaryFactory;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.jcr.JcrBinary;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.SelfClosingInputStream;
import org.modeshape.jcr.SessionCache;
import org.modeshape.jcr.api.Value;

@NotThreadSafe
final class JcrValue
implements javax.jcr.Value,
Value {
    static final JcrValue[] EMPTY_ARRAY = new JcrValue[0];
    private final SessionCache sessionCache;
    private final ValueFactories valueFactories;
    private final int type;
    private final Object value;
    private InputStream asStream = null;

    JcrValue(ValueFactories valueFactories, SessionCache sessionCache, int type, Object value) {
        assert (valueFactories != null);
        assert (type == 2 || type == 6 || type == 5 || type == 12 || type == 4 || type == 3 || type == 7 || type == 8 || type == 9 || type == 10 || type == 1 || type == 11) : "Unxpected PropertyType: " + PropertyType.nameFromValue(type) + " for value " + (value == null ? "null" : "\"" + value + "\"");
        assert (value != null);
        this.valueFactories = valueFactories;
        this.sessionCache = sessionCache;
        this.type = type;
        this.value = value instanceof JcrBinary ? ((JcrBinary)value).binary() : value;
    }

    JcrValue(ValueFactories valueFactories, SessionCache sessionCache, javax.jcr.Value value) throws RepositoryException {
        assert (value != null);
        this.valueFactories = valueFactories;
        this.sessionCache = sessionCache;
        this.type = value.getType();
        this.value = this.valueToType(this.type, value);
    }

    private javax.jcr.ValueFormatException createValueFormatException(Class<?> type) {
        return new javax.jcr.ValueFormatException(JcrI18n.cannotConvertValue.text(this.value.getClass().getSimpleName(), type.getSimpleName()));
    }

    private javax.jcr.ValueFormatException createValueFormatException(ValueFormatException vfe) {
        return new javax.jcr.ValueFormatException(vfe);
    }

    final Object value() {
        return this.value;
    }

    final SessionCache sessionCache() {
        return this.sessionCache;
    }

    @Override
    public boolean getBoolean() throws javax.jcr.ValueFormatException {
        try {
            boolean convertedValue = this.valueFactories.getBooleanFactory().create(this.value);
            return convertedValue;
        }
        catch (RuntimeException error) {
            throw this.createValueFormatException(Boolean.TYPE);
        }
    }

    @Override
    public Calendar getDate() throws javax.jcr.ValueFormatException {
        try {
            Calendar convertedValue = ((DateTime)this.valueFactories.getDateFactory().create(this.value)).toCalendar();
            return convertedValue;
        }
        catch (RuntimeException error) {
            throw this.createValueFormatException(Calendar.class);
        }
    }

    @Override
    public BigDecimal getDecimal() throws javax.jcr.ValueFormatException, RepositoryException {
        try {
            BigDecimal convertedValue = this.valueFactories.getDecimalFactory().create(this.value);
            return convertedValue;
        }
        catch (RuntimeException error) {
            throw this.createValueFormatException(Double.TYPE);
        }
    }

    @Override
    public double getDouble() throws javax.jcr.ValueFormatException {
        try {
            double convertedValue = this.valueFactories.getDoubleFactory().create(this.value);
            return convertedValue;
        }
        catch (RuntimeException error) {
            throw this.createValueFormatException(Double.TYPE);
        }
    }

    long getLength() throws RepositoryException {
        if (this.type == 2) {
            return ((Binary)this.valueFactories.getBinaryFactory().create(this.value)).getSize();
        }
        return this.getString().length();
    }

    @Override
    public long getLong() throws javax.jcr.ValueFormatException {
        try {
            long convertedValue = this.valueFactories.getLongFactory().create(this.value);
            return convertedValue;
        }
        catch (RuntimeException error) {
            throw this.createValueFormatException(Long.TYPE);
        }
    }

    @Override
    public InputStream getStream() throws javax.jcr.ValueFormatException {
        try {
            if (this.asStream == null) {
                Binary binary = (Binary)this.valueFactories.getBinaryFactory().create(this.value);
                this.asStream = new SelfClosingInputStream(binary);
            }
            return this.asStream;
        }
        catch (RuntimeException error) {
            throw this.createValueFormatException(InputStream.class);
        }
    }

    @Override
    public javax.jcr.Binary getBinary() throws RepositoryException {
        try {
            Binary binary = (Binary)this.valueFactories.getBinaryFactory().create(this.value);
            return new JcrBinary(binary);
        }
        catch (RuntimeException error) {
            throw this.createValueFormatException(InputStream.class);
        }
    }

    @Override
    public String getString() throws javax.jcr.ValueFormatException {
        try {
            String convertedValue = this.valueFactories.getStringFactory().create(this.value);
            return convertedValue;
        }
        catch (RuntimeException error) {
            throw this.createValueFormatException(String.class);
        }
    }

    @Override
    public int getType() {
        return this.type;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JcrValue) {
            JcrValue that = (JcrValue)obj;
            if (this.type != that.type) {
                return false;
            }
            try {
                switch (this.type) {
                    case 1: {
                        return this.getString().equals(that.getString());
                    }
                    case 2: {
                        BinaryFactory binaryFactory = this.valueFactories.getBinaryFactory();
                        Binary thisValue = (Binary)binaryFactory.create(this.value);
                        Binary thatValue = (Binary)binaryFactory.create(that.value);
                        return thisValue.equals(thatValue);
                    }
                    case 6: {
                        return this.getBoolean() == that.getBoolean();
                    }
                    case 4: {
                        return this.getDouble() == that.getDouble();
                    }
                    case 3: {
                        return this.getLong() == that.getLong();
                    }
                    case 12: {
                        return this.getDecimal().equals(that.getDecimal());
                    }
                    case 5: {
                        DateTimeFactory dateFactory = this.valueFactories.getDateFactory();
                        DateTime thisDateValue = (DateTime)dateFactory.create(this.value);
                        DateTime thatDateValue = (DateTime)dateFactory.create(that.value);
                        return thisDateValue.equals(thatDateValue);
                    }
                    case 8: {
                        PathFactory pathFactory = this.valueFactories.getPathFactory();
                        Path thisPathValue = (Path)pathFactory.create(this.value);
                        Path thatPathValue = (Path)pathFactory.create(that.value);
                        return thisPathValue.equals(thatPathValue);
                    }
                    case 7: {
                        NameFactory nameFactory = this.valueFactories.getNameFactory();
                        Name thisNameValue = (Name)nameFactory.create(this.value);
                        Name thatNameValue = (Name)nameFactory.create(that.value);
                        return thisNameValue.equals(thatNameValue);
                    }
                    case 9: 
                    case 10: {
                        return this.getString().equals(that.getString());
                    }
                }
                throw new SystemFailureException(JcrI18n.invalidPropertyType.text(this.type));
            }
            catch (RepositoryException e) {
                return false;
            }
        }
        if (obj instanceof javax.jcr.Value) {
            javax.jcr.Value that = (javax.jcr.Value)obj;
            if (this.type != that.getType()) {
                return false;
            }
            try {
                switch (this.type) {
                    case 1: {
                        return this.getString().equals(that.getString());
                    }
                    case 2: {
                        return IoUtil.isSame(this.getStream(), that.getBinary().getStream());
                    }
                    case 6: {
                        return this.getBoolean() == that.getBoolean();
                    }
                    case 4: {
                        return this.getDouble() == that.getDouble();
                    }
                    case 3: {
                        return this.getLong() == that.getLong();
                    }
                    case 12: {
                        return this.getDecimal().equals(that.getDecimal());
                    }
                    case 5: {
                        return this.getDate().equals(that.getDate());
                    }
                    case 8: {
                        return this.getString().equals(that.getString());
                    }
                    case 7: {
                        return this.getString().equals(that.getString());
                    }
                    case 9: {
                        return this.getString().equals(that.getString());
                    }
                }
                throw new SystemFailureException(JcrI18n.invalidPropertyType.text(this.type));
            }
            catch (IOException e) {
                return false;
            }
            catch (RepositoryException e) {
                return false;
            }
        }
        return false;
    }

    private JcrValue withTypeAndValue(int type, Object value) {
        return new JcrValue(this.valueFactories, this.sessionCache, type, value);
    }

    JcrValue asType(int type) throws javax.jcr.ValueFormatException {
        if (type == this.type) {
            return this.withTypeAndValue(this.type, this.value);
        }
        Object value = this.value;
        switch (type) {
            case 6: {
                if (this.type != 1 && this.type != 2) {
                    throw this.createValueFormatException(Boolean.TYPE);
                }
                try {
                    return this.withTypeAndValue(type, this.valueFactories.getBooleanFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 5: {
                if (this.type != 1 && this.type != 2 && this.type != 4 && this.type != 3) {
                    throw this.createValueFormatException(Calendar.class);
                }
                try {
                    return this.withTypeAndValue(type, this.valueFactories.getDateFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 7: {
                if (this.type != 1 && this.type != 2 && this.type != 8) {
                    throw this.createValueFormatException(Name.class);
                }
                try {
                    return this.withTypeAndValue(type, this.valueFactories.getNameFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 8: {
                if (this.type != 1 && this.type != 2 && this.type != 7) {
                    throw this.createValueFormatException(Path.class);
                }
                try {
                    return this.withTypeAndValue(type, this.valueFactories.getPathFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 9: 
            case 10: {
                if (this.type != 1 && this.type != 2) {
                    throw this.createValueFormatException(Node.class);
                }
                try {
                    return this.withTypeAndValue(type, this.valueFactories.getReferenceFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 4: {
                if (this.type != 1 && this.type != 2 && this.type != 3 && this.type != 5) {
                    throw this.createValueFormatException(Double.TYPE);
                }
                try {
                    return this.withTypeAndValue(type, this.valueFactories.getDoubleFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 3: {
                if (this.type != 1 && this.type != 2 && this.type != 4 && this.type != 5) {
                    throw this.createValueFormatException(Long.TYPE);
                }
                try {
                    return this.withTypeAndValue(type, this.valueFactories.getLongFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 12: {
                if (this.type != 1 && this.type != 2 && this.type != 4 && this.type != 3 && this.type != 5) {
                    throw this.createValueFormatException(BigDecimal.class);
                }
                try {
                    return this.withTypeAndValue(type, this.valueFactories.getDecimalFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 11: {
                if (this.type != 1 && this.type != 2 && this.type != 11) {
                    throw this.createValueFormatException(URI.class);
                }
                try {
                    return this.withTypeAndValue(type, this.valueFactories.getUriFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 2: {
                try {
                    return this.withTypeAndValue(type, this.valueFactories.getBinaryFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 1: {
                try {
                    return this.withTypeAndValue(type, this.valueFactories.getStringFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 0: {
                return this.withTypeAndValue(this.type, this.value);
            }
        }
        assert (false) : "Unexpected JCR property type " + type;
        throw new IllegalStateException("Invalid property type " + type);
    }

    protected Object valueToType(int type, javax.jcr.Value value) throws RepositoryException {
        switch (type) {
            case 6: {
                return this.valueFactories.getBooleanFactory().create(value.getBoolean());
            }
            case 5: {
                return this.valueFactories.getDateFactory().create(value.getDate());
            }
            case 7: {
                return this.valueFactories.getNameFactory().create(value.getString());
            }
            case 8: {
                return this.valueFactories.getPathFactory().create(value.getString());
            }
            case 9: 
            case 10: {
                return this.valueFactories.getReferenceFactory().create(value.getString());
            }
            case 4: {
                return this.valueFactories.getDoubleFactory().create(value.getDouble());
            }
            case 3: {
                return this.valueFactories.getLongFactory().create(value.getLong());
            }
            case 12: {
                return this.valueFactories.getDecimalFactory().create(value.getDecimal());
            }
            case 11: {
                return this.valueFactories.getUriFactory().create(value.getString());
            }
            case 2: {
                return this.valueFactories.getBinaryFactory().create(value.getBinary());
            }
            case 1: {
                return this.valueFactories.getStringFactory().create(value.getString());
            }
            case 0: {
                return value.getString();
            }
        }
        assert (false) : "Unexpected JCR property type " + type;
        throw new IllegalStateException("Invalid property type " + type);
    }

    public String toString() {
        return (this.value == null ? "null" : this.value.toString()) + " (" + PropertyType.nameFromValue(this.type) + ")";
    }
}

