/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.modeshape.common.text.TokenStream;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.query.model.ArithmeticOperator;
import org.modeshape.graph.query.model.Between;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.FullTextSearch;
import org.modeshape.graph.query.model.JoinCondition;
import org.modeshape.graph.query.model.JoinType;
import org.modeshape.graph.query.model.Length;
import org.modeshape.graph.query.model.Limit;
import org.modeshape.graph.query.model.Operator;
import org.modeshape.graph.query.model.Order;
import org.modeshape.graph.query.model.Ordering;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.SetCriteria;
import org.modeshape.graph.query.model.SetQuery;
import org.modeshape.graph.query.model.Source;
import org.modeshape.graph.query.model.StaticOperand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.parse.SqlQueryParser;
import org.modeshape.jcr.query.JcrTypeSystem;
import org.modeshape.jcr.query.qom.JcrAnd;
import org.modeshape.jcr.query.qom.JcrArithmeticOperand;
import org.modeshape.jcr.query.qom.JcrBetween;
import org.modeshape.jcr.query.qom.JcrBindVariableName;
import org.modeshape.jcr.query.qom.JcrChildNode;
import org.modeshape.jcr.query.qom.JcrChildNodeJoinCondition;
import org.modeshape.jcr.query.qom.JcrColumn;
import org.modeshape.jcr.query.qom.JcrComparison;
import org.modeshape.jcr.query.qom.JcrConstraint;
import org.modeshape.jcr.query.qom.JcrDescendantNode;
import org.modeshape.jcr.query.qom.JcrDescendantNodeJoinCondition;
import org.modeshape.jcr.query.qom.JcrDynamicOperand;
import org.modeshape.jcr.query.qom.JcrEquiJoinCondition;
import org.modeshape.jcr.query.qom.JcrFullTextSearch;
import org.modeshape.jcr.query.qom.JcrFullTextSearchScore;
import org.modeshape.jcr.query.qom.JcrJoin;
import org.modeshape.jcr.query.qom.JcrJoinCondition;
import org.modeshape.jcr.query.qom.JcrLength;
import org.modeshape.jcr.query.qom.JcrLimit;
import org.modeshape.jcr.query.qom.JcrLiteral;
import org.modeshape.jcr.query.qom.JcrLowerCase;
import org.modeshape.jcr.query.qom.JcrNamedSelector;
import org.modeshape.jcr.query.qom.JcrNodeDepth;
import org.modeshape.jcr.query.qom.JcrNodeLocalName;
import org.modeshape.jcr.query.qom.JcrNodeName;
import org.modeshape.jcr.query.qom.JcrNodePath;
import org.modeshape.jcr.query.qom.JcrNot;
import org.modeshape.jcr.query.qom.JcrOr;
import org.modeshape.jcr.query.qom.JcrOrdering;
import org.modeshape.jcr.query.qom.JcrPropertyExistence;
import org.modeshape.jcr.query.qom.JcrPropertyValue;
import org.modeshape.jcr.query.qom.JcrQueryCommand;
import org.modeshape.jcr.query.qom.JcrReferenceValue;
import org.modeshape.jcr.query.qom.JcrSameNode;
import org.modeshape.jcr.query.qom.JcrSameNodeJoinCondition;
import org.modeshape.jcr.query.qom.JcrSelectQuery;
import org.modeshape.jcr.query.qom.JcrSetCriteria;
import org.modeshape.jcr.query.qom.JcrSetQuery;
import org.modeshape.jcr.query.qom.JcrSource;
import org.modeshape.jcr.query.qom.JcrStaticOperand;
import org.modeshape.jcr.query.qom.JcrUpperCase;

public class JcrSql2QueryParser
extends SqlQueryParser {
    public static final String LANGUAGE = "JCR-SQL2";

    @Override
    public String getLanguage() {
        return LANGUAGE;
    }

    @Override
    protected JcrNamedSelector parseNamedSelector(TokenStream tokens, TypeSystem typeSystem) {
        return new JcrNamedSelector(super.parseNamedSelector(tokens, typeSystem));
    }

    @Override
    protected JcrSelectQuery query(Source source, Constraint constraint, List<? extends Ordering> orderings, List<? extends Column> columns, Limit limit, boolean distinct) {
        return new JcrSelectQuery((JcrSource)source, (JcrConstraint)constraint, this.orderings(orderings), this.columns(columns), (JcrLimit)limit, distinct);
    }

    @Override
    protected JcrSetQuery setQuery(QueryCommand leftQuery, SetQuery.Operation operation, QueryCommand rightQuery, boolean all) {
        return new JcrSetQuery((JcrQueryCommand)leftQuery, operation, (JcrQueryCommand)rightQuery, all);
    }

    protected List<JcrColumn> columns(List<? extends Column> columns) {
        ArrayList<JcrColumn> jcrColumns = new ArrayList<JcrColumn>();
        for (Column column : columns) {
            jcrColumns.add((JcrColumn)column);
        }
        return jcrColumns;
    }

    protected List<JcrOrdering> orderings(List<? extends Ordering> orderings) {
        if (orderings == null) {
            return null;
        }
        ArrayList<JcrOrdering> jcrOrderings = new ArrayList<JcrOrdering>();
        for (Ordering ordering : orderings) {
            jcrOrderings.add((JcrOrdering)ordering);
        }
        return jcrOrderings;
    }

    @Override
    protected SetQuery parseSetQuery(TokenStream tokens, QueryCommand leftHandSide, TypeSystem typeSystem) {
        SetQuery query = super.parseSetQuery(tokens, leftHandSide, typeSystem);
        JcrQueryCommand left = (JcrQueryCommand)query.left();
        JcrQueryCommand right = (JcrQueryCommand)query.right();
        List<JcrOrdering> orderings = this.orderings(query.orderings());
        JcrLimit limit = (JcrLimit)query.limits();
        return new JcrSetQuery(left, query.operation(), right, query.isAll(), orderings, limit);
    }

    @Override
    protected Length length(PropertyValue propertyValue) {
        return new JcrLength((JcrPropertyValue)propertyValue);
    }

    @Override
    protected JcrLowerCase lowerCase(DynamicOperand operand) {
        return new JcrLowerCase((JcrDynamicOperand)operand);
    }

    @Override
    protected JcrUpperCase upperCase(DynamicOperand operand) {
        return new JcrUpperCase((JcrDynamicOperand)operand);
    }

    @Override
    protected JcrNodeName nodeName(SelectorName selector) {
        return new JcrNodeName(selector);
    }

    @Override
    protected JcrNodeLocalName nodeLocalName(SelectorName selector) {
        return new JcrNodeLocalName(selector);
    }

    @Override
    protected JcrNodeDepth nodeDepth(SelectorName selector) {
        return new JcrNodeDepth(selector);
    }

    @Override
    protected JcrNodePath nodePath(SelectorName selector) {
        return new JcrNodePath(selector);
    }

    @Override
    protected JcrEquiJoinCondition equiJoinCondition(SelectorName selector1, String property1, SelectorName selector2, String property2) {
        return new JcrEquiJoinCondition(selector1, property1, selector2, property2);
    }

    @Override
    protected JcrDescendantNodeJoinCondition descendantNodeJoinCondition(SelectorName ancestor, SelectorName descendant) {
        return new JcrDescendantNodeJoinCondition(ancestor, descendant);
    }

    @Override
    protected JcrChildNodeJoinCondition childNodeJoinCondition(SelectorName parent, SelectorName child) {
        return new JcrChildNodeJoinCondition(parent, child);
    }

    @Override
    protected JcrSameNodeJoinCondition sameNodeJoinCondition(SelectorName selector1, SelectorName selector2) {
        return new JcrSameNodeJoinCondition(selector1, selector2);
    }

    @Override
    protected JcrSameNodeJoinCondition sameNodeJoinCondition(SelectorName selector1, SelectorName selector2, String path) {
        return new JcrSameNodeJoinCondition(selector1, selector2, path);
    }

    @Override
    protected JcrLimit limit(int rowCount, int offset) {
        return new JcrLimit(rowCount, offset);
    }

    @Override
    protected JcrColumn column(SelectorName selectorName, String propertyName, String columnName) {
        return new JcrColumn(selectorName, propertyName, columnName);
    }

    @Override
    protected JcrJoin join(Source left, JoinType joinType, Source right, JoinCondition joinCondition) {
        return new JcrJoin((JcrSource)left, joinType, (JcrSource)right, (JcrJoinCondition)joinCondition);
    }

    @Override
    protected JcrNot not(Constraint constraint) {
        return new JcrNot((JcrConstraint)constraint);
    }

    @Override
    protected JcrAnd and(Constraint constraint1, Constraint constraint2) {
        return new JcrAnd((JcrConstraint)constraint1, (JcrConstraint)constraint2);
    }

    @Override
    protected JcrOr or(Constraint constraint1, Constraint constraint2) {
        return new JcrOr((JcrConstraint)constraint1, (JcrConstraint)constraint2);
    }

    @Override
    protected JcrFullTextSearch fullTextSearch(SelectorName name, String propertyName, String expression, FullTextSearch.Term term) {
        return new JcrFullTextSearch(name, propertyName, expression, term);
    }

    @Override
    protected JcrSameNode sameNode(SelectorName name, String path) {
        return new JcrSameNode(name, path);
    }

    @Override
    protected JcrChildNode childNode(SelectorName name, String path) {
        return new JcrChildNode(name, path);
    }

    @Override
    protected JcrDescendantNode descendantNode(SelectorName name, String path) {
        return new JcrDescendantNode(name, path);
    }

    @Override
    protected JcrComparison comparison(DynamicOperand left, Operator operator, StaticOperand right) {
        return new JcrComparison((JcrDynamicOperand)left, operator, (JcrStaticOperand)right);
    }

    @Override
    protected JcrOrdering ordering(DynamicOperand operand, Order order) {
        return new JcrOrdering((JcrDynamicOperand)operand, order);
    }

    @Override
    protected JcrPropertyExistence propertyExistence(SelectorName selector, String propertyName) {
        return new JcrPropertyExistence(selector, propertyName);
    }

    @Override
    protected JcrFullTextSearchScore fullTextSearchScore(SelectorName selector) {
        return new JcrFullTextSearchScore(selector);
    }

    @Override
    protected Between between(DynamicOperand operand, StaticOperand lowerBound, StaticOperand upperBound, boolean lowerInclusive, boolean upperInclusive) {
        return new JcrBetween((JcrDynamicOperand)operand, (JcrStaticOperand)lowerBound, (JcrStaticOperand)upperBound, lowerInclusive, upperInclusive);
    }

    @Override
    protected SetCriteria setCriteria(DynamicOperand operand, Collection<? extends StaticOperand> values) {
        return new JcrSetCriteria((JcrDynamicOperand)operand, values);
    }

    @Override
    protected JcrArithmeticOperand arithmeticOperand(DynamicOperand leftOperand, ArithmeticOperator operator, DynamicOperand rightOperand) {
        return new JcrArithmeticOperand((JcrDynamicOperand)leftOperand, operator, (JcrDynamicOperand)rightOperand);
    }

    @Override
    protected JcrPropertyValue propertyValue(SelectorName selector, String propertyName) {
        return new JcrPropertyValue(selector, propertyName);
    }

    @Override
    protected JcrReferenceValue referenceValue(SelectorName selector) {
        return new JcrReferenceValue(selector, null);
    }

    @Override
    protected JcrReferenceValue referenceValue(SelectorName selector, String propertyName) {
        return new JcrReferenceValue(selector, propertyName);
    }

    @Override
    protected JcrBindVariableName bindVariableName(String variableName) {
        return new JcrBindVariableName(variableName);
    }

    @Override
    protected JcrLiteral literal(TypeSystem typeSystem, Object value) throws ValueFormatException {
        ValueFactory factory = ((JcrTypeSystem)typeSystem).getValueFactory();
        Value jcrValue = null;
        if (value instanceof String) {
            jcrValue = factory.createValue((String)value);
        } else if (value instanceof Boolean) {
            jcrValue = factory.createValue((Boolean)value);
        } else if (value instanceof Binary) {
            jcrValue = factory.createValue((Binary)value);
        } else if (value instanceof DateTime) {
            jcrValue = factory.createValue(((DateTime)value).toCalendar());
        } else if (value instanceof Calendar) {
            jcrValue = factory.createValue((Calendar)value);
        } else if (value instanceof BigDecimal) {
            jcrValue = factory.createValue((BigDecimal)value);
        } else if (value instanceof Double) {
            jcrValue = factory.createValue((Double)value);
        } else if (value instanceof Long) {
            jcrValue = factory.createValue((Long)value);
        } else if (value instanceof InputStream) {
            try {
                Binary binary = factory.createBinary((InputStream)value);
                jcrValue = factory.createValue(binary);
            }
            catch (RepositoryException e) {
                throw new ValueFormatException(value, PropertyType.BINARY, e.getMessage());
            }
        } else if (value instanceof Node) {
            try {
                jcrValue = factory.createValue((Node)value);
            }
            catch (RepositoryException e) {
                throw new ValueFormatException(value, PropertyType.REFERENCE, e.getMessage());
            }
        } else {
            jcrValue = factory.createValue(value.toString());
        }
        return new JcrLiteral(jcrValue, value);
    }
}

