/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.sql.DriverPropertyInfo;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;

public abstract class ConnectionInfo {
    private String url;
    private Properties properties;

    protected ConnectionInfo(String url, Properties properties) {
        this.url = url;
        this.properties = properties;
    }

    public String getUrl() {
        return this.url;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getRepositoryName() {
        return this.properties.getProperty("repositoryName");
    }

    void setRepositoryName(String repositoryName) {
        this.properties.setProperty("repositoryName", repositoryName);
    }

    public String getWorkspaceName() {
        return this.properties.getProperty("workspace");
    }

    public String getUsername() {
        return this.properties.getProperty("username");
    }

    public char[] getPassword() {
        String result = this.properties.getProperty("password");
        return result != null ? result.toCharArray() : null;
    }

    void setUrl(String url) {
        this.url = url;
    }

    void setProperties(Properties properties) {
        this.properties = properties;
    }

    public abstract String getEffectiveUrl();

    public abstract DriverPropertyInfo[] getPropertyInfos();

    public Credentials getCredentials() {
        String username = this.getUsername();
        char[] password = this.getPassword();
        if (username != null) {
            return new SimpleCredentials(username, password);
        }
        return null;
    }
}

